package com.colectivosvip.schindler.service.messenger.incoming;

import android.content.Context;
import android.os.Message;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.messenger.service.incoming.MessengerIncomingHandler;
import com.colectivosvip.schindler.Constants;

/**
 * Handler for incoming messages from clients.
 * 
 * @author JavocSoft, 2015
 * @version 1.0<br>
 * $Rev: 804 $<br>
 * $LastChangedDate: 2015-11-05 18:23:15 +0100 (jue, 05 nov 2015) $<br>
 * $LastChangedBy: admin $
 */
public class MyMessengerIncomingHandler extends MessengerIncomingHandler {

	
	public MyMessengerIncomingHandler(Context context) {
		super(context);		
	}
	
	//Messenger WHAT possible values.
	public static final int MSG_EVT_HI = 1000;
	
	
	@Override
	protected void doWork(Message msg) {
		switch (msg.what) {
		case MSG_EVT_HI:
			Log.i(Constants.TAG, "Messenger received: Hi!!");			
			break;
		default:
			Log.i(Constants.TAG, "Messenger unrecognized received message: [" + msg.what + "].");
		}
	}	
}
