package com.colectivosvip.schindler.service;

import android.app.IntentService;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import com.colectivosvip.schindler.ApplicationBase;
import com.colectivosvip.schindler.Constants;
import com.colectivosvip.schindler.receiver.SimpleWakefulReceiver;

/**
 * The service (an IntentService) does some work. When it is finished, it 
 * releases the wake lock by calling completeWakefulIntent(intent). The 
 * intent it passes as a parameter is the same intent that the 
 * WakefulBroadcastReceiver originally passed in.
 * <br><br>
 * To enable it, declare in the AndroidManifest.xml:<br><br>
 * 
 *	&lt;service android:name="com.colectivosvip.schindler.service.SimpleWakefulService"<br> 
 *		     	 android:label="Simple Wakeful Service"<br>
 *		     	 android:icon="@drawable/ic_lib"<br> 
 *		     	 android:enabled="true"/&gt;
 *<br><br>
 * NOTES:<br><br>
 * Remember that if you need to show something in the UI you must deliver
 * a broadcast to some receiver and do the UI operations there.
 * 
 * @author JavocSoft 2013
 * @version 2.0<br>
 * $Rev: 816 $<br>
 * $LastChangedDate: 2015-11-30 15:03:36 +0100 (lun, 30 nov 2015) $<br>
 * $LastChangedBy: admin $
 *
 */
public class SimpleWakefulService extends IntentService {

	public SimpleWakefulService(String name) {
		super(name);		
	}

	@Override
	protected void onHandleIntent(Intent intent) {
		// At this point SimpleWakefulReceiver is still holding a wake lock
        // for us.  We can do whatever we need to here and then tell it that
        // it can release the wakelock.  This sample just does some slow work,
        // but more complicated implementations could take their own wake
        // lock here before releasing the receiver's.
        //
        // Note that when using this approach you should be aware that if your
        // service gets killed and restarted while in the middle of such work
        // (so the Intent gets re-delivered to perform the work again), it will
        // at that point no longer be holding a wake lock since we are depending
        // on SimpleWakefulReceiver to that for us.  If this is a concern, you can
        // acquire a separate wake lock here.
        for (int i=0; i<5; i++) {
            Log.i("SimpleWakefulReceiver", "Running service " + (i+1)
                    + "/5 @ " + SystemClock.elapsedRealtime());
            try {
                Thread.sleep(5000);
            } catch (InterruptedException e) {
            }
        }
        if(ApplicationBase.debugMode)
        	Log.d(Constants.TAG, "Completed Wakeful service @ " + SystemClock.elapsedRealtime());
        SimpleWakefulReceiver.completeWakefulIntent(intent);
	}

}
