package com.colectivosvip.schindler.receiver.proximity;

import java.util.Calendar;

import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import com.colectivosvip.schindler.ApplicationBase;
import com.colectivosvip.schindler.Constants;
import com.colectivosvip.schindler.prompt.PromptLocattionAlertsConfigure;
import com.colectivosvip.schindler.service.LocationChangeWakefulService;
import com.colectivosvip.schindler.service.proximity.LocationProximityService;
import com.colectivosvip.schindler.sqllite.SQLite;
import com.colectivosvip.schindler.sqllite.tables.DBLocation;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.location.service.LocationService;


/**
 * A receiver to get location service updates into the app.
 * 
 * @author JavocSoft 2016
 * @version 2.0<br>
 * $Rev: 875 $<br>
 * $LastChangedDate: 2016-12-15 18:50:05 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
public class LocationProximityChangedReceiver extends WakefulBroadcastReceiver {
	
	public static final String LOCATION_KEY = "location";
	protected static String TAG = "LocationProximityChangedReceiver";
	
	public static final String ACTION_LOCATION_NOTIFICATION = "com.colectivosvip.schindler.receiver.proximity.LOCATION_PROXIMITY_NOTIFICATION_ACTION";
	
	public static final String LOCATION_NOTIFICATION_KEY_NOTID = "NOTIFICATION_ID";
	public static final String LOCATION_NOTIFICATION_KEY_ACTION = "NOTIFICATION_USER_ACTION";
	public static final String LOCATION_NOTIFICATION_KEY_LOCATIONID = "NOTIFICATION_LOCATION_DB_ROW_ID";
	
	public static final int LOCATION_NOTIFICATION_ACTION_NOT_REMIND = 1;
	public static final int LOCATION_NOTIFICATION_ACTION_CLOSE = 2;	
	public static final int LOCATION_NOTIFICATION_ACTION_CONFIGURE = 3;
	
	public LocationProximityChangedReceiver() {
		
	}

	@Override
	public void onReceive(final Context context, Intent intent) {
		
		if(ApplicationBase.debugMode)
			Log.d(Constants.TAG, "LocationProximityChangedReceiver intent@action Received: [" + intent.getAction() + "].");
		
		Bundle bundle = intent.getExtras();		
		if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED") || 
				intent.getAction().equals("android.intent.action.QUICKBOOT_POWERON")) {
			//We should start the proximity service only if this service is enabled or was accesed
			//before (see Constants.PREF_KEY__DISCOUNT_MAP_ACCESSED)
			if(ApplicationBase.enableLocationProximityService) {
				((ApplicationBase)context.getApplicationContext()).startProximityLocationService(true);
				if(ApplicationBase.debugMode)
		        	Log.d(Constants.TAG, "Starting LocationProximityService after BOOT.");
			}else{
				if(ApplicationBase.debugMode)
		        	Log.d(Constants.TAG, "LocationProximityService not started after BOOT (svc enabled =  FALSE).");
			}
		}else if(intent.getAction().equals(LocationProximityService.ACTION_LOCATION_CHANGED)) {
			// Because the operation can take long, we operate in a separate IntentService
			// to avoid these long operation in the main UI thread. When finishes, 
			// call to completeWakefulIntent(intent) of the receiver.
			// 
			// This is the Intent to deliver to our service.			
			if(checkCommercialTime()) { //We do not alert out of commercial timetable.
				Intent serviceIntent = new Intent(context, LocationChangeWakefulService.class);
		        bundle.putString(LocationChangeWakefulService.CALLING_SOURCE, LocationChangeWakefulService.CALLING_SOURCE_PROXIMITY_SERVICE);
		        serviceIntent.putExtras(bundle);
		        // Start the service, keeping the device awake while it is launching.
		        if(ApplicationBase.debugMode)
		        	Log.d(Constants.TAG, "Starting LocationProximityChangedReceiver service @ " + SystemClock.elapsedRealtime());
		        //startWakefulService(context, serviceIntent);
		        context.startService(serviceIntent);
			}else{
				if(ApplicationBase.debugMode)
		        	Log.d(Constants.TAG, "LocationProximityChangedReceiver. Location change discarded. Not in commercial time.");
			}
		}else if(intent.getAction().equals(LocationService.ACTION_LOCATION_CHANGED)) {
			// Because the operation can take long, we operate in a separate IntentService
			// to avoid these long operation in the main UI thread. When finishes, 
			// call to completeWakefulIntent(intent) of the receiver.
			// 
			// This is the Intent to deliver to our service.
	        Intent serviceIntent = new Intent(context, LocationChangeWakefulService.class);
	        bundle.putString(LocationChangeWakefulService.CALLING_SOURCE, LocationChangeWakefulService.CALLING_SOURCE_LOCATION_SERVICE);
	        serviceIntent.putExtras(bundle);
	        // Start the service, keeping the device awake while it is launching.
	        if(ApplicationBase.debugMode)
	        	Log.d(Constants.TAG, "Starting LocationChangeWakefulService service @ " + SystemClock.elapsedRealtime());
	        startWakefulService(context, serviceIntent);
	        
		}else if(intent.getAction().equals(LocationProximityService.ACTION_LOCATION_GPS_ENABLED)){
			ApplicationBase.isGPSProviderEnabled = true;
		}else if(intent.getAction().equals(LocationProximityService.ACTION_LOCATION_GPS_DISABLED)){
			ApplicationBase.isGPSProviderEnabled = false;			
		
		}else if(intent.getAction().equals(LocationService.ACTION_LOCATION_SERVICE_STARTED)){
			ApplicationBase.locationServiceEnabled = true;
		}else if(intent.getAction().equals(LocationService.ACTION_LOCATION_SERVICE_SHUTDOWN)){
			//Reset location related variables.	        
	        ApplicationBase.locationServiceEnabled = false;
	        ApplicationBase.isGPSProviderEnabled = false;
	        ApplicationBase.location = null;	    
		
		}else if(intent.getAction().equals(LocationProximityService.ACTION_LOCATION_SERVICE_STARTED)){
			ApplicationBase.locationProximityServiceEnabled = true;			
		}else if(intent.getAction().equals(LocationProximityService.ACTION_LOCATION_SERVICE_SHUTDOWN)){
			//Reset location related variables.
	        ApplicationBase.locationProximityServiceEnabled = false;
	        ApplicationBase.locationServiceEnabled = false;
	        ApplicationBase.isGPSProviderEnabled = false;
	        ApplicationBase.location = null;
	       
		}else if(intent.getAction().equals(ACTION_LOCATION_NOTIFICATION)){
			//user selected an option in the location notification.
			
			//We close the notification
			ToolBox.notification_cancel(context, intent.getIntExtra(LOCATION_NOTIFICATION_KEY_NOTID,-1));
			
			//Do something
			int selectedAction = intent.getIntExtra(LOCATION_NOTIFICATION_KEY_ACTION,0);
			final long userDBLocationId = intent.getLongExtra(LOCATION_NOTIFICATION_KEY_LOCATIONID,0);
			
			switch (selectedAction) {
				case LOCATION_NOTIFICATION_ACTION_NOT_REMIND:
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "Do not remind selected");
					
					DBLocation dbLocation = SQLite.getInstance(context).getDBHelper().getLocation(userDBLocationId);
					if(dbLocation!=null) {
						if(SQLite.getInstance(context).getDBHelper().updateLocationRemindOption(dbLocation, 1)){
							if(ApplicationBase.debugMode)
								Log.d(Constants.TAG, "DB Location remind Option Updated!");
						}
					}
					break;				
				case LOCATION_NOTIFICATION_ACTION_CLOSE:
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "Close selected");
					break;
				case LOCATION_NOTIFICATION_ACTION_CONFIGURE:
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "Configure.");
					
					//Open prompt activity
					Intent i = new Intent(context.getApplicationContext(), PromptLocattionAlertsConfigure.class);
					i.putExtra(LOCATION_NOTIFICATION_KEY_LOCATIONID, userDBLocationId);
					i.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
					context.getApplicationContext().startActivity(i);
					break;
				default:
					break;
			}
			
			//Closes the system notification bar
			ToolBox.statusBarClose(context);
		}else if(intent.getAction().equals("android.location.PROVIDERS_CHANGED")){
			//This listen even if the application location service is shutdown. 
			final LocationManager manager = (LocationManager) context
					.getSystemService(Context.LOCATION_SERVICE);
			if(manager!=null) {
				//GPS STATUS		
				boolean isGPSProviderEnabled = manager.isProviderEnabled(LocationManager.GPS_PROVIDER);				
				//NETWORK STATUS
				boolean isNetworkProviderEnabled = manager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
				
				//We enable again the application location service
				if(isGPSProviderEnabled || isNetworkProviderEnabled) {
					if(ApplicationBase.permissionsLocationGranted &&
							ApplicationBase.enableLocation && 
				        	ApplicationBase.enableInitialLocation) {
							
							((ApplicationBase)context.getApplicationContext()).startProximityLocationService();
				    }
				}else{
					//In this case the application could be terminated and removed from the
					//back stack.
					if(ApplicationBase.appWebJSInterface!=null && ApplicationBase.enableLocationWebResetOnGPSDisabled)
						ApplicationBase.appWebJSInterface.androidAppInformLocationToWeb(true, false);					 
				}
			} 
		}
		//completeWakefulIntent(intent);
	}

	
	//AUXILIAR
	
	/**
	 * Checks if we are in commercial time.
	 * 
	 * @return
	 */
	private boolean checkCommercialTime() {
		Calendar cal = Calendar.getInstance();
		int hour = cal.get(Calendar.HOUR_OF_DAY);
		
		if(hour < 9 || hour > 22){			
		    return false;
		} else {
		    return true;
		}
	}

}
