package com.colectivosvip.schindler.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import com.colectivosvip.schindler.ApplicationBase;
import com.colectivosvip.schindler.Constants;

/**
 * This receiver allows to process the signal sent by the NetworkChangeReceiver
 * in order to process network status change events.
 *
 * To use it, put this in the manifest file:
 *
 * <code>
 *  <receiver
 *      android:name="package.name.NetworkStatusReceiver"
 *      android:enabled="true"
 *      android:exported="false" >
 *      <intent-filter>
 *          <action android:name="com.colectivosvip.schindler.intent.action.NET_RECOVERED" />
 *          <action android:name="com.colectivosvip.schindler.intent.action.NET_LOST" />
 *      </intent-filter>
 *  </receiver>
 * </code>
 * 
 * NOTE
 * ----
 *  	
 * 	Receivers run in a different thread than the UI so do not try
 *  to update components or make actions in UI thread because it 
 *  can not be running if the Activity is not in foreground.
 *  See 
 *  	http://stackoverflow.com/questions/10217800/updating-an-activity-from-a-broadcastreceiver
 *
 * @author JavocSoft 2013
 * @version 2.0<br>
 * $Rev: 877 $<br>
 * $LastChangedDate: 2016-12-15 18:51:58 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
public class NetworkStatusReceiver extends BroadcastReceiver {

    //Custom INTENTs
    public static final String NET_RECOVERED_INTENT = "com.colectivosvip.schindler.intent.action.NET_RECOVERED";
    public static final String NET_LOST_INTENT = "com.colectivosvip.schindler.intent.action.NET_LOST";

	@Override
	public void onReceive(final Context context, final Intent intent) {
		if(ApplicationBase.debugMode)
			Log.d(Constants.TAG + ": Network Status Receiver", "Connection change signal received from NetworkChangeReceiver.");

        if(intent.getAction().equals(NET_RECOVERED_INTENT)) {        	
        	ToolBox.prefs_savePreference(context, Constants.PREF_NAME, Constants.PREF_KEY__NETWORK_STATUS, Boolean.class, true);        	
        }else if(intent.getAction().equals(NET_LOST_INTENT)){
        	ToolBox.prefs_savePreference(context, Constants.PREF_NAME, Constants.PREF_KEY__NETWORK_STATUS, Boolean.class, false);        	        	            
        }
	}
}
