package com.colectivosvip.schindler;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Bundle;
import android.util.Log;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.Tracker;

import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.ToolBox.NOTIFICATION_PRIORITY;
import es.javocsoft.android.lib.toolbox.ToolBox.NOTIFICATION_STYLE;
import es.javocsoft.android.lib.toolbox.drive.TBDrive;
import es.javocsoft.android.lib.toolbox.location.service.LocationService;
import es.javocsoft.android.lib.toolbox.messenger.Mezzenger;
import es.javocsoft.android.lib.toolbox.net.image.ImageDownloader;
import com.colectivosvip.schindler.javascript.WebAppJSInterface;
import com.colectivosvip.schindler.net.ImageUtils;
import com.colectivosvip.schindler.service.proximity.LocationProximityService;

/**
 * This class is a place to hold application data that can be get by receivers
 * and services safety.
 * <br><br>
 * See:
 * <ul>
 * <li><a href="http://www.intridea.com/blog/2011/5/24/how-to-use-application-object-of-
 * android">Application object HowTo</a></li> 
 * <li><a href="http://developer.android.com/guide/topics/manifest/application-element.html">
 * Application object element</a></li>
 * <li><a href="http://www.devahead.com/blog/2011/06/extending-the-android-application-class-and
 * -dealing-with-singleton/">Application class. Singleton pattern.</a></li>
 * </ul>
 * 
 * @author JavocSoft 2013
 * @version 2.0<br>
 *          $Rev: 885 $<br>
 *          $LastChangedDate: 2017-02-09 18:16:33 +0100 (jue, 09 feb 2017) $<br>
 *          $LastChangedBy: jgonzalez $
 *
 */
public class ApplicationBase extends Application {
	
	//Properties for non activity components.
	public static boolean debugMode = false;
	public static boolean debugModeEnableStrictChecks = false;
	
	//MODULE SETTINGS
	public static boolean enableAds = false;
	public static boolean enablePush = false;
	public static boolean enableWebMenu = false;
	public static boolean enableQR = false;
	public static boolean enableQRTooltipDialog = false;
	public static boolean enableQRReadInApp = true; //If TRUE, no external QR reader app is required
	public static boolean enableAnalytics = false;
	public static boolean enableLocation = true;
	public static boolean enableLocationProximityService = false;
	public static boolean enableInitialLocation = true;
	public static boolean enableLocationWebResetOnGPSDisabled = false;
	public static boolean enableLocationAfterInformLastLocation = false;
	public static boolean enableExitConfirmation = true;
	public static boolean enableGDrive = false;
	public static boolean enableAutoUpdate = true;
	public static boolean enableSQLite = true;
	public static boolean deleteLocalWebStorage = true;
	/** When using the HTML meta-tag "viewport" (see https://benfrain.com/understanding-the-viewport-meta-tag-and-css-viewport/)
	 * to enable zoom, this flag should be in TRUE. 
	 * About zooming:
	 * 
	 * http://adrianroselli.com/2015/10/dont-disable-zoom.html
	 * http://www.iheni.com/mobile-accessibility-tip-dont-suppress-pinch-zoom/
	 * */
	public static boolean enableWebviewZoomSupport = true;
	/** When use denies permissions and select "Never ask again" option permissions are never asked again. If
	 * we want to remember or advice to the user to enable permissions for the app, set this value to TRUE. 
	 * A pop-up will be shown. */
	public static boolean showRememberPermissionOnFullyDenial = true;
	/** If enabled, back button goes back in the webview navigation history. Otherwise 
	 * exits.*/
	public static boolean enableBackButtonHistory = true;
	/** Setting this parameter to TRUE ensures all cookies are deleted once the application is killed or exits. */
	public static boolean enableDeleteAllCookiesWhenExit = false;
	public static boolean enableLocationServiceAskDialog = true;
	/** Enabling this should not be done because if SSL certificate errors raise,
	 * application will bypass them and continue loading the page. Why this is dangerous?
	 * Because trusting all certificates allows anybody to do a man in the middle attack */
	public static boolean enableBypassSSLUrlFailures = true;
	/** When using HTTPS with HTTP resources, mixed-mode behavior must be set in the webview. */
	public static MIXED_MODE_ALLOWANCE mixedModeAlwaysAllowed = MIXED_MODE_ALLOWANCE.ALLOW;
	/** 
	 * When using HTTPS, if accessing to resources not under HTTPS, Android by default
	 * denies them. These are the options for mixed-mode.
	 * <br><br>
	 * <ul>
	 * <li>ALLOW: In this mode, the WebView will allow a secure origin to load content from any 
	 * other origin, even if that origin is insecure. This is the least secure mode of 
	 * operation for the WebView, and where possible apps should not set this mode.</li>
	 * <li>ALLOW_ALL: In this mode, the WebView will allow a secure origin to load content from 
	 * any other origin, even if that origin is insecure. This is the least secure mode of 
	 * operation for the WebView, and where possible apps should not set this mode.</li>
	 * <li>DISALLOW: Mised content is not allowed.</li>
	 * <ul>
	 */	
	public static enum MIXED_MODE_ALLOWANCE {ALLOW, ALLOW_ALL, DISALLOW};
	public static ToolBox.EXIT_CONFIRMATION_STYLE exitStyle = ToolBox.EXIT_CONFIRMATION_STYLE.BACK_PRESS;
	
	
	//OTHER APPLICATION SETTINGS
	public static boolean enableNativeMenu = false;
	public static boolean lockInPortrait = false;
	public static boolean enableWhatIsNewDialog = false;
	public static boolean enableBootSound = false;
	
	//ADS MODULE SETTINGS
	public static String module_ads_banner_id = "ca-app-pub-3940256099942544/6300978111";
	public static String module_ads_interstitial_id = "ca-app-pub-3940256099942544/6300978111";

    //GCM MODULE SETTINGS
	public static String module_gcm_server_id = "749614828866";
	public static String module_gcm_groupNotificationsKey = "schindler";
	
	public TBDrive tbDrive = null;
	
	//A messenger
	public static Mezzenger messengerInner = null;
	
	//Location related
	public static int LOCATION_UPDATE_MIN_DISTANCE = 50; //Meters
    public static long LOCATION_UPDATE_MIN_TIME = 60000l;  //Milliseconds
    public static int LOCATION_UPDATE_ACCURACY_THRESHOLD = 25; //In meters
    public static int API_PROXIMITY_RADIUS = Constants.PROXIMITY_MIN_RADIUS; //In meters
    public static int API_PROXIMITY_MIN_ITEMS_TO_NOTIFY = Constants.SMARTCOUPONING_MIN_OFFERS_TO_NOTIFY;
    /** To avoid being notified constantly and just in case, we can use this value
     * to set a minimum time between location alerts. */
    public static int LOCATION_ALERT_TIME_THRESHOLD = 1; //Minutes
	public static boolean permissionsLocationGranted = false;
	public static boolean permissionsCameraGranted = false;
	public static boolean locationServiceEnabled = false;
	public static boolean locationProximityServiceEnabled = false;
	//When application goes to background stop the location service
	public static boolean locationStopOnPause = true;
	public static LocationInfo location = null;
	public static LocationInfo locationLast = null;
	public static boolean isGPSProviderEnabled = false;
	
	//WebView JS Interface
	public static WebAppJSInterface appWebJSInterface = null;
	
	//Has the value of TRUE when application is destroyed
	public static boolean appIsDestroyed = false;
	//Has the value of TRUE when application is in foreground
	public static boolean appIsForeground = false;
	
	/** Tells if the current loaded page has location behavior */
	public static boolean isPageWithLocationBehavior = false;
	/** The tag that determines if the page has the user-id set (to inform to PUSH API). */
	public static String EXTERNAL_USERID_INFORM_META_TAG_USERID = "ext-userid";
	/** The tag that determines if the page needs location. */
	public static String LOCATION_ENABLED_META_TAG_NAME = "current-page";
	/** The list of valid values for the LOCATION_ENABLED_META_TAG_NAME variable. */
	public static String[] LOCATION_ENABLED_META_TAG_VALUES = {"mobile-home-page"};
	/** The list of pages that requires location services. */
	public static String[] LOCATION_ENABLED_PAGES = {"tus-descuentos.action","mobile/?uid=","mobile/?t_source="};
	
	//This value allows us to use the external proximity API.
	public static String EXTERNAL_PROXIMITY_API_TOKEN = "<token>";
	
	//Image load related
	private static ImageDownloader mImageDownloader = null;
	/** The selected lazy-load image downloader. */ 
    public static ImageUtils.URL_IMAGE_DOWNLOADER_LIB URL_IMAGE_DOWNLOADER = ImageUtils.URL_IMAGE_DOWNLOADER_LIB.CUSTOM;
	
    public static String versionString = null;
    public static String userToken = null;
    public static String appName = null;
    public static String appPlatform = null;
    
    /* A timeout control to avoid large load operations */
    public static long urlLoadingTimeout = 15000l; //millis
    public static boolean urlLoadingError = false;
    
    public static Timer locationAcquireTimer = null;
    public static int locationWaitTime = 5; //5 seconds
    
    /** The list of URLs that can be opened within the webview */
    private static LinkedList<String> webviewOpenValidURLs = new LinkedList<String>();
    
    @Override
    public void onCreate() {
        super.onCreate();
        
        //Initializes default image downloader
      	if(mImageDownloader == null)
      		mImageDownloader = ImageDownloader.getInstance(getBaseContext());
      	
      	//We add at least the starting page
      	addURL(Constants.VV_URL_BASE);      	
      	addURL(replaceLast(Constants.VV_URL_BASE,"/","") + "/mobile");
    }

   
    public ApplicationBase() {
		super();
	}
    
    
    //Static general usage methods
    
    public static String getApplicationName(Context context) {
    	if(appName==null || (appName!=null && appName.length()==0)){
    		appName = ToolBox.application_packageName(context);
    	}
    	return appName;
    }
    
    public static String getApplicationPlatform() {
    	if(appPlatform==null || (appPlatform!=null && appPlatform.length()==0)){
    		appPlatform = "android";
    	}
    	return appPlatform;
    }
    
    public static String getUserToken(Context context) {
    	if(userToken==null || (userToken!=null && userToken.length()==0)){
    		String uToken = ToolBox.device_getId(context);
        	userToken = (ApplicationBase.debugMode?("TEST"+uToken):uToken);
    	}    	
    	return userToken;
    }    
    
    public static String getApplicationVersionString(Context context) {
    	if(versionString==null ||(versionString!=null && versionString.length()==0)){
    		versionString = ToolBox.application_getVersion(context) 
    				+ "." + ToolBox.application_getVersionCode(context);
    	}
		return versionString;
	}
    
    /**
     * Generates a notification in the notification bar.
     * 
     * @param context							The context of the notification.
     * @param notStyle							Select the notification style. See {@link NOTIFICATION_STYLE}
     * @param notPriority						Optional. Select the desired notification priority. 
     * 											See {@link NOTIFICATION_PRIORITY}
     * @param notSound							Set to TRUE to enable sound in the notification.
     * @param notSoundRawId						Optional. Set one to use this sound instead the default one.
     * @param notAction							Optional. Action for this notification.
     * @param notTitle							The title of the notification.
     * @param notMessage						The message of the notification.
     * @param notTicker							Optional. Text that appears for only a few seconds when notification 
     * 											raises. (text which is sent to accessibility services). 
     * @param notContentInfo					Optional. A small piece of additional information pertaining 
     * 											to this notification. The platform template will draw this on 
     * 											the last line of the notification, at the far right (to the 
     * 											right of a smallIcon if it has been placed there).
     * @param lockScreenPrivacy					Optional. Default is PRIVATE.	
     * @param notBigStyleTitle					Optional. Android 4.1+. Overrides ContentTitle in the big form 
     * 											of the template
     * @param notBigStyleContent				Optional. Android 4.1+. Overrides ContentMessage in the big form 
     * 											of the template
     * @param notBigStyleImage					Optional. In BigPicture Expandable notification type. Android 4.1+.
     * 											It is the image to show. Can be a drawable resourceId, an assets 
     * 											resource file name or an URL to an image.
     * @param notBigStyleInboxContent			Optional. In InboxStyle Expandable notification type. It is the
     * 											content of the notification for the expandable.
     * @param notBigStyleInboxLineSeparator		Optional. In InboxStyle Expandable notification type. It is the 
     * 											separator of each line in the received message (notMessage)
     * @param notBigStyleLargeIcon				Optional. Set one to use a larger icon for the notification. Can be a 
     * 											drawable resourceId, an assets/raw resource file name or an URL to an image.
     * @param notBigStyleSummary				Optional. Android 4.1+. Adds a line at the bottom of the notification.
     * @param wakeUp							Set to TRUE to wake-up the device when notification is received.
     * @param extras							Extra information to attach to the notification to be available
	 * 											in the application or the destination intent class (notClazz).
     * 
     */
    public static void generateSystemNotification(Context context, 
    		NOTIFICATION_STYLE notStyle,
    		NOTIFICATION_PRIORITY notPriority,
    		boolean notSound, Integer notSoundRawId,
    		String notAction,
    		String notTitle, String notMessage, 
    		String notTicker, String notContentInfo,
    		ToolBox.NOTIFICATION_LOCK_SCREEN_PRIVACY lockScreenPrivacy,
    		String notBigStyleTitle, String notBigStyleContent,
    		String notBigStyleImage, 
    		String notBigStyleInboxContent, String notBigStyleInboxLineSeparator,
    		String notBigStyleLargeIcon,
    		String notBigStyleSummary,
    		boolean wakeUp, Bundle extras, 
    		Integer notificationId,
    		List<android.support.v4.app.NotificationCompat.Action> actions) {
    	
    	try{
    		
	        //Class to open when notification is pressed
    		Class<?> actToCall = PrincipalActivity.class;
    		
    		if(notStyle==null)
    			notStyle = NOTIFICATION_STYLE.NORMAL_STYLE;
    		
    		if(notAction == null)
    			notAction = "INTERNAL_NOTIFICATION";
    		
    		if(lockScreenPrivacy==null)
    			lockScreenPrivacy = ToolBox.NOTIFICATION_LOCK_SCREEN_PRIVACY.PRIVATE;
    		
    		if(notificationId==null) {
    			if(actions!=null) {
	    			actions.clear();
	    			actions = null;
    			}
    		}
    		
	        ToolBox.notification_create(context, 
	        		notSound, notSoundRawId, false,
	    			false, "AppInternalNotification", 
	    			notAction, 
	    			notTitle, notMessage, 
	    			notTicker, notContentInfo, 
	    			notBigStyleTitle, notBigStyleContent,
	    			notBigStyleSummary, notBigStyleImage, 
	    			notBigStyleInboxContent, notBigStyleInboxLineSeparator, 
	    			Constants.NOTIFICATION_BG_COLOR,
	    			actToCall, 
	    			extras, wakeUp, 
	    			notPriority, 
	    			notStyle, 
	    			lockScreenPrivacy, 
	    			(notBigStyleLargeIcon!=null?notBigStyleLargeIcon:null),
	    			null, 
	    			notificationId,
	    			ToolBox.NOTIFICATION_PROGRESSBAR_STYLE.NONE, 
	    			null, null,
					actions, true);
			
		}catch(Exception e) {
			Log.e(Constants.TAG,"Notification could not be created [" + e.getMessage() + "].", e);			
		}
    }
	
    /**
     * Returns default manual implementation of a lazy-load image
     * downloader.
     * <br><br>
     * Notes:<br>
     * If using external storage, the permission called is required
     * "android.permission.WRITE_EXTERNAL_STORAGE". You can use in the
	 * permission android:maxSdkVersion="18" to make only requested in 
	 * Android version minor to 18.
     * 
     * @return	ImageDownloader object.
     */
    public static ImageDownloader getImageDownloader() {
    	return mImageDownloader;
    }
    
    
    /**
     * Adds an URL to the allowed list.
     * 
     * @param url
     */
    public static void addURL(String url) {
    	if(url!=null && url.length()>0)
    		url = removeEndSlashCharacterFromURL(url.replaceAll("https://", "").replaceAll("http://", ""));
    	
    	if(!webviewOpenValidURLs.contains(url))
    		webviewOpenValidURLs.add(url);
    }
    
    /**
     * Adds a list of URLs to the allowed list.
     * 
     * @param urls
     */
    public static void addURL(Collection<String> urls) {
    	for(String url:urls) {
    		addURL(url);    		
    	}
    	
    	//We add the base URL, just in case 
    	addURL(Constants.VV_URL_BASE);
    	addURL(removeEndSlashCharacterFromURL(Constants.VV_URL_BASE) + "/mobile");
    }
    
    private static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)(.*)" + regex, "$1" + replacement);
    }
    
    public static String removeEndSlashCharacterFromURL(String url) {
    	if(url!=null && url.length()>0 && url.endsWith("/"))
    		return url.substring(0, url.length()-1);
    	else
    		return url;
    }
    
    /**
     * Gets the list of allowed URLs that the webview can open in-app.
     * 
     * @return
     */
    public static LinkedList<String> getWebviewOpenValidURLs(){
    	return webviewOpenValidURLs;
    }
    
    //Methods and properties for activity components
    
    //Location related
    
    /**
	 * Starts the localization service. Should only be used to get the
	 * current user localization and once get, we should stop this service.
	 * If we need tracking of the user, we should use the proximity service
	 * instead, see {@link LocationProximityService}.
	 * <br><br>
	 * <b>Notes</b>: The localization must be as fast as possible. This is why we
	 * set the default parameters.
	 */
	public synchronized void startLocationService() {
		//We only start the service if the user did not disable it.
		if(!(Boolean)ToolBox.prefs_readPreference(this, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_ALERTS_DISABLED, Boolean.class)){
			Intent mLocServiceIntent = new Intent(getBaseContext(), LocationService.class);
	    	Bundle extras = new Bundle();
	    	//Must be as fast as possible getting updates!
	    	extras.putInt(LocationService.LOCATION_SERVICE_PARAM_MIN_DISTANCE, 1);
	    	extras.putLong(LocationService.LOCATION_SERVICE_PARAM_MIN_TIME, 1000l);
	    	extras.putInt(LocationService.LOCATION_SERVICE_PARAM_ACCURACY_THRESHOLD, 0);
	    	mLocServiceIntent.putExtras(extras);
	    	//mServiceIntent.setData(Uri.parse(dataUrl));
	    	startService(mLocServiceIntent);
	    	
	    	if(ApplicationBase.debugMode){
	        	Log.i(Constants.TAG,"Location service start command sent.");
	        }
		}
    }
	
	/**
	 * Stops the localization service.
	 */
	public synchronized void stopLocationService() {
    	Intent mLocServiceIntent = new Intent(getBaseContext(), LocationService.class);
        stopService(mLocServiceIntent);
        
        if(ApplicationBase.debugMode){
        	Log.d(Constants.TAG,"Location service stop command sent.");
        }
    }
	
	/**
	 * Starts the proximity used localization service. See {@link LocationProximityService}.
	 * If we need only the current position of the user, we should use {@link LocationService}
	 * with {@link ApplicationBase#startLocationService()}.
	 * <br><br>
	 * <b>Nores</b>: This service starts and is all time watching for 
	 * user location changes.
	 * 
	 * @param deviceBooted Set to TRUE if the service is started after device has finished
	 * 					   booting.	
	 */
	public synchronized void startProximityLocationService(boolean deviceBooted) {
		//We only start the service if the user did not disable it.
		if(!(Boolean)ToolBox.prefs_readPreference(this, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_ALERTS_DISABLED, Boolean.class)){
			Intent mLocServiceIntent = new Intent(getBaseContext(), LocationProximityService.class);
	    	Bundle extras = new Bundle();
	    	extras.putInt(LocationProximityService.LOCATION_SERVICE_PARAM_MIN_DISTANCE, LOCATION_UPDATE_MIN_DISTANCE);
	    	extras.putLong(LocationProximityService.LOCATION_SERVICE_PARAM_MIN_TIME, LOCATION_UPDATE_MIN_TIME);
	    	extras.putLong(LocationProximityService.LOCATION_SERVICE_PARAM_MIN_TIME_BETWEEN_ALERTS, LOCATION_ALERT_TIME_THRESHOLD);
	    	extras.putInt(LocationProximityService.LOCATION_SERVICE_PARAM_ACCURACY_THRESHOLD, LOCATION_UPDATE_ACCURACY_THRESHOLD);
	    	if(deviceBooted) {
	    		extras.putBoolean(LocationProximityService.LOCATION_SERVICE_PARAM_DEVICE_BOOTED, true);
	    	}
	    	mLocServiceIntent.putExtras(extras);
	    	//mServiceIntent.setData(Uri.parse(dataUrl));
	    	startService(mLocServiceIntent);
		}
    }
	
	/**
	 * Stops the proximity localization service.
	 */
	public synchronized void startProximityLocationService() {
		startProximityLocationService(false);
	}
	
	/**
	 * Stops the proximity localization service.
	 */
	public synchronized void stopProximityLocationService() {
    	Intent mLocServiceIntent = new Intent(getBaseContext(), LocationProximityService.class);
        stopService(mLocServiceIntent);    	
    }
	
	//End location related
	
	//Start URL loading
	
	/**
	 * Gets the URL load timeout depending of the network type.
	 * 
	 * @param networkType
	 * @return
	 */
	public static long getLoadTimeout(ToolBox.NETWORK_TYPE networkType) {
		long res = 15000l;
		
		switch (networkType) {
			case WiFi:
			case _4G:
				res = 16000l;
				break;
			case _3G:
				res = 20000l;
				break;
			case _2G:
				res = 28000l;
				break;			
			case UNKNOWN:
		}
		
		return res;
	}
	
	//End URL loading
	
	/**
	 * Enum used to identify the tracker that needs to be used for tracking.
	 *
	 * A single tracker is usually enough for most purposes. In case you do need
	 * multiple trackers, storing them all in Application object helps ensure
	 * that they are created only once per application instance.
	 */
	public enum TrackerName {
		APP_TRACKER,	// Tracker used only in this application.
		GLOBAL_TRACKER	// Tracker for all applications
	}

	HashMap<TrackerName, Tracker> mTrackers = new HashMap<TrackerName, Tracker>();

	public synchronized Tracker getTracker(TrackerName trackerId) {
		if (!mTrackers.containsKey(trackerId)) {
			GoogleAnalytics analytics = GoogleAnalytics.getInstance(this);
			Tracker t = null;
			
			switch (trackerId) {
			case APP_TRACKER:
				t = analytics.newTracker(R.xml.app_tracker);
				break;				
			default:
				t = analytics.newTracker(R.xml.global_tracker);
				break;
			}
								
			mTrackers.put(trackerId, t);
		}
		
		return mTrackers.get(trackerId);
	}

	/**
	 * This class contains location information.
	 * 
	 */
	public static class LocationInfo {
		
		private Location location;
		private String country;
		private String countryCode;
		private String city;
		private String address;
		private String postalCode;
		
		/**
		 * Creates a location information object with the given data
		 * in the Bundle. It uses the {@link LocationService} location 
		 * parameters where location information is stored when a new
		 * location change is detected.
		 * 
		 * @param location
		 * @param extras
		 */
		public LocationInfo(Bundle extras) {
			this.location = extras.getParcelable(LocationService.LOCATION_KEY);
			//Extra information of the location
			this.country = extras.getString(LocationService.LOCATION_COUNTRY_KEY);
			this.countryCode = extras.getString(LocationService.LOCATION_COUNTRY_CODE_KEY);
			this.city = extras.getString(LocationService.LOCATION_CITY_KEY);
			this.address = extras.getString(LocationService.LOCATION_ADDRESS_KEY);
			this.postalCode = extras.getString(LocationService.LOCATION_POSTAL_CODE_KEY);
		}
		
		/**
		 * Creates a location information given the {@link Location}.
		 * 
		 * @param context
		 * @param location
		 */
		public LocationInfo(Context context, Location location) {
			this.location = location;
			this.country = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.COUNTRY, location.getLatitude(), location.getLongitude());
			this.countryCode = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.COUNTRY_CODE, location.getLatitude(), location.getLongitude());
			this.city = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.CITY, location.getLatitude(), location.getLongitude());
			this.address = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.ADDRESS, location.getLatitude(), location.getLongitude());
			this.postalCode = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.POSTAL_CODE, location.getLatitude(), location.getLongitude());
		}

		public Location getLocation() {
			return location;
		}

		public String getCountry() {
			return country;
		}

		public String getCountryCode() {
			return countryCode;
		}

		public String getCity() {
			return city;
		}

		public String getAddress() {
			return address;
		}

		public String getPostalCode() {
			return postalCode;
		}		
	}
	
}
