package com.colectivosvip.schindler.updates;

import com.google.gson.JsonObject;
import es.javocsoft.android.lib.toolbox.json.JsonDataReader;

/**
 * Class that holds application information after 
 * a call to JavocSoft Mobile Application General API.
 * 
 * The format of the received JSON is:
 * 
 * {  
 *	   "errorCode":200,
 *	   "errorDescription":null,
 *	   "data":{  
 *	      "id":"3",
 *	      "name":"com.colectivosvip.schindler",
 *	      "platform":"android",
 *	      "configString":"{\"minTime\":\"900000\",\"minDistance\":\"200\",\"accThreshold\":\"15\",\"minTimeBetweenLocAlerts\":\"1\",\"pMinOffersToNotify\":\"3\",\"pRadius\":\"500\"}",
 *	      "version":"1",
 *	      "force":"0"
 *	   },
 *	   "config":{  
 *	      "minTime":"900000",
 *	      "minDistance":"200",
 *	      "accThreshold":"15",
 *	      "minTimeBetweenLocAlerts":"1",
 *	      "pMinOffersToNotify":"3",
 *	      "pRadius":"500"
 *	   },
 *	   "ts":"2016-09-23 10:26:29"
 *	}
 * 
 * @author JavocSoft, 2014
 * @version 1.0<br>
 * $Rev: 875 $<br>
 * $LastChangedDate: 2016-12-15 18:50:05 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
public class ApplicationInfo {

	public String name;
	public String platform;
	public boolean isConfigAvailable;
	public long configLocMinTime;
	public int configLocMinDistance;
	public int configLocAccuracyThreshold;
	public int configLocTimeBetweenNotifications;
	public int configLocProximityRadius;
	public int configLocProximityMinOffersToNotify;
	public String configAsString;
	public int version;
	public int force;
	public String ts;

	
	public ApplicationInfo() {
		super();
	}

	public ApplicationInfo(String jsonData) throws Exception {
		super();
		
		try{			
			JsonDataReader jData = new JsonDataReader(jsonData);
			//Application configuration
			String jsonAppConfigString = jData.getJsonElement("configString").getAsString();
			JsonObject jsonAppConfig = jData.getJsonObject("config");
			JsonObject jsonAppData = jData.getJsonObject("data");
						
			if(jsonAppConfig!=null){
				//...there is a custom configuration
				isConfigAvailable = true;
				
				//...get configuration parameters								
				configLocMinTime = jsonAppConfig.get("minTime").getAsLong();
				configLocMinDistance = jsonAppConfig.get("minDistance").getAsInt();
				configLocAccuracyThreshold = jsonAppConfig.get("accThreshold").getAsInt();
				configLocTimeBetweenNotifications = jsonAppConfig.get("minTimeBetweenLocAlerts").getAsInt();
				if(jsonAppConfig.get("pMinOffersToNotify")!=null)
					configLocProximityMinOffersToNotify = jsonAppConfig.get("pMinOffersToNotify").getAsInt();
				if(jsonAppConfig.get("pRadius")!=null)
					configLocProximityRadius = jsonAppConfig.get("pRadius").getAsInt();
			}
			
			this.configAsString = (jsonAppData.get("configString").getAsString().length()>0?jsonAppData.get("configString").getAsString():null);
			this.name = jsonAppData.get("name").getAsString();
			this.platform = jsonAppData.get("platform").getAsString();
			this.version = jsonAppData.get("version").getAsInt();
			this.force = jsonAppData.get("force").getAsInt();
		}catch(Exception e) {
			throw new Exception("Error getting application information from JSON response [" + e.getMessage() + "].", e);
		}
	}
	
	
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPlatform() {
		return platform;
	}

	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public String getTs() {
		return ts;
	}

	public void setTs(String ts) {
		this.ts = ts;
	}

	public int getForce() {
		return force;
	}

	public void setForce(int force) {
		this.force = force;
	}
	
	public boolean isConfigAvailable() {
		return isConfigAvailable;
	}

	public void setConfigAvailable(boolean isConfigAvailable) {
		this.isConfigAvailable = isConfigAvailable;
	}

	public long getConfigLocMinTime() {
		return configLocMinTime;
	}

	public void setConfigLocMinTime(long configLocMinTime) {
		this.configLocMinTime = configLocMinTime;
	}

	public int getConfigLocMinDistance() {
		return configLocMinDistance;
	}

	public void setConfigLocMinDistance(int configLocMinDistance) {
		this.configLocMinDistance = configLocMinDistance;
	}

	public int getConfigLocAccuracyThreshold() {
		return configLocAccuracyThreshold;
	}

	public void setConfigLocAccuracyThreshold(int configLocAccuracyThreshold) {
		this.configLocAccuracyThreshold = configLocAccuracyThreshold;
	}

	public int getConfigLocTimeBetweenNotifications() {
		return configLocTimeBetweenNotifications;
	}

	public void setConfigLocTimeBetweenNotifications(
			int configLocTimeBetweenNotifications) {
		this.configLocTimeBetweenNotifications = configLocTimeBetweenNotifications;
	}

	public String getConfigAsString() {
		return configAsString;
	}

	public void setConfigAsString(String configAsString) {
		this.configAsString = configAsString;
	}
	

}
