package com.colectivosvip.schindler.receiver;

import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.location.service.LocationService;
import com.colectivosvip.schindler.ApplicationBase;
import com.colectivosvip.schindler.Constants;
import com.colectivosvip.schindler.prompt.PromptLocattionAlertsConfigure;
import com.colectivosvip.schindler.service.LocationChangeWakefulService;
import com.colectivosvip.schindler.sqllite.SQLite;
import com.colectivosvip.schindler.sqllite.tables.DBLocation;


/**
 * A receiver to get location service updates into the app.
 * 
 * @author JavocSoft 2013
 * @version 2.0<br>
 * $Rev: 874 $<br>
 * $LastChangedDate: 2016-12-15 18:49:52 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
public class LocationChangedReceiver extends WakefulBroadcastReceiver {
	
	public static final String LOCATION_KEY = "location";
	protected static String TAG = "LocationChangedReceiver";
	
	public static final String ACTION_LOCATION_NOTIFICATION = "com.colectivosvip.schindler.receiver.LOCATION_NOTIFICATION_ACTION";
	
	public static final String LOCATION_NOTIFICATION_KEY_NOTID = "NOTIFICATION_ID";
	public static final String LOCATION_NOTIFICATION_KEY_ACTION = "NOTIFICATION_USER_ACTION";
	public static final String LOCATION_NOTIFICATION_KEY_LOCATIONID = "NOTIFICATION_LOCATION_DB_ROW_ID";
	
	public static final int LOCATION_NOTIFICATION_ACTION_NOT_REMIND = 1;
	public static final int LOCATION_NOTIFICATION_ACTION_CLOSE = 2;	
	public static final int LOCATION_NOTIFICATION_ACTION_CONFIGURE = 3;
	
	public LocationChangedReceiver() {
		
	}

	@Override
	public void onReceive(final Context context, Intent intent) {
		
		Bundle bundle = intent.getExtras();		
		if(intent.getAction().equals(LocationService.ACTION_LOCATION_CHANGED)) {
			// Because the operation can take long, we operate in a separate IntentService
			// to avoid these long operation in the main UI thread. When finishes, 
			// call to completeWakefulIntent(intent) of the receiver.
			// 
			// This is the Intent to deliver to our service.
	        Intent serviceIntent = new Intent(context, LocationChangeWakefulService.class);
	        serviceIntent.putExtras(bundle);
	        // Start the service, keeping the device awake while it is launching.
	        if(ApplicationBase.debugMode)
	        	Log.d(Constants.TAG, "Starting LocationChangeWakefulService service @ " + SystemClock.elapsedRealtime());
	        startWakefulService(context, serviceIntent);			
		}else if(intent.getAction().equals(LocationService.ACTION_LOCATION_GPS_ENABLED)){
			ApplicationBase.isGPSProviderEnabled = true;
		}else if(intent.getAction().equals(LocationService.ACTION_LOCATION_GPS_DISABLED)){
			ApplicationBase.isGPSProviderEnabled = false;
			if(!ApplicationBase.appIsDestroyed && ApplicationBase.enableLocationWebResetOnGPSDisabled)
				ApplicationBase.appWebJSInterface.androidAppInformLocationToWeb(true, false);
		}else if(intent.getAction().equals(LocationService.ACTION_LOCATION_SERVICE_STARTED)){
			ApplicationBase.locationServiceEnabled = true;
		}else if(intent.getAction().equals(LocationService.ACTION_LOCATION_SERVICE_SHUTDOWN)){
			//Reset location related variables.
	        ApplicationBase.locationServiceEnabled = false;
	        ApplicationBase.isGPSProviderEnabled = false;
	        ApplicationBase.location = null;
		}else if(intent.getAction().equals(ACTION_LOCATION_NOTIFICATION)){
			//user selected an option in the location notification.
			
			//We close the notification
			ToolBox.notification_cancel(context, intent.getIntExtra(LOCATION_NOTIFICATION_KEY_NOTID,-1));
			
			//Do something
			int selectedAction = intent.getIntExtra(LOCATION_NOTIFICATION_KEY_ACTION,0);
			final long userDBLocationId = intent.getLongExtra(LOCATION_NOTIFICATION_KEY_LOCATIONID,0);
			
			switch (selectedAction) {
				case LOCATION_NOTIFICATION_ACTION_NOT_REMIND:
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "Do not remind selected");
					
					DBLocation dbLocation = SQLite.getInstance(context).getDBHelper().getLocation(userDBLocationId);
					if(dbLocation!=null) {
						if(SQLite.getInstance(context).getDBHelper().updateLocationRemindOption(dbLocation, 1)){
							if(ApplicationBase.debugMode)
								Log.d(Constants.TAG, "DB Location remind Option Updated!");
						}
					}
					break;				
				case LOCATION_NOTIFICATION_ACTION_CLOSE:
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "Close selected");
					break;
				case LOCATION_NOTIFICATION_ACTION_CONFIGURE:
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "Configure.");
					//Open prompt activity
					//We save in bundle the dbLocationId, just in case we would like to use.
					Intent i = new Intent(context.getApplicationContext(), PromptLocattionAlertsConfigure.class);					
					i.putExtra(LOCATION_NOTIFICATION_KEY_LOCATIONID, userDBLocationId);
					i.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
					context.getApplicationContext().startActivity(i);					
					break;
				default:
					break;
			}
			
			//Closes the system notification bar
			ToolBox.statusBarClose(context);
		}else if(intent.getAction().equals("android.location.PROVIDERS_CHANGED")){
			//This listen even if the application location service is shutdown. 
			final LocationManager manager = (LocationManager) context
					.getSystemService(Context.LOCATION_SERVICE);
			if(manager!=null) {
				//GPS STATUS		
				boolean isGPSProviderEnabled = manager.isProviderEnabled(LocationManager.GPS_PROVIDER);				
				//NETWORK STATUS
				boolean isNetworkProviderEnabled = manager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
				
				//We enable again the application location service
				if(isGPSProviderEnabled || isNetworkProviderEnabled) {
					if(ApplicationBase.permissionsLocationGranted &&
							ApplicationBase.enableLocation && 
				        	ApplicationBase.enableInitialLocation) {
							
							((ApplicationBase)context.getApplicationContext()).startLocationService();
				    }
				}else{
					//In this case the application could be terminated and removed from the
					//back stack.
					if(ApplicationBase.appWebJSInterface!=null && ApplicationBase.enableLocationWebResetOnGPSDisabled)
						ApplicationBase.appWebJSInterface.androidAppInformLocationToWeb(true, false);					 
				}
			} 
		}
		
		completeWakefulIntent(intent);
	}

}
