package com.colectivosvip.schindler.net;

import android.content.Context;
import android.widget.ImageView;

//import com.squareup.picasso.Picasso;

import com.colectivosvip.schindler.ApplicationBase;
import com.colectivosvip.schindler.R;


/**
 * A class to download images in background from an URL 
 * while showing a loading or an image until image is 
 * fully downloaded or fails.<br><br>
 * 
 * Options to download are:<br><br>
 * 
 * 	- Picasso<br>
 * 	- Glide<br>
 * 	- Custom downloader
 * 
 * @author JavocSoft 2015
 * @version 2.0<br>
 * $Rev$<br>
 * $LastChangedDate$<br>
 * $LastChangedBy$
 */
public class ImageUtils {

	/** The URL image downloader library to use.<br>
	 * <br><br>
	 *  Available options are:<br><br>
	 *  <ul>
	 *  <li><a href="http://github.com/bumptech/glide">GLIDE</a></li>
	 *  <li><a href="http://square.github.io/picasso">PICASSO</a></li>
	 *  <li>Custom implementation (see {@link es.javocsoft.android.lib.toolbox.net.image.ImageDownloader}).</li>
	 *  </ul>
	 * */
	//Glides causes the application to not be installed in old 2.3.x Android devices.
	//
	//Error:	"Package has mismatched uid: 10124 on disk, 10134 in settings"
	//
	//Explanation:
	//  During standard installation, a program called "dexopt" runs to prepare your 
	//  app for the specific phone it's being installed on. Dexopt uses a fixed-size 
	//	buffer (called the "LinearAlloc" buffer) to store information about all of 
	//	the methods in your app. Recent versions of Android use an 8 or 16 MB buffer, 
	//	but Froyo and Gingerbread (versions 2.2 and 2.3) only have 5 MB. Because older 
	//	versions of Android have a relatively small buffer, our large number of methods 
	//	was exceeding the buffer size and causing dexopt to crash.
	//
	//public static enum URL_IMAGE_DOWNLOADER_LIB {CUSTOM, GLIDE, PICASSO};
	//public static enum URL_IMAGE_DOWNLOADER_LIB {CUSTOM, PICASSO};
	public static enum URL_IMAGE_DOWNLOADER_LIB {CUSTOM};
	
	
	private ImageUtils() {}
	
	/**
	 * Loads an image from a URL.
	 * <br><br>
	 * This method can use a custom downloader, the Glide library or
	 * the Picasso library to download the image.
	 * 
	 * @param context
	 * @param url
	 * @param imageView
	 */
	public static void loadURLImage(Context context, String url, ImageView imageView) {
		switch (ApplicationBase.URL_IMAGE_DOWNLOADER) {
			case CUSTOM:
				loadImage(url, imageView);
				break;		
			/*case GLIDE:
				if(imageView!=null)
					loadImageWithGlide(context, url, imageView);
				else
					loadImage(url, imageView);
				break;*/				
			/*case PICASSO:
				if(imageView!=null)
					loadImageWithPicasso(context, url, imageView);
				else
					loadImage(url, imageView);
				break;*/		
		}
	}
	
	/**
	 * Loads an image from a URL.
	 * <br><br>
	 * This method can use a custom downloader, the Glide library or
	 * the Picasso library to download the image.
	 * 
	 * @param libraryToUse	See {@link ImageUtils#URL_IMAGE_DOWNLOADER_LIB}
	 * @param context
	 * @param url
	 * @param imageView
	 */
	public static void loadURLImage(ImageUtils.URL_IMAGE_DOWNLOADER_LIB libraryToUse, Context context, String url, ImageView imageView) {
		switch (libraryToUse) {
			case CUSTOM:
				loadImage(url, imageView);
				break;		
			/*case GLIDE:
				if(imageView!=null)
					loadImageWithGlide(context, url, imageView);
				else
					loadImage(url, imageView);
				break;*/				
			/*case PICASSO:
				if(imageView!=null)
					loadImageWithPicasso(context, url, imageView);
				else
					loadImage(url, imageView);
				break;*/		
		}
	}
	
	
	/**
	 * Loads an image using Glide library.<br><br>
	 *  
	 * See:<br><br>
	 * <a href="https://github.com/bumptech/glide">https://github.com/bumptech/glide</a><br>
	 * <a href="http://mvnrepository.com/artifact/com.github.bumptech.glide/glide/3.5.2">http://mvnrepository.com/artifact/com.github.bumptech.glide/glide/3.5.2</a>
	 * 
	 * @param context
	 * @param url
	 * @param imageView
	 */
	/*private static void loadImageWithGlide(Context context, String url, ImageView imageView) {
		//17-Mar-2015. Glide 3.5.2 had an issue with transparent images that make 
		//						 them no transparent.	
		Glide.with(context)
  		.load(url)	        
  		.placeholder(R.drawable.image_download_icon)
  		.error(R.drawable.no_icon_image)
  		.crossFade()
  		.dontTransform()
  		.into(imageView);
	}*/

	/**
	 * Loads an image using Picasso library.
	 * <br><br>
	 * See <a href="http://square.github.io/picasso">http://square.github.io/picasso</a>
	 * 
	 * @param context
	 * @param url
	 * @param imageView
	 */
	/*private static void loadImageWithPicasso(Context context, String url, ImageView imageView) {
		Picasso.with(context)
			.load(url)
			.placeholder(R.drawable.image_download_icon)
  		.error(R.drawable.no_icon_image)
			.into(imageView);		
	}*/	
	
	/**
	 * Loads an image using a custom ImageDownloader task.<br><br>
	 * 
	 * See {@link es.javocsoft.android.lib.toolbox.net.image.ImageDownloader}
	 * 
	 * @param url
	 * @param imageView
	 */
	private static void loadImage(String url, ImageView imageView) {
		ApplicationBase.getImageDownloader().download(url, imageView);
	}
}
