package com.colectivosvip.schindler.javascript;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.colectivosvip.schindler.ApplicationBase;
import com.colectivosvip.schindler.Constants;

/**
 * An executor class that executes task in a queue.
 * <br><br> 
 * Note: This executor is modified to be able to handle 
 * one task at a time.
 * 
 */
public class JSTaskExecutor {

	private static JSTaskExecutor jsTaskExecutor = null;
	private static Handler mHandler = null;
	private static ThreadPoolExecutor poolExecutor;
	private final BlockingQueue<Runnable> mDecodeWorkQueue;
    
	/*
     * Gets the number of available cores
     * (not always the same as the maximum number of cores)
     */
    private static int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    // Sets the amount of time an idle thread waits before terminating
    private static final int KEEP_ALIVE_TIME = 1;
    // Sets the Time Unit to seconds
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
	
    
	static  {     
        jsTaskExecutor = new JSTaskExecutor();
    }
	
	
	private JSTaskExecutor() {
		// Instantiates the queue of Runnables as a LinkedBlockingQueue
        mDecodeWorkQueue = new LinkedBlockingQueue<Runnable>();
        
        // Creates a thread pool manager
        poolExecutor = new ThreadPoolExecutor(
                1,       // Initial pool size
                1,       // Max pool size
                KEEP_ALIVE_TIME,
                KEEP_ALIVE_TIME_UNIT,
                mDecodeWorkQueue);
        
		// Defines a Handler object that's attached to the UI thread
    	mHandler = new Handler(Looper.getMainLooper()) {
	        /*
	         * handleMessage() defines the operations to perform when
	         * the Handler receives a new Message to process.
	         */
	        @Override
	        public void handleMessage(Message inputMessage) {
	        	
	        }
    	};
	}
	
	private static void addTask(Thread task) {
		if(ApplicationBase.debugMode)
			Log.d(Constants.TAG, "Executing in thread pool executor task: [" + task.getName() + "].");
		poolExecutor.execute(task);
	}
	
	public static void addTask(Runnable task, String taskName) {
		if(task!=null) {
			Thread t = new Thread(task, taskName);
			addTask(t);
		}
	}
    
}
