package com.colectivosvip.schindler.analytics;

import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.analytics.CustomCampaignTrackingReceiver;
import com.colectivosvip.schindler.Constants;

/**
 * Class to do something with the received analytics
 * camapign installation info.
 * 
 * @author JavocSoft, 2014
 * @version 1.0<br>
 * $Rev: 871 $<br>
 * $LastChangedDate: 2016-12-15 18:49:05 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 */
public class AnalyticsCampaignCallback extends CustomCampaignTrackingReceiver.OnProcessCampaignDataCallback {

	@Override
	protected void pre_task() {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void task() {
		Log.d(Constants.TAG, "Received campaign information: " + getCampaignInfo().getInstallReferral());
		
		//We save the info. Afterwards we can send it to the server.
		ToolBox.prefs_savePreference(getContext(), Constants.PREF_NAME, Constants.PREF_KEY__INSTALLREFERRER, String.class, getCampaignInfo().getInstallReferral());
	}

	@Override
	protected void post_task() {
		// TODO Auto-generated method stub
		
	}

}
