/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.util.Log;
import com.bumptech.glide.util.Util;
import java.util.Queue;

public final class ByteArrayPool {
    private static final String TAG = "ByteArrayPool";
    private static final int TEMP_BYTES_SIZE = 65536;
    private static final int MAX_SIZE = 0x20C000;
    private static final int MAX_BYTE_ARRAY_COUNT = 32;
    private final Queue<byte[]> tempQueue = Util.createQueue(0);
    private static final ByteArrayPool BYTE_ARRAY_POOL = new ByteArrayPool();

    public static ByteArrayPool get() {
        return BYTE_ARRAY_POOL;
    }

    private ByteArrayPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            this.tempQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        byte[] result;
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            result = this.tempQueue.poll();
        }
        if (result == null) {
            result = new byte[65536];
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Created temp bytes");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseBytes(byte[] bytes) {
        if (bytes.length != 65536) {
            return false;
        }
        boolean accepted = false;
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            if (this.tempQueue.size() < 32) {
                accepted = true;
                this.tempQueue.offer(bytes);
            }
        }
        return accepted;
    }
}

