package es.javocsoft.testing.app00.sqllite.tables;

import java.sql.Timestamp;
import java.util.Date;

import android.text.format.DateFormat;
import es.javocsoft.android.lib.toolbox.db.DBTable;
import es.javocsoft.testing.app00.sqllite.DatabaseHelper;

/**
 * SQLite Location table bean.
 * 
 * @author JavocSoft, 2015
 * @version 1.0<br>
 * $Rev: 816 $<br>
 * $LastChangedDate: 2015-11-30 15:03:36 +0100 (lun, 30 nov 2015) $<br>
 * $LastChangedBy: admin $
 *
 */
public class DBLocation extends DBTable {

	public Integer id;
	public Double lat;
	public Double lng;
	public String city;
	public String country;
	public String countryCode;
	public String postalCode;
	public Long ts;
	public String tsString;
	public Integer notRemind;
	
	
	public DBLocation(String tableName) {
		super(tableName);		
	}

	
	/**
	 * Returns when the location was acquired.
	 * 
	 * @return
	 */
	public Timestamp getTimestamp() {
		if(ts!=null)
			return new Timestamp(ts);
		else
			return null;
	}
	
	/**
	 * Returns when the location was acquired.
	 * 
	 * @return
	 */
	public Date getDate() {
		if(ts!=null)
			return new Date(ts);
		else
			return null;
	}
	
	/**
	 * Returns when the location was acquired in String format 
	 * YYYY-MM-DD HH:MM:SS.
	 * 
	 * @return
	 */
	public String getTimestampAsString() {
		if(ts!=null)		 
			return DateFormat.format(DatabaseHelper.LOCATION_TS_STRING_FORMAT, ts).toString();
		else
			return null;
	}
	
}
