package es.javocsoft.testing.app00.prompt;

import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.testing.app00.ApplicationBase;
import es.javocsoft.testing.app00.Constants;
import es.javocsoft.testing.app00.R;

/**
 * This activity is used to show the configuration prompt for the 
 * offers location alerts service.
 * <br><br>
 * Notes:<br>
 * No layout is used in the activity because we want a transparent 
 * background. Also we use the theme "Theme.AppCompat.Light.Dialog" 
 * in the Androidmanifest.xml file.
 * 
 * @author JavocSoft 2015
 * @version 1.0<br>
 * $Rev: 816 $<br>
 * $LastChangedDate: 2015-11-30 15:03:36 +0100 (lun, 30 nov 2015) $<br>
 * $LastChangedBy: admin $
 *
 */
public class PromptLocattionAlertsConfigure extends FragmentActivity {

	@Override
    protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		displayAlert();
	}
	
	private void displayAlert() {
		ToolBox.dialog_showCustomActionsDialog(this, 
				getResources().getString(R.string.offers_location_configure_prompt_title), 
				getResources().getString(R.string.offers_location_configure_prompt_text), 
				getResources().getString(R.string.offers_location_configure_prompt_cancel),
				new Runnable() {								
					@Override
					public void run() {									
						if(ApplicationBase.debugMode)
							Log.d(Constants.TAG, "Cancel");
						finish();
					}
				},
				getResources().getString(R.string.offers_location_configure_prompt_disable),
				new Runnable() {								
					@Override
					public void run() {
						if(ApplicationBase.debugMode)
							Log.d(Constants.TAG, "Disable");
						doDisableLocationOfferAlerts();						
						finish();
					}
				},	
				null, null);
    }

	private void doDisableLocationOfferAlerts() {
		((ApplicationBase)getApplication()).stopLocationService();
		//We save the selected option
		ToolBox.prefs_savePreference(this, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_ALERTS_DISABLED, Boolean.class, true);
	}
	
}
