package es.javocsoft.testing.app00.updates;

import com.google.gson.Gson;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;

/**
 * Class that holds application information after 
 * a call to JavocSoft Mobile Application General API.
 * 
 * @author JavocSoft, 2014
 * @version 1.0<br>
 * $Rev: 816 $<br>
 * $LastChangedDate: 2015-11-30 15:03:36 +0100 (lun, 30 nov 2015) $<br>
 * $LastChangedBy: admin $
 *
 */
public class ApplicationInfo {

	public String name;
	public String platform;
	public boolean isConfigAvailable;
	public long configLocMinTime;
	public int configLocMinDistance;
	public int configLocAccuracyThreshold;
	public int configLocTimeBetweenNotifications;
	public String configAsString;
	public int version;
	public int force;
	public String ts;

	
	public ApplicationInfo() {
		super();
	}

	public ApplicationInfo(String jsonData) throws Exception {
		super();
		
		try{
			JsonObject jsonDataObject = new Gson().fromJson(jsonData, JsonObject.class);
			
			//Application configuration
			if(jsonDataObject.get("config")!=null && !(jsonDataObject.get("config") instanceof JsonNull)) {
				//...there is a custom configuration
				isConfigAvailable = true;
								
				//...get configuration parameters
				JsonObject jsonAppConfig = jsonDataObject.get("config").getAsJsonObject();				
				configLocMinTime = jsonAppConfig.get("minTime").getAsLong();
				configLocMinDistance = jsonAppConfig.get("minDistance").getAsInt();
				configLocAccuracyThreshold = jsonAppConfig.get("accThreshold").getAsInt();
				configLocTimeBetweenNotifications = jsonAppConfig.get("minTimeBetweenLocAlerts").getAsInt();
			}
			
			JsonObject jsonAppData = jsonDataObject.get("data").getAsJsonObject();
			this.configAsString = (jsonAppData.get("configString").getAsString().length()>0?jsonAppData.get("configString").getAsString():null);
			this.name = jsonAppData.get("name").getAsString();
			this.platform = jsonAppData.get("platform").getAsString();
			this.version = jsonAppData.get("version").getAsInt();
			this.force = jsonAppData.get("force").getAsInt();
		}catch(Exception e) {
			throw new Exception("Error getting application information from JSON response [" + e.getMessage() + "].", e);
		}
	}
	
	
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPlatform() {
		return platform;
	}

	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public String getTs() {
		return ts;
	}

	public void setTs(String ts) {
		this.ts = ts;
	}

	public int getForce() {
		return force;
	}

	public void setForce(int force) {
		this.force = force;
	}
	
	public boolean isConfigAvailable() {
		return isConfigAvailable;
	}

	public void setConfigAvailable(boolean isConfigAvailable) {
		this.isConfigAvailable = isConfigAvailable;
	}

	public long getConfigLocMinTime() {
		return configLocMinTime;
	}

	public void setConfigLocMinTime(long configLocMinTime) {
		this.configLocMinTime = configLocMinTime;
	}

	public int getConfigLocMinDistance() {
		return configLocMinDistance;
	}

	public void setConfigLocMinDistance(int configLocMinDistance) {
		this.configLocMinDistance = configLocMinDistance;
	}

	public int getConfigLocAccuracyThreshold() {
		return configLocAccuracyThreshold;
	}

	public void setConfigLocAccuracyThreshold(int configLocAccuracyThreshold) {
		this.configLocAccuracyThreshold = configLocAccuracyThreshold;
	}

	public int getConfigLocTimeBetweenNotifications() {
		return configLocTimeBetweenNotifications;
	}

	public void setConfigLocTimeBetweenNotifications(
			int configLocTimeBetweenNotifications) {
		this.configLocTimeBetweenNotifications = configLocTimeBetweenNotifications;
	}

	public String getConfigAsString() {
		return configAsString;
	}

	public void setConfigAsString(String configAsString) {
		this.configAsString = configAsString;
	}
	

}
