package es.javocsoft.testing.app00.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.util.Log;
import es.javocsoft.testing.app00.ApplicationBase;
import es.javocsoft.testing.app00.Constants;

/**
 * This receiver allows to watch when the network is down or
 * gets recovered.
 *
 * To use it, put this in the manifest file:
 *
 * <code>
 *  <receiver
 *      android:name="package.name.NetworkChangeReceiver"
 *      android:enabled="true"
 *      android:exported="false" >
 *      <intent-filter>
 *          <action android:name="android.net.conn.CONNECTIVITY_CHANGE" />
 *      </intent-filter>
 *  </receiver>
 * </code>
 *
 * @author JavocSoft 2013
 * @version 2.0<br>
 * $Rev: 816 $<br>
 * $LastChangedDate: 2015-11-30 15:03:36 +0100 (lun, 30 nov 2015) $<br>
 * $LastChangedBy: admin $
 *
 */
public class NetworkChangeReceiver extends BroadcastReceiver {


	@Override
	public void onReceive(final Context context, final Intent intent) {
		final ConnectivityManager connMgr = (ConnectivityManager) context
				.getSystemService(Context.CONNECTIVITY_SERVICE);

		final android.net.NetworkInfo wifi = connMgr
				.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

		final android.net.NetworkInfo mobile = connMgr
				.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);

        Intent i = new Intent();
		if ((wifi!=null && wifi.isAvailable()) || (mobile!=null && mobile.isAvailable())) {
			if(ApplicationBase.debugMode)
				Log.d(Constants.TAG + ": Network Available", "Recovering contact...");
            i.setAction(NetworkStatusReceiver.NET_RECOVERED_INTENT);
		}else{	
			if(ApplicationBase.debugMode)
				Log.d(Constants.TAG + ": Network Not Available", "Connection lost, using cache first.");
            i.setAction(NetworkStatusReceiver.NET_LOST_INTENT);
		}
        context.sendBroadcast(i);
	}
}
