package es.javocsoft.testing.app00.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import es.javocsoft.testing.app00.ApplicationBase;
import es.javocsoft.testing.app00.Constants;

/**
 * General purpose application broadcast receiver.<br><br>
 * 
 * To enable it, put this in the manifest file:<br><br>
 *
 * <code>
 *  <receiver
 *      android:name="es.javocsoft.testing.app00.receiver.AppBroadcastReceiver"
 *      android:enabled="true"
 *      android:exported="false" >
 *      <intent-filter>
 *          <action android:name="....ACTION_1" />
 *          <action android:name="....ACTION_2" />
 *          ...
 *      </intent-filter>
 *  </receiver>
 * </code>
 * 
 * @author JavocSoft 2013
 * @version 2.0<br>
 * $Rev: 816 $<br>
 * $LastChangedDate: 2015-11-30 15:03:36 +0100 (lun, 30 nov 2015) $<br>
 * $LastChangedBy: admin $
 * 
 */
public class AppBroadcastReceiver extends BroadcastReceiver {
	
	//Declare needed INTENT actions.
	public static final String ACTION_1 = Constants.APP_RECEIVER_ACTION_PREFIX + 
			 						"intent.action.ACTION_1";
	 
	 
	@Override
	public void onReceive(Context context, Intent intent) {
		if(ApplicationBase.debugMode)
			Log.d(Constants.TAG, "Application receiver.");
	   
		//Implement as required.
		Bundle bundle = intent.getExtras();		
		if(intent.getAction().equals(ACTION_1)) {   
			
		}
	}

}
