/*
 * Decompiled with CFR 0.152.
 */
package es.javocsoft.android.lib.toucan.client.request;

import android.util.Log;
import com.google.gson.annotations.Expose;
import es.javocsoft.android.lib.toolbox.crypto.SHA1Encoding;
import es.javocsoft.android.lib.toolbox.crypto.exception.SHA1EncodingException;
import java.util.List;

public class AppDevTagsOperationRequest {
    @Expose
    private String appKey;
    @Expose
    private String devId;
    @Expose
    private String appHashSignature;
    @Expose
    private String hashSignature;
    @Expose
    private List<String> tags;

    public AppDevTagsOperationRequest() {
    }

    public AppDevTagsOperationRequest(String appKey, String devId, List<String> tags, String appHashSignature, String hashSignature) {
        this.appKey = appKey;
        this.devId = devId;
        this.tags = tags;
        this.appHashSignature = appHashSignature;
        this.hashSignature = hashSignature;
    }

    public void fillFromRequest(AppDevTagsOperationRequest data) {
        this.appKey = data.appKey;
        this.devId = data.devId;
        this.tags = data.tags;
        this.appHashSignature = data.appHashSignature;
        this.hashSignature = data.hashSignature;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getDevId() {
        return this.devId;
    }

    public void setDevId(String devId) {
        this.devId = devId;
    }

    public String getAppHashSignature() {
        return this.appHashSignature;
    }

    public void setAppHashSignature(String appHashSignature) {
        this.appHashSignature = appHashSignature;
    }

    public String getHashSignature() {
        return this.hashSignature;
    }

    public void setHashSignature(String hashSignature) {
        this.hashSignature = hashSignature;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getSecurityHash(String key) {
        return this.createSHA1Hash(key + "/" + this.getDataAsString());
    }

    public String getDataAsString() {
        StringBuffer sBuffer = new StringBuffer();
        for (String s : this.tags) {
            if (sBuffer.length() == 0) {
                sBuffer.append(s);
                continue;
            }
            sBuffer.append(";#;").append(s);
        }
        return sBuffer.toString();
    }

    private String createSHA1Hash(String data) {
        try {
            return SHA1Encoding.getSHA1((String)data);
        }
        catch (SHA1EncodingException e) {
            Log.e((String)"ToucanClient", (String)e.getMessage());
            return null;
        }
    }
}

