/*
 * Decompiled with CFR 0.152.
 */
package es.javocsoft.android.lib.toucan.client.thread;

import android.content.Context;
import android.util.Log;
import com.google.gson.annotations.Expose;
import com.google.gson.internal.LinkedTreeMap;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.json.GsonProcessor;
import es.javocsoft.android.lib.toucan.client.request.ACKRequest;
import es.javocsoft.android.lib.toucan.client.request.AppDevTagsOperationRequest;
import es.javocsoft.android.lib.toucan.client.request.DeviceRegistrationRequest;
import es.javocsoft.android.lib.toucan.client.response.Response;
import es.javocsoft.android.lib.toucan.client.response.exception.ResponseParseException;
import es.javocsoft.android.lib.toucan.client.thread.ToucanGetWorker;
import es.javocsoft.android.lib.toucan.client.thread.ToucanPostWorker;
import es.javocsoft.android.lib.toucan.client.thread.callback.ResponseCallback;
import java.lang.reflect.Constructor;

public abstract class ToucanWorker
extends Thread
implements Runnable {
    protected transient Context context;
    @Expose
    protected String jobName;
    @Expose
    protected String apiToken;
    @Expose
    protected String endpoint;
    @Expose
    protected String opname;
    @Expose
    protected Object data;
    @Expose
    protected String dataString;
    @Expose
    protected TOUCAN_WORKER_POST_DATA_TYPE dataType;
    private transient String jsonData;
    @Expose
    protected TOUCAN_WORKER_TYPE type;
    @Expose
    protected int typeInt;
    @Expose
    protected boolean running;
    protected ResponseCallback callback;
    @Expose
    protected String callbackString;

    public ToucanWorker(TOUCAN_WORKER_TYPE type, Context context, String apiToken, String endpoint, String opName, ResponseCallback callback) {
        this.type = type;
        this.typeInt = type.ordinal();
        this.context = context;
        this.apiToken = apiToken;
        this.endpoint = endpoint;
        this.opname = opName;
        this.callback = callback;
        if (callback != null) {
            this.callbackString = GsonProcessor.getInstance().getGsonWithExposedFilter().toJson((Object)callback);
        }
        this.init();
    }

    public ToucanWorker(TOUCAN_WORKER_TYPE type, Context context, String apiToken, Object data, TOUCAN_WORKER_POST_DATA_TYPE dataType, String endpoint, String opName, ResponseCallback callback) {
        this.type = type;
        this.typeInt = type.ordinal();
        this.context = context;
        this.data = data;
        if (data != null) {
            this.dataString = GsonProcessor.getInstance().getGsonWithExposedFilter().toJson(data);
        }
        this.dataType = dataType;
        this.apiToken = apiToken;
        this.endpoint = endpoint;
        this.opname = opName;
        this.callback = callback;
        if (callback != null) {
            this.callbackString = GsonProcessor.getInstance().getGsonWithExposedFilter().toJson((Object)callback);
        }
        this.init();
    }

    private void init() {
        this.jsonData = GsonProcessor.getInstance().getGsonWithExposedFilter().toJson((Object)this);
        this.jobName = "toucan_client_pending_request_" + ToolBox.crypto_getHASH((byte[])this.jsonData.getBytes(), (ToolBox.HASH_TYPE)ToolBox.HASH_TYPE.sha1);
    }

    @Override
    public void run() {
        this.running = true;
        if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
            this.doWork();
        }
    }

    public String getJobId() {
        return this.jobName;
    }

    public String getOperationName() {
        return this.opname;
    }

    public boolean isRunning() {
        return this.running;
    }

    public TOUCAN_WORKER_TYPE getType() {
        return this.type;
    }

    public int getTypeInt() {
        return this.typeInt;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void initData() {
        if (this.data != null) {
            if (this.data instanceof LinkedTreeMap) {
                if (this.dataType == TOUCAN_WORKER_POST_DATA_TYPE.REGISTRATION) {
                    DeviceRegistrationRequest devRegRequest = (DeviceRegistrationRequest)GsonProcessor.getInstance().getGsonWithExposedFilter().fromJson(this.dataString, DeviceRegistrationRequest.class);
                    this.data = devRegRequest;
                } else if (this.dataType == TOUCAN_WORKER_POST_DATA_TYPE.ACK) {
                    ACKRequest ackRequest = (ACKRequest)GsonProcessor.getInstance().getGsonWithExposedFilter().fromJson(this.dataString, ACKRequest.class);
                    this.data = ackRequest;
                } else if (this.dataType == TOUCAN_WORKER_POST_DATA_TYPE.TAGS) {
                    AppDevTagsOperationRequest tagsRequest = (AppDevTagsOperationRequest)GsonProcessor.getInstance().getGsonWithExposedFilter().fromJson(this.dataString, AppDevTagsOperationRequest.class);
                    this.data = tagsRequest;
                }
            } else {
                Log.i((String)"ToucanClient", (String)"Unknown data format.");
            }
        } else {
            Log.i((String)"ToucanClient", (String)"No data");
        }
    }

    protected void operationDone(boolean success, Response response) {
        block16: {
            this.running = false;
            if (success) {
                try {
                    if (ToolBox.storage_checkIfFileExistsInInternalStorage((Context)this.context, (String)this.jobName)) {
                        ToolBox.storage_deleteDataFromInternalStorage((Context)this.context, (String)this.jobName);
                        Log.i((String)"ToucanClient", (String)("Pending operation request deleted form disk (" + this.jobName + ")"));
                    }
                    if (this.callbackString == null || this.callbackString.length() <= 0) break block16;
                    String[] cbInfo = this.callbackString.split(",");
                    if (cbInfo != null && cbInfo.length >= 1) {
                        String callbackClassName = null;
                        String callbackOperation = null;
                        String[] cbFieldInfo = null;
                        for (String cbClassField : cbInfo) {
                            cbFieldInfo = (cbClassField = cbClassField.replaceAll("\"", "").replaceAll("\\{", "").replaceAll("\\}", "")).split(":");
                            if (cbFieldInfo == null || cbFieldInfo.length != 2) continue;
                            String cbField = cbFieldInfo[0];
                            if (cbField.equals("callbackClassName")) {
                                String cbFieldvalue;
                                callbackClassName = cbFieldvalue = cbFieldInfo[1];
                                continue;
                            }
                            if (!cbField.equals("callbackOperation")) continue;
                            callbackOperation = cbFieldInfo[1];
                        }
                        if (callbackClassName != null) {
                            Log.i((String)"ToucanClient", (String)("Operation callback present (" + callbackClassName + "). launching it."));
                            try {
                                Class<?> clazz = Class.forName(callbackClassName);
                                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                                ResponseCallback rc = (ResponseCallback)clazz.cast(constructor.newInstance(new Object[0]));
                                rc.setContext(this.context);
                                rc.setResponse(response);
                                if (callbackOperation != null && callbackOperation.length() > 0) {
                                    rc.setCallbackOperation(Integer.parseInt(callbackOperation));
                                }
                                Log.i((String)"ToucanClient", (String)"Operation callback recreated.");
                                rc.start();
                                Log.i((String)"ToucanClient", (String)("Operation callback (" + callbackClassName + "). launched."));
                            }
                            catch (ClassNotFoundException e) {
                                Log.e((String)"ToucanClient", (String)("No callback class found! [" + callbackClassName + "] :: " + e.getMessage()), (Throwable)e);
                            }
                            catch (InstantiationException e) {
                                Log.e((String)"ToucanClient", (String)("Callback class instantation error! [" + callbackClassName + "] :: " + e.getMessage()), (Throwable)e);
                            }
                            catch (NoSuchMethodException e) {
                                Log.e((String)"ToucanClient", (String)("No callback method found [" + callbackClassName + "] :: " + e.getMessage()), (Throwable)e);
                            }
                            catch (IllegalArgumentException e) {
                                Log.e((String)"ToucanClient", (String)("Callback class method mismatch arguments! [" + callbackClassName + "] :: " + e.getMessage()), (Throwable)e);
                            }
                            catch (Exception e) {
                                Log.e((String)"ToucanClient", (String)("Callback class unexpected execution error! [" + callbackClassName + "] :: " + e.getMessage()), (Throwable)e);
                            }
                        }
                        break block16;
                    }
                    Log.e((String)"ToucanClient", (String)"Callback class without anay field! Aborted.");
                }
                catch (Exception e) {
                    Log.e((String)"ToucanClient", (String)("Pending operation request cached file could not be deleted [" + e.getMessage() + "]."), (Throwable)e);
                }
            } else {
                this.cacheOperationRequest(this);
            }
        }
    }

    protected Response parseResponse(String jsonResponse) throws ResponseParseException {
        Response result = null;
        try {
            result = (Response)GsonProcessor.getInstance().getGsonWithExposedFilter().fromJson(jsonResponse, Response.class);
            if (result == null) {
                Log.e((String)"ToucanClient", (String)"Operation done but response could not be parsed");
                throw new ResponseParseException("Response could not be parsed");
            }
        }
        catch (Exception e) {
            Log.e((String)"ToucanClient", (String)("Operation done but response parsing exception happened [" + e.getMessage() + "]"), (Throwable)e);
            throw new ResponseParseException("Response could not be parsed [" + e.getMessage() + "]", e);
        }
        return result;
    }

    public static ToucanPostWorker initializePOSTFromJSON(String jsonData) {
        ToucanPostWorker res = null;
        ToucanWorker temp = (ToucanWorker)GsonProcessor.getInstance().getGsonWithExposedFilter().fromJson(jsonData, ToucanPostWorker.class);
        res = new ToucanPostWorker(temp);
        if (temp.callbackString != null && temp.callbackString.length() > 0) {
            res.callbackString = temp.callbackString;
        }
        return res;
    }

    public static ToucanGetWorker initializeGETFromJSON(String jsonData) {
        ToucanGetWorker res = null;
        ToucanWorker temp = (ToucanWorker)GsonProcessor.getInstance().getGsonWithExposedFilter().fromJson(jsonData, ToucanGetWorker.class);
        res = new ToucanGetWorker(temp);
        if (temp.callbackString != null && temp.callbackString.length() > 0) {
            res.callbackString = temp.callbackString;
        }
        return res;
    }

    public abstract void doWork();

    private void cacheOperationRequest(ToucanWorker operation) {
        try {
            String jsonData = GsonProcessor.getInstance().getGsonWithExposedFilter().toJson((Object)operation);
            String fileName = operation.getJobId();
            ToolBox.storage_storeDataInInternalStorage((Context)this.context, (String)fileName, (byte[])jsonData.getBytes());
            Log.i((String)"ToucanClient", (String)("Saved pending operation request to disk (" + operation.getOperationName() + "/" + operation.getJobId() + ")"));
        }
        catch (Exception e) {
            Log.e((String)"ToucanClient", (String)("Error cacheOperationRequest() - Operation request could not be cached [" + e.getMessage() + "]."), (Throwable)e);
        }
    }

    public static enum TOUCAN_WORKER_POST_DATA_TYPE {
        REGISTRATION,
        ACK,
        TAGS;

    }

    public static enum TOUCAN_WORKER_TYPE {
        GET,
        POST;

    }
}

