/*
 * Decompiled with CFR 0.152.
 */
package es.javocsoft.android.lib.toucan.client.thread;

import android.content.Context;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.json.GsonProcessor;
import es.javocsoft.android.lib.toucan.client.response.Response;
import es.javocsoft.android.lib.toucan.client.response.exception.ResponseParseException;
import es.javocsoft.android.lib.toucan.client.thread.ToucanWorker;
import es.javocsoft.android.lib.toucan.client.thread.callback.ResponseCallback;
import java.util.HashMap;

public class ToucanPostWorker
extends ToucanWorker {
    public ToucanPostWorker(Context context, String apiToken, Object data, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE dataType, String endpoint, String opName, ResponseCallback callback) {
        super(ToucanWorker.TOUCAN_WORKER_TYPE.POST, context, apiToken, data, dataType, endpoint, opName, callback);
    }

    public ToucanPostWorker(ToucanWorker tWorker) {
        super(ToucanWorker.TOUCAN_WORKER_TYPE.POST, tWorker.context, tWorker.apiToken, tWorker.data, tWorker.dataType, tWorker.endpoint, tWorker.opname, tWorker.callback);
    }

    @Override
    public void doWork() {
        try {
            HashMap<String, String> headersData = new HashMap<String, String>();
            headersData.put("Authorization", "ttmSecTKN " + this.apiToken);
            String jsonData = GsonProcessor.getInstance().getGsonWithExposedFilter().toJson(this.data);
            String finalUrl = this.endpoint;
            String jsonDataKey = null;
            String response = ToolBox.net_httpclient_doAction((ToolBox.HTTP_METHOD)ToolBox.HTTP_METHOD.POST, (String)finalUrl, jsonDataKey, (String)jsonData, headersData);
            Log.i((String)"ToucanClient", (String)(this.opname.toUpperCase() + ". Request <<" + jsonData + ">>. Sent to Toucan API. Call response '" + response + "'"));
            Response res = this.parseResponse(response);
            if (res.getCode() == 0) {
                Log.i((String)"ToucanClient", (String)"Operation done and response from server OK.");
            } else {
                Log.i((String)"ToucanClient", (String)("Operation done but response code not OK [Code: " + res.getCode() + "]->" + res.getMsg()));
            }
            this.operationDone(true, res);
        }
        catch (ResponseParseException e) {
            Log.e((String)"ToucanClient", (String)("Error parsing server response for operation '" + this.opname.toUpperCase() + "' request to Toucan API (" + e.getMessage() + ")"), (Throwable)e);
            this.operationDone(false, null);
        }
        catch (Exception e) {
            Log.e((String)"ToucanClient", (String)("Error in operation " + this.opname.toUpperCase() + " request to Toucan API (" + e.getMessage() + ")"), (Throwable)e);
            this.operationDone(false, null);
        }
    }
}

