package com.colectivosvip.clubempleadosineco;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Handler.Callback;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.view.Window;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.GeolocationPermissions;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;

import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.ToolBox.EXIT_CONFIRMATION_STYLE;
import es.javocsoft.android.lib.toolbox.ads.AdFragment;
import es.javocsoft.android.lib.toolbox.ads.AdInterstitial;
import es.javocsoft.android.lib.toolbox.analytics.CustomCampaignTrackingReceiver;
import es.javocsoft.android.lib.toolbox.drive.TBDrive;
import es.javocsoft.android.lib.toolbox.drive.TBDrive.CloudOperationResult;
import es.javocsoft.android.lib.toolbox.gcm.EnvironmentType;
import es.javocsoft.android.lib.toolbox.gcm.NotificationModule;
import es.javocsoft.android.lib.toolbox.gcm.core.CustomNotificationReceiver;
import es.javocsoft.android.lib.toolbox.gcm.exception.GCMException;
import es.javocsoft.android.lib.toolbox.json.GsonProcessor;
import es.javocsoft.android.lib.toolbox.location.service.LocationService;
import com.colectivosvip.clubempleadosineco.ads.InterstitialClickCallback;
import com.colectivosvip.clubempleadosineco.ads.MyAdsFragment;
import com.colectivosvip.clubempleadosineco.analytics.AnalyticsCampaignCallback;
import com.colectivosvip.clubempleadosineco.drive.TBDriveConnectionFailureListener;
import com.colectivosvip.clubempleadosineco.drive.TBDriveConnectionListener;
import com.colectivosvip.clubempleadosineco.drive.TBDriveFileCreationListener;
import com.colectivosvip.clubempleadosineco.drive.TBDriveSuspendedListener;
import com.colectivosvip.clubempleadosineco.gcm.GCMNotOpenCallback;
import com.colectivosvip.clubempleadosineco.gcm.GCMNotReceivedCallback;
import com.colectivosvip.clubempleadosineco.gcm.GCMRegCallback;
import com.colectivosvip.clubempleadosineco.gcm.GCMUnregCallback;
import com.colectivosvip.clubempleadosineco.javascript.WebAppJSInterface;
import com.colectivosvip.clubempleadosineco.prompt.PromptLocattionAlertsConfigure;
import com.colectivosvip.clubempleadosineco.sqllite.SQLite;



/**
 * Main class of the application.<br><br>
 * 
 * To generate a new application project execute, from projects folder:<br><br>
 * 	
 * 	./genapp_new_app.sh #app_name# #app_package# #company# #url# #mail#<br><br>
 *  
 * See about WebView:<br>
 * 	https://developer.android.com/reference/android/webkit/WebView.html<br>
 * 	https://developer.android.com/guide/webapps/migrating.html
 * 	http://stackoverflow.com/questions/3916330/android-webview-webpage-should-fit-the-device-screen
 * 	
 * @author JavocSoft, 2014
 * @version 1.0<br>
 * $Rev: 850 $<br>
 * $LastChangedDate: 2016-05-22 13:48:33 +0200 (dom, 22 may 2016) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
@SuppressWarnings("deprecation")
public class PrincipalActivity extends FragmentActivity {

	private static LinearLayout refreshZone = null;
	private static TextView refreshZoneText = null;
	private static ImageView refreshZoneIcon = null;
	
	private static FrameLayout gpsIcon = null;
	private static FrameLayout disabledZone = null;
	private static  TextView notificationText = null;
	
	private static WebView myWebView = null;
    
	private CookieSyncManager syncManager = null;
    private CookieManager cookieManager = null;
    
    private ProgressDialog progressDialog;
    private ProgressBar progressBar;
    private FrameLayout pzonefb;
    
    private List<String> previous = new ArrayList<String>();

    private boolean urlLoadError = false;
    private static String currURL =  Constants.VV_URL_HOME;
    
    private static SQLite sqLiteDB = null;
    
    
    //ADS MODULE ------------------------------------------------------------
    private AdFragment ads = null;
    private InterstitialClickCallback interstitialClickcallback = null;
    
    //Web menu integration module.
    private boolean integrateWithWebMenu = false;
    
    //GCM Module -------------------------------------------------------------------------------
    private NotificationModule notificationModule;
    private CustomNotificationReceiver notReceiver;
    private String gcmAppSenderId;
    //END GCM Notification Module --------------------------------------------------------------
    
    private static Tracker tracker = null;
    
    private Handler handler = new Handler();
    
    public PrincipalActivity thiz = null;
    
	@SuppressLint({ "SetJavaScriptEnabled", "NewApi" })
	@Override
    protected void onCreate(Bundle savedInstanceState) {
    	super.onCreate(savedInstanceState);
    	
    	//Remove title bar (only has sense if using ActionBarActivity)
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        
        setContentView(R.layout.activity_principal);

        notificationText = (TextView) findViewById(R.id.textNotification);
        gpsIcon = (FrameLayout)findViewById(R.id.gpsicon);
        myWebView = (WebView) findViewById(R.id.webViewMain);
        progressBar = (ProgressBar)findViewById(R.id.pbar);
        pzonefb = (FrameLayout)findViewById(R.id.pzonefb);
        
        initWebViewComponent(myWebView);        
        if(ApplicationBase.enableDeleteAllCookiesWhenExit) {
	        //Ensure we delete all Webview cookies before loading any page
	        if(!(Boolean)ToolBox.prefs_readPreference(this, Constants.PREF_NAME, Constants.PREF_KEY__EXIT_NORMALLY, Boolean.class)){
	        	ToolBox.webview_destroyAllCookies(null,null);
	        }
	        ToolBox.prefs_savePreference(this, Constants.PREF_NAME, Constants.PREF_KEY__EXIT_NORMALLY, Boolean.class, null);
        }        
        initDisabledZone();
        initRefreshZone();        
            
        //Get the current network status        
        if(ToolBox.net_isNetworkAvailable(this)) {
        	ToolBox.prefs_savePreference(this, Constants.PREF_NAME, Constants.PREF_KEY__NETWORK_STATUS, Boolean.class, true);
        	refreshZone.setVisibility(View.GONE);
        }else{
        	ToolBox.prefs_savePreference(this, Constants.PREF_NAME, Constants.PREF_KEY__NETWORK_STATUS, Boolean.class, false);
        	
        	//To not get a blank page
        	showRefreshZone();        	
        }
        
        //If orientation changes, we recover the status of the webview.
        if (savedInstanceState != null){
        	//Done in "onRestoreInstanceState()" method.
        	//myWebView.restoreState(savedInstanceState);        	
        }else{
        	//We have to erase the cache because there are issues when only css changes 
        	//are done to the web, this changes are not taken due to widget webkit behaviour. 
        	//In order to force all CSS to be taken again, we erase all cache data, 
        	//including files.
        	myWebView.clearCache(true);
        	
            myWebView.loadUrl(currURL);
        }

        //Apply specific debug mode settings.
        if(ApplicationBase.debugMode) {
        	notificationText.setVisibility(View.VISIBLE);
        	
        	//We enable the Strict mode to detect possible issues.
        	//ToolBox.enableStrictMode(false);
        }        
        
        //MODULES: 
        
        //ADS MODULE ------------------------------------------------------------------------------------
      	FragmentManager fragmentManager = getSupportFragmentManager();
      	ads = (MyAdsFragment) fragmentManager.findFragmentById(R.id.adFragment);
      	//END ADS MODULE --------------------------------------------------------------------------------
      	
        //ADS MODULE - INTERSTITIAL ------------------------------------------------------------------------------      	
        if(ApplicationBase.enableAds) {
        	if(interstitialClickcallback==null)
        		interstitialClickcallback = new InterstitialClickCallback();
        	
        	//Ask for a new interstitial
            //...(shows when application starts)
            AdInterstitial.getInstance().requestInterstitial(ApplicationBase.module_ads_interstitial_id, this, interstitialClickcallback);
        }
        //END ADS MODULE - INTERSTITIAL --------------------------------------------------------------------------
        
        //GCM Module -------------------------------------------------------------------------------
        final boolean multipleNotifications = false;
        final String groupNotificationsKey = ApplicationBase.module_gcm_groupNotificationsKey;
        gcmAppSenderId = ApplicationBase.module_gcm_server_id;
        
        if(ApplicationBase.enablePush) {
	        notificationModule = NotificationModule.getInstance(this, EnvironmentType.SANDBOX,
	                                    gcmAppSenderId,
	                                    new GCMRegCallback(),
	                                    new GCMNotOpenCallback(),
	                                    new GCMUnregCallback(),
	                                    new GCMNotReceivedCallback(),
	                                    multipleNotifications,
	                                    groupNotificationsKey);
	        if(notReceiver==null) {
	            notReceiver = new CustomNotificationReceiver();
	            registerReceiver(notReceiver,
	                    new IntentFilter(NotificationModule.NEW_NOTIFICATION_ACTION));
	        }
        }
        //END GCM Notification Module --------------------------------------------------------------
        
        //ANALYTICS CAMPAIGN MODULE ----------------------------------------------------------------
        if(ApplicationBase.enableAnalytics) {
        	//See: 	https://developers.google.com/analytics/devguides/collection/android/v4/
        	//		https://developer.android.com/reference/com/google/android/gms/analytics/GoogleAnalytics.html
        	//		https://developers.google.com/analytics/devguides/collection/android/v4/advanced
        	tracker = ((ApplicationBase)getApplication()).getTracker(ApplicationBase.TrackerName.APP_TRACKER);
        }
        AnalyticsCampaignCallback analyticsCampaignCallback = new AnalyticsCampaignCallback();
        CustomCampaignTrackingReceiver.onCampaignInfoReceivedCallback = analyticsCampaignCallback;        
        //END ANALYTICS CAMPAIGN MODULE ------------------------------------------------------------
        
        //LOCATION MODULE -------------------------------------------------------------------------
        if(ApplicationBase.enableLocation && ApplicationBase.enableInitialLocation) {
        	if(ApplicationBase.isPageWithLocationBehavior){
        		prepareLocationModule();
        	}else{
        		((ApplicationBase)getApplication()).stopLocationService();
        	}
    	}else{
    		((ApplicationBase)getApplication()).stopLocationService();
    	}
        //END LOCATION MODULE ---------------------------------------------------------------------
        
        //GOOGLE DRIVE MODULE ---------------------------------------------------------------------
        if(ApplicationBase.enableGDrive) {
	        ((ApplicationBase)getApplication()).tbDrive =
	        		TBDrive.getInstance(this, 
	        				new TBDriveConnectionFailureListener(getApplicationContext()), 
	        				new TBDriveConnectionListener(getApplicationContext()),
	        				new TBDriveSuspendedListener(getApplicationContext()));
        }
        //END GOOGLE DRIVE MODULE -----------------------------------------------------------------
        
        //SQLite DB -------------------------------------------------------------------------------
        if(ApplicationBase.enableSQLite){
	        //We need to do this outside of the UI thread
	        new Thread(new Runnable() {				
				@Override
				public void run() {
					sqLiteDB = SQLite.getInstance(getApplicationContext());					
				}
			}).run();	
		}
        //END SQLite DB ---------------------------------------------------------------------------
        
        //Just in case user disabled this feature
		displayLocationOffersDisableAlert();
		
		if((getIntent().getExtras()!=null && 
				getIntent().getExtras().getInt(ToolBox.NOTIFICATION_FLAG)==1) 
			|| getIntent().getIntExtra(ToolBox.NOTIFICATION_FLAG,0 )==1) {
			
			//For Android < 4.1
	    	if(ToolBox.device_getAPILevel()<ToolBox.ApiLevel.LEVEL_16.getValue() &&
	    			!(Boolean)ToolBox.prefs_readPreference(this, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_ALERTS_DISABLED, Boolean.class)
	    		) {
	    		//There were no notification action buttons
	    		//
	    		//Open prompt activity
				Intent i = new Intent(this.getApplicationContext(), PromptLocattionAlertsConfigure.class);
				i.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
				getApplicationContext().startActivity(i);
	    	}
		}
		
        thiz = this;
    }
	
	@Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        ApplicationBase.permissionsLocationGranted = checkAskPermissionsResult(requestCode, permissions, grantResults);
        if(ApplicationBase.debugMode)
        	Log.d(Constants.TAG, "Location permissions granted? " + ApplicationBase.permissionsLocationGranted);
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        
        initLocationModule();
    }
    
    private boolean checkAskPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    	boolean res = false;    	
    	if(requestCode == ToolBox.PERMISSIONS_REQUEST_CODE_ASK_LOCATION) {
    		//res = ToolBox.permission_areGranted(SplashActivity.this, Arrays.asList(permissions));    		
    		res = ToolBox.permission_checkAskPermissionsresult(permissions, grantResults);
    	}    	
    	return res;
    }
	
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        //This is linked with the android manifest activity property "configChanges".
        super.onConfigurationChanged(newConfig);
        //Locks in Portrait mode if desired
        if(ApplicationBase.lockInPortrait)
        	setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
    }
    
    @Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);
		
		//Recover webview status after an orientation change.
		myWebView.restoreState(savedInstanceState);
		
		//To not get a blank page
		if(!(Boolean)ToolBox.prefs_readPreference(this, Constants.PREF_NAME, Constants.PREF_KEY__NETWORK_STATUS, Boolean.class)){
			showRefreshZone();
    	}
		/*
		if(!ApplicationBase.isNetworkEnabled) {
			showRefreshZone();        	
        }*/
	}

	@Override
    protected void onSaveInstanceState(Bundle outState) {
        //If the state of the app changes, after a orientation change
        //for example, we save the current status of the webview to
        //recover it after is inflated again in the onCreate event.
        myWebView.saveState(outState);
    }

    @Override
    public void onResume() {
        super.onResume();
        syncManager.startSync();
        //myWebView.restoreState(this.getIntent().getExtras());
        
		//When opened from an URL, we can take URL parameters from it.
        Intent intent = getIntent();
        if (Intent.ACTION_VIEW.equals(intent.getAction())) {
          Uri uri = intent.getData();
          if(uri!=null) {
	          String valueOne = uri.getQueryParameter("param1");
	          String valueTwo = uri.getQueryParameter("param2");
	          if(ApplicationBase.debugMode) {
	        	Log.d(Constants.TAG, "URL Val1: " + valueOne);
	          	Log.d(Constants.TAG, "URL Val2: " + valueTwo);
	          }
          }
        }
        
        //Modules check
        //
        //ADS Module -------------------------------------------------------------------------------
        if(ApplicationBase.enableAds) {
        	Log.i(Constants.TAG, "Module - Ads: Enabled");
            ads.showAds();
        }else{
        	if(ApplicationBase.debugMode)
        		Log.d(Constants.TAG, "Module - Ads: Disabled");            
        }
        //END ADS Module ---------------------------------------------------------------------------

        //GCM Module -------------------------------------------------------------------------------
        if(ApplicationBase.enablePush) {
        	Log.d(Constants.TAG, "Module - Push: Enabled");            
            
            try {
                notificationModule.gcmRegisterDevice(this,"Testing GCM", this.getClass());
            } catch (GCMException e) {
                Log.e(NotificationModule.TAG, "Error registering with GCM: " + e.getMessage() + ".", e);
            }
            notificationModule.gcmCheckForNotificationReceival(this, getIntent());                        
        }else{
        	if(ApplicationBase.debugMode)
        		Log.d(Constants.TAG, "Module - Push: Disabled");            
        }
        //END GCM Notification Module --------------------------------------------------------------

        //WEBMENU Module ---------------------------------------------------------------------------
        if(ApplicationBase.enableWebMenu) {
            Log.i(Constants.TAG, "Component - WebMenu integration Enabled");
            integrateWithWebMenu = true;
        }else{
        	if(ApplicationBase.debugMode)
        		Log.d(Constants.TAG, "Component - WebMenu integration Disabled");
            integrateWithWebMenu = false;
        }
        //END WEBMENU Module -----------------------------------------------------------------------
        
        //LOCATION Module --------------------------------------------------------------------------
        if(!ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {
        	((ApplicationBase)getApplication()).stopLocationService();
        }else{
        	if(ApplicationBase.enableLocation && ApplicationBase.enableInitialLocation) {
        		if(ApplicationBase.isPageWithLocationBehavior){
        			prepareLocationModule();
        		}else{
        			((ApplicationBase)getApplication()).stopLocationService();
        		}
        	}else{
        		((ApplicationBase)getApplication()).stopLocationService();
        	}
        }	
        //END LOCATION Module ----------------------------------------------------------------------
    }

    @Override
    protected void onPause() {
        super.onPause();
        syncManager.stopSync();
        
        //GOOGLE DRIVE MODULE ---------------------------------------------------------------------
        if(ApplicationBase.enableGDrive) {
        	((ApplicationBase)getApplication()).tbDrive.drive_onPause();
        }
        //END GOOGLE DRIVE MODULE -----------------------------------------------------------------
        
      //LOCATION MODULE
        if(ApplicationBase.locationStopOnPause){
        	if(ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {
            	((ApplicationBase)getApplication()).stopLocationService();
            }
        }
        //END LOCATION MODULE
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        toggleProgressIndicator(false, PROGRESS_INDICATOR_STYLE.PBAR);
        
        //GCM Module -------------------------------------------------------------------------------
        if(ApplicationBase.enablePush) {	        
	        unregisterReceiver(notReceiver);	        
        }
        //END GCM Notification Module --------------------------------------------------------------
        
        //LOCATION MODULE -------------------------------------------------------------------------
        if(ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {
        	((ApplicationBase)getApplication()).stopLocationService();
        }
        //END LOCATION MODULE ---------------------------------------------------------------------
        
        if(ApplicationBase.enableDeleteAllCookiesWhenExit) {
        	ToolBox.webview_destroyAllCookies(null, null);        
        	//Exited normally. We store for afterward start
        	ToolBox.prefs_savePreference(this, Constants.PREF_NAME, Constants.PREF_KEY__EXIT_NORMALLY, Boolean.class, Boolean.valueOf(true));
        }
        
        ApplicationBase.appIsDestroyed = true;
    }
    
    @Override
	protected void onStart() {
		super.onStart();
		
		ApplicationBase.appIsDestroyed = false;
		
		//ANALYTICS MODULE --------------------------------------------------------------------------
		if(tracker!=null)
			tracker.send(new HitBuilders.ScreenViewBuilder().build());
		//END ANALYTICS MODULE ----------------------------------------------------------------------
		
		showWhatIsNewDialog();
		
		//GOOGLE DRIVE MODULE ---------------------------------------------------------------------
        if(ApplicationBase.enableGDrive) {
        	((ApplicationBase)getApplication()).tbDrive.drive_connect();
        }
        //END GOOGLE DRIVE MODULE -----------------------------------------------------------------
	}

	@Override
	protected void onStop() {
		super.onStop();
		
		//LOCATION RELATED --------------------------------------------------------------------------
		if(!ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {
			((ApplicationBase)getApplication()).stopLocationService();
        }		
		//END LOCATION RELATED ----------------------------------------------------------------------
	}
        
    @Override
	protected void onNewIntent(Intent intent) {
		super.onNewIntent(intent);
		
		if(ApplicationBase.enablePush) {
			//GCM Module -------------------------------------------------------------------------------
	        notificationModule.gcmCheckForNotificationReceival(this, intent);
	        //END GCM Notification Module --------------------------------------------------------------
		}
	}
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	if(ApplicationBase.enableNativeMenu){
    		// Inflate the menu; this adds items to the action bar if it is present.
            getMenuInflater().inflate(R.menu.principal, menu);
    	}    	
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        switch (id) {
        case R.id.action_exit:
            finish();
            return true;
        case R.id.action_about:
            Intent iAboutOpen=new Intent(this,AboutActivity.class);
            startActivity(iAboutOpen);
            return true;
        case R.id.action_show_banner:
            ads.showAds();
            return true;
        case R.id.action_hide_banner:
            ads.hideAds();
            return true;
        case R.id.action_show_interstitial:
            AdInterstitial.getInstance().requestInterstitial(ApplicationBase.module_ads_interstitial_id, this, interstitialClickcallback);
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
    
    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        //To link the back button to webview's history. Once
        //there is no more history the application exits.
        if(event.getAction() == KeyEvent.ACTION_DOWN){
            switch(keyCode) {
                case KeyEvent.KEYCODE_BACK:
                	//testCloud();
                	//ApplicationBase.messengerInner.sendMessage(MyMessengerIncomingHandler.MSG_EVT_HI, 0, 0, null);
                	
                	//We only allow back if page has finished loading and rendering
                	if(finishedRendering) {
                		if(myWebView.getUrl()!=null && !urlIsHomeURL(myWebView.getUrl()) && previous.size()>0){
                			if(ApplicationBase.enableExitConfirmation 
	                    			&& ApplicationBase.exitStyle==EXIT_CONFIRMATION_STYLE.BACK_PRESS)
	                    		ToolBox.mBackPressed = 0;
	                    	webHistory_goBack();
	                    }else{
	                    	if(ApplicationBase.enableExitConfirmation) {
		                    	switch (ApplicationBase.exitStyle) {
									case BACK_PRESS:
										ToolBox.backPressedAction(this, Constants.EXIT_BACK_PRESS_TIME_INTERVAL, getString(R.string.exit_confirmation), false, ToolBox.TOAST_TYPE.INFO);
										break;
									case DIALOG:
										ToolBox.dialog_showExitConfirmationDialog(this, R.string.action_exit_title, R.string.action_exit_message, R.string.action_yes, R.string.action_no, false);
										break;
									case NONE:								
										finish();
								}
	                    	}else{
	                    		finish();
	                    	}
	                    }                		
                	}
                    return true;
                case KeyEvent.KEYCODE_MENU:
                    if(integrateWithWebMenu) {
                        myWebView.loadUrl("javascript:" + Constants.VV_JS_SHOWMENU_METHOD + "()");
                        return true;
                    }else{
                    	//We avoid the usage of native menú.
                    }
            }
        }
        return super.onKeyDown(keyCode, event);
    }
    
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
    	//See http://developer.android.com/training/basics/intents/result.html
    	
    	//GOOGLE DRIVE MODULE ---------------------------------------------------------------------
        if(ApplicationBase.enableGDrive) {
        	((ApplicationBase)getApplication()).tbDrive.drive_checkForResolutionResult(requestCode, resultCode, intent);
        }
    	//END GOOGLE DRIVE MODULE -----------------------------------------------------------------
        
        if (requestCode==IntentIntegrator.REQUEST_CODE) {
            //The result is a ZXing scan result.
            IntentResult scanResult = IntentIntegrator.parseActivityResult(requestCode, resultCode, intent);
            String scanJSONResult = null;
            if(scanResult != null && scanResult.getContents()!=null) {
                String readCode = scanResult.getContents();
                String codeType = scanResult.getFormatName();
                scanJSONResult = "{\"resultCode\":\""+ readCode + "\",\"codeType\":\"" + codeType + "\"}";
            }else{
            	if(ApplicationBase.debugMode)
            		Log.d(Constants.TAG, "Code could not be read");
                scanJSONResult = "{\"resultCode\":\"none\",\"codeType\":\"none\"}";
            }
            //Call to web JS sending the scan result.
            if(ApplicationBase.debugMode)
            	Log.d(Constants.TAG, "Scan code result JSON: " + scanJSONResult);
            
            final String jsonResult = urlEncode(scanJSONResult);
            //We have to load in the webview thread
    		myWebView.post(new Runnable() {
                public void run() {
                	myWebView.loadUrl("javascript:" + Constants.VV_JS_SCANCODERESULT_METHOD + "('" + jsonResult + "')");                	
                }
            });

        }else if(requestCode==ToolBox.ENABLE_GPS_REQUEST) {
        	//Returning from a GPS activation request
        	String gpsEnableResult = null;
        	if(ApplicationBase.locationServiceEnabled) {
	            if (ApplicationBase.isGPSProviderEnabled) {
	            	//User enabled the GPS, inform to the web            	
	            	gpsEnableResult = "{\"gpsEnabled\":\"" + true + "\"}";
	            }else{
	            	//User did not enable the GPS
	            	gpsEnableResult = "{\"gpsEnabled\":\"" + false + "\"}";
	            }
        	}else{
        		//just in case, Location module is not enabled
        		gpsEnableResult = "{\"gpsEnabled\":\"" + false + "\"}";
        	}
        	
        	final String jsonResult = urlEncode(gpsEnableResult);
            //We have to load in the webview thread
        	myWebView.post(new Runnable() {
                public void run() {
                	myWebView.loadUrl("javascript:" + Constants.VV_JS_USERLOCATION_ENABLED_STATUS_METHOD + "('" + jsonResult + "')");                	
                }
            });
        	
        	//Once enabled, location service will start getting position and send to
        	//the web the location if is required.
        }else{ }
    }


    // AUXILIAR
    
    public WebView getWebView() {
    	return myWebView;
    }
    
    /**
     * Prepares the location service.
     */
    private void prepareLocationModule() {
    	//Permissions check.
    	if(!ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {
    		//This need to be run in the UI thread. We ensure it.
    		runOnUiThread(new Runnable() {				
				@Override
				public void run() {
					ToolBox.permission_askFor(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION, ToolBox.PERMISSIONS_REQUEST_CODE_ASK_LOCATION, 
		        			getString(R.string.permissions_required_title), 
		           			getString(R.string.permissions_button_ok),
		           			getString(R.string.permissions_button_deny),
		           			getString(R.string.permissions_location_required_text),
		           			true,
		           			true,
		           			getString(R.string.permissions_enable_the_best));
				}
			});
        }else{
        	ApplicationBase.permissionsLocationGranted = true;
        	
        	//Permissions are ok, continue with module initialization
        	initLocationModule();
        }
    }
    
    private void initLocationModule() {
		if(ApplicationBase.permissionsLocationGranted &&
			ApplicationBase.enableLocation && 
        	ApplicationBase.enableInitialLocation) {
			
			//If location ask dialog is required
			if(!ToolBox.location_checkAvalibility(this)){
				if(ApplicationBase.enableLocationServiceAskDialog)
					ToolBox.dialog_showGPSDisabledAlert(this, "Para poderle mostrar ofertas cercanas a su posición necesitamos que habilite la localización, ¿Desea hacerlo ahora?", "Sí", "No");
			}else{
				((ApplicationBase)getApplication()).startLocationService();
				
				//TODO 	We could send the last location get to have a location while 
				//		waiting for the service location.
				//sendLastKnownLocation();
			}
        }
	}
    
    private void sendLastKnownLocation() {
    	Location loc = ToolBox.location_getLastKnownLocation(getApplicationContext(), LocationManager.NETWORK_PROVIDER);
		
		Bundle extras = new Bundle();				
        extras.putParcelable(LocationService.LOCATION_KEY, loc);
        //...some extra information about the location
        extras.putString(LocationService.LOCATION_COUNTRY_KEY, ToolBox.location_addressInfo(getApplicationContext(), ToolBox.LOCATION_INFO_TYPE.COUNTRY, loc.getLatitude(), loc.getLongitude()));
        extras.putString(LocationService.LOCATION_COUNTRY_CODE_KEY, ToolBox.location_addressInfo(getApplicationContext(), ToolBox.LOCATION_INFO_TYPE.COUNTRY_CODE, loc.getLatitude(), loc.getLongitude()));
        extras.putString(LocationService.LOCATION_CITY_KEY, ToolBox.location_addressInfo(getApplicationContext(), ToolBox.LOCATION_INFO_TYPE.CITY, loc.getLatitude(), loc.getLongitude()));
        extras.putString(LocationService.LOCATION_ADDRESS_KEY, ToolBox.location_addressInfo(getApplicationContext(), ToolBox.LOCATION_INFO_TYPE.ADDRESS, loc.getLatitude(), loc.getLongitude()));
        extras.putString(LocationService.LOCATION_POSTAL_CODE_KEY, ToolBox.location_addressInfo(getApplicationContext(), ToolBox.LOCATION_INFO_TYPE.POSTAL_CODE, loc.getLatitude(), loc.getLongitude()));
        
        Intent intent = new Intent();
        intent.setAction(LocationService.ACTION_LOCATION_CHANGED);
        intent.putExtras(extras);
        sendBroadcast(intent);
        if(ToolBox.LOG_ENABLE)
    		Log.d(Constants.TAG, "Manual location change broadcast message sent.");
    }
    
    
    /**
     * Displays a pop-up if the user disabled location based 
     * service notifications.
     */
    private void displayLocationOffersDisableAlert() {
    	
    	if((Boolean)ToolBox.prefs_readPreference(this, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_ALERTS_DISABLED, Boolean.class)) {
    		ToolBox.dialog_showCustomActionsDialog(this, 
    				getResources().getString(R.string.offers_location_configure_prompt_title), 
    				getResources().getString(R.string.offers_location_disabled_prompt_text), 
    				getResources().getString(R.string.action_yes),
    				new Runnable() {								
    					@Override
    					public void run() {
    						if(ApplicationBase.debugMode)
    							Log.d(Constants.TAG, "Enable location based offers.");
    						doEnableLocationOfferAlerts();
    					}
    				},							
    				getResources().getString(R.string.action_no),
    				new Runnable() {								
    					@Override
    					public void run() {									
    						if(ApplicationBase.debugMode)
    							Log.d(Constants.TAG, "Do not enable location based offers.");						
    					}
    				}, 
    				null, null);
    	}
    }
    /**
     * Enables the location based service if has 
     * been disabled by the user.
     */
    private void doEnableLocationOfferAlerts() {
    	//We save the selected option
    	ToolBox.prefs_savePreference(this, Constants.PREF_NAME, 
    			Constants.PREF_KEY__LOCATION_ALERTS_DISABLED, Boolean.class, false);    			
		((ApplicationBase)getApplication()).stopLocationService();
		
		prepareLocationModule();    			
	}
    
    
    /**
     * Opens the "What is new window" only if 
     * not showed before. 
     */
    public void showWhatIsNewDialog(){
    	if(ApplicationBase.enableWhatIsNewDialog) {
	    	String previousVersion = (String)ToolBox.prefs_readPreference(this, Constants.PREF_NAME, Constants.PREF_KEY__CURRVERSION, String.class);
	    	String currVersion = ToolBox.application_getVersion(this);
	    	
	    	if(previousVersion==null){
	    		ToolBox.prefs_savePreference(this, Constants.PREF_NAME, Constants.PREF_KEY__CURRVERSION, String.class, currVersion);
	    	}else{    		
	    		if((previousVersion!=null && !previousVersion.equalsIgnoreCase(currVersion))){
	    			openWhatIsNewDialog();
	    			ToolBox.prefs_savePreference(this, Constants.PREF_NAME, Constants.PREF_KEY__CURRVERSION, String.class, currVersion);
	    		}
	    	}		
    	}
    }
    
    /**
     * What is new dialog.
     */
    private void openWhatIsNewDialog(){
		final Dialog dialogn = new Dialog(this);
		 	dialogn.requestWindowFeature(Window.FEATURE_NO_TITLE);
		 	dialogn.setContentView(R.layout.what_is_new);
		 		   		 	
   		Button dialogButtonc = (Button) dialogn.findViewById(R.id.dialogNewsButtonOK);
 		dialogButtonc.setOnClickListener(new OnClickListener() {		 			
 			public void onClick(View v) {				
 				dialogn.dismiss();
 			}
 		});
		 	
		dialogn.show();
	}
    
    /**
     * Creates a pop-up explaining how to scan.
     */
    public void createScanCodeTipDialog() {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		
		// Inflate and set the layout for the dialog
	    // Pass null as the parent view because its going in the dialog layout
		final View v = getLayoutInflater().inflate(R.layout.code_scan_tip, null);		
		final CheckBox noTip = (CheckBox)v.findViewById(R.id.checkbox_scan_code_tip);
		builder.setView(v);
	    
		builder.setPositiveButton("OK",
				new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id) {						
						if(noTip.isChecked()){
							ToolBox.prefs_savePreference(getApplicationContext(), Constants.PREF_NAME, Constants.PREF_KEY__SHOWSCANTIP, Boolean.class, true);
						}
						
						//ZXing code Scanner
						initiateCodeScan();
					}
				});
		builder.setNegativeButton("Cancelar",
				new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id) {
						
					}
				});
		// Create the AlertDialog object and return it
		final AlertDialog infoDialog = builder.create();

		infoDialog.show();
	}
    
    
    // ----- PROGRESS INDICATOR ----------------------------------------------------------
    
	/** Progress indicator style type. */
    private static enum PROGRESS_INDICATOR_STYLE {PBAR, PDIALOG, BOTH};
    
    /**
     * Toggles a progress indicator of the specified type.
     * 
     * @param toggle @{code PROGRESS_INDICATOR_STYLE}
     * @param style
     */
    private void toggleProgressIndicator(boolean toggle, PROGRESS_INDICATOR_STYLE style) {
    	switch (style) {
			case PBAR:
				togglePBar(toggle);
				break;
			case PDIALOG:
				togglePDialog(toggle);
				break;
			case BOTH:
				togglePBar(toggle);
				togglePDialog(toggle);
				break;
			default:
				togglePBar(toggle);
				break;
		}
    }
    
    private void togglePDialog(boolean toggle) {
    	if(toggle) {
    		if(progressDialog==null){
    			createProgressDialog();
    		}		
    				
    		if(!progressDialog.isShowing()){
    			progressDialog.show();
    			toggleDisabledLayout(true);
    		}
    	}else{
    		progressDialog.dismiss();
    		toggleDisabledLayout(false);
    	}    	
    }
    
    private void togglePBar(boolean toggle) {
    	if(toggle) {
	    	if(progressBar.getVisibility()!=View.VISIBLE){
	    		pzonefb.setVisibility(View.VISIBLE);
				progressBar.setVisibility(View.VISIBLE);
				toggleDisabledLayout(true);
			}
    	}else{
    		progressBar.setProgress(0);
    		progressBar.setVisibility(View.GONE);
    		pzonefb.setVisibility(View.GONE);
    		
    		//Just in case, check the progress dialog.
            if (progressDialog!=null && progressDialog.isShowing()) {
            	progressDialog.dismiss();
            }
            
            toggleDisabledLayout(false);
    	}
    }
    
    private void createProgressDialog() {
    	progressDialog = new ProgressDialog(this);
    	progressDialog.setCancelable(false);
    	progressDialog.setCanceledOnTouchOutside(false);
        progressDialog.setTitle(getString(R.string.application_company));
        progressDialog.setMessage(getString(R.string.url_loading));
    }
    
    private void toggleDisabledLayout(boolean toggle) {
    	if(toggle) {
    		if(disabledZone.getVisibility()!=View.VISIBLE)
    			disabledZone.setVisibility(View.VISIBLE);
    	}else{
    		disabledZone.setVisibility(View.GONE);
    	}
    }
    
    // ----- END PROGRESS INDICATOR ------------------------------------------------------
    
    
    private boolean alertNoNetworkShown = false;
    private void showNoNetworkAlert() {
    	if(!alertNoNetworkShown) {
    		lastUrl = null;
    		
	        AlertDialog.Builder builder = new AlertDialog.Builder(this);
	        builder
	                .setMessage(getString(R.string.app_error_loading))
	                .setCancelable(false).setPositiveButton("Cerrar",
	                        new DialogInterface.OnClickListener() {
	                            public void onClick(DialogInterface dialog, int id) {
	                            	dialog.dismiss();
	                            	alertNoNetworkShown = false;
	                            }
	                        });        
	        AlertDialog alert = builder.create();
	        alert.show();
	        alertNoNetworkShown = true;
    	}
    }
    
    /**
     * Shows the refresh zone layout.
     */
    private void showRefreshZone() {
    	refreshZone.setVisibility(View.VISIBLE);
    	refreshZoneText.setText(R.string.app_error_loading);
    	refreshZoneIcon.setVisibility(View.VISIBLE);
    }
    
    /**
     * Configures the disabled zone. This layout is visible
     * every time the application loads a page.
     */
    private void initDisabledZone() {
    	//This layout is used in conjunction with progress indicator
        //to avoid the user touch anywhere before load ends.
        disabledZone = (FrameLayout)findViewById(R.id.disabledZone);
        disabledZone.getBackground().setAlpha(75); //0 to 255 (fully transparency)
        //We make this layout non responsive to touch events
        disabledZone.setOnTouchListener(new OnTouchListener() {			
			@Override
			public boolean onTouch(View v, MotionEvent event) {
				v.performClick();
				return true;
			}
		});
        disabledZone.setVisibility(View.GONE);
    }
    
    /**
     * Configures the refresh zone. This layout appears when 
     * application starts and there is no internet.
     */
    private void initRefreshZone() {
    	refreshZone =  (LinearLayout)findViewById(R.id.refreshZone);
        refreshZoneText =  (TextView)findViewById(R.id.refreshZoneText);
        refreshZoneIcon =  (ImageView)findViewById(R.id.refreshZoneIcon);
        refreshZoneIcon.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				v.playSoundEffect(SoundEffectConstants.CLICK);  
				
				if((Boolean)ToolBox.prefs_readPreference(getApplicationContext(), Constants.PREF_NAME, Constants.PREF_KEY__NETWORK_STATUS, Boolean.class)){
					if(myWebView.getUrl()==null){
						myWebView.loadUrl(currURL);
					}else{
						//myWebView.reload();
						myWebView.loadUrl(previous.get((previous.size()-1)));
					}
				}else{
					showNoNetworkAlert();
				}
			}
		});
    }
    
    /**
     * Initialize the WebView component.
     * 
     * @param myWebView
     */
    @SuppressLint({ "NewApi", "SetJavaScriptEnabled" })
	private void initWebViewComponent (WebView myWebView) {
    	myWebView.setBackgroundResource(android.R.color.white);
    	
    	//Configure the web view
        myWebView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
        myWebView.setBackgroundColor(Color.TRANSPARENT);
        WebSettings webSettings = myWebView.getSettings();
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSettings.setSupportMultipleWindows(false);
        webSettings.setSupportZoom(false);
        //webSettings.setLoadWithOverviewMode(true);
        //webSettings.setSavePassword(true);
        webSettings.setSaveFormData(true);
        //To alter webView default cache behaviour
        //webSettings.setAppCacheEnabled(true);
        //webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
        if(ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {
        	webSettings.setGeolocationEnabled(true); //Allows to use it within the web
        }else{
        	webSettings.setGeolocationEnabled(false);
        }
        
        if(ToolBox.device_hasAPILevel(ToolBox.ApiLevel.LEVEL_21)) {
	        //When having a HOME address with HTTPS, we have to decide what to do with
	        //content not in HTTPS (mixed-mode)
	        switch (ApplicationBase.mixedModeAlwaysAllowed) {
				case DISALLOW:
					webSettings.setMixedContentMode(WebSettings.MIXED_CONTENT_NEVER_ALLOW);
					break;
				case ALLOW:
					webSettings.setMixedContentMode(WebSettings.MIXED_CONTENT_COMPATIBILITY_MODE);
					break;
				case ALLOW_ALL:
					webSettings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
					break;
			}
        }
        
        //DOMStorage is more related to HTML5. When user close the navigator
        //all data is lost because is session related.
        //webSettings.setDomStorageEnabled(true);
        //The Web SQL Database API isn't actually part of the HTML5 specification 
        //but it is a separate specification which introduces a set of APIs to 
        //manipulate client-side databases using SQL.
        //webSettings.setDatabaseEnabled(true);
        //Where to save the databases.
        //webSettings.setDatabasePath(getApplicationContext().getFilesDir().getPath());
        //webSettings.setGeolocationDatabasePath(getApplicationContext().getFilesDir().getPath());
        
        //Activate cookies
        syncManager = CookieSyncManager.createInstance(myWebView.getContext());
        cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        //To ensure the third party cookies are enabled for Apps that target 
        //android.os.Build.VERSION_CODES.KITKAT or higher. Below KITKAT are
        //enabled by default.
        if(Build.VERSION.SDK_INT > Build.VERSION_CODES.KITKAT) {
        	cookieManager.setAcceptThirdPartyCookies(myWebView, true);
        }

        //This allows to call JS functions in the webview's web.
        //http://developer.android.com/reference/android/webkit/WebSettings.html#setAllowContentAccess(boolean)
        //To do so:
        //  myWebView.loadUrl("javascript:web_js_method('som_string')");
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB){
        	webSettings.setAllowContentAccess(true);
        }        

        //This enables the JS in the webviews's content.
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(false);
        //This enables to expose to webviews's web some native android app methods.
        ApplicationBase.appWebJSInterface = new WebAppJSInterface(this);
        myWebView.addJavascriptInterface(ApplicationBase.appWebJSInterface, "Android");
        //NOTE: To check if we are in Android native app, we check using
        //		JS:
        //			if("Android" in window){....} 
        //		...where "Android" is the native app JS object
        //		implementation.
        
        //This will add application info to user agent.
        //(We could use this also to determine if web is running 
        // inside an Android application)
        myWebView.getSettings().setUserAgentString(
    		    myWebView.getSettings().getUserAgentString() 
    		    + " "
    		    + Constants.APP_USER_AGENT_ANDROIDAPP_SUFFIX 
    		    + " "
    		    + Constants.APP_USER_AGENT_SUFFIX
    		);
        
        //Remote WebView debugging.
        //	See:
        //		https://developer.chrome.com/devtools/docs/remote-debugging
        //
        //To do this we need:
        // - Chrome 32 or later installed on your development machine.
        // - A USB cable to connect your Android device.
        // - For App debugging: Android 4.4+ and a WebView configured for debugging.
        //	 (Screencast is only available for v4.4.3+)
        // - Also for browser debugging: Android 4.0+ and Chrome for Android.
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT &&
          	(getApplicationInfo().flags!=0 && ApplicationInfo.FLAG_DEBUGGABLE!=0)) {
        	WebView.setWebContentsDebuggingEnabled(true);
        }
        
        //Set custom web view web client
        configureCustomWebviewWebClient(this);
    }
    
    /** 
     * This field contains the last URL loaded. It is used in onPageFinished to avoid
     * doing some behavior more than one time because Android sometimes calls more than
     * one time this method in the same URL when finished loading. */
    private String lastUrl = null;
    /** We use this to be able to know if the webview has finished rendering the page. */
    private boolean finishedRendering = true;
    
    /**
     * Custom webview's client, to control more precisely the actions and errors.
     * 
     * @param activity
     */
    private void configureCustomWebviewWebClient (final Activity activity) {
    	
    	/*
    	 * Called when things happen that impact the rendering of the content, eg, errors or
    	 * form submissions. You can also intercept URL loading here 
    	 * (via shouldOverrideUrlLoading()).
    	 * 
    	 *  http://developer.android.com/reference/android/webkit/WebView.html
    	 */
    	myWebView.setWebViewClient(new WebViewClient() {

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                
                if(url.equals(Constants.PROTRACTOR_URL)) {
                	view.stopLoading(); //Avoid this page
                	return;
                }
                
                if(url.equals("about:blank")){ //Do nothing
                	return;
                }
                
                finishedRendering = false;

                //We reset the value each time a page is loaded
                ApplicationBase.isPageWithLocationBehavior = false;
                
                if(ApplicationBase.debugMode) {
                	Log.i(Constants.TAG, "Loading page: [" + url + "]");
                	Log.i(Constants.TAG, "User Agent: [" + myWebView.getSettings().getUserAgentString() + "]");
                }

                //This is manually skipped because goes to an Adyen error page.
                if(url.contains("live.adyen.com") && url.endsWith("#")){
            		view.stopLoading(); //Avoid this page
            		webHistory_goBack();
            	}
                
                // 11 = Build.VERSION_CODES.HONEYCOMB (Android 3.0)
                if (Build.VERSION.SDK_INT < 11) {

                    // According to this page:
                    //
                    // http://www.catchingtales.com/android-webview-shouldoverrideurlloading-and-redirect/416/
                    //
                    // shouldOverrideUrlLoading() is not called for redirects on
                    // Android earlier than 3.0, so call the method manually.
                    //
                    // The implementation of shouldOverrideUrlLoading() returns
                    // true only when the URL starts with the callback URL and
                    // dummyCallbackUrl is true.
                    if (shouldOverrideUrlLoading(view, url)) {
                        view.stopLoading();
                    }
                }
                
                //Check if there is network issues before loading
                if(!(Boolean)ToolBox.prefs_readPreference(getApplicationContext(), Constants.PREF_NAME, Constants.PREF_KEY__NETWORK_STATUS, Boolean.class)){
                	//Avoid URL loading if there is no Internet
                	view.stopLoading();
                	showRefreshZone();
                	showNoNetworkAlert();
                }else{
                	//Show the progress bar
                	toggleProgressIndicator(true, PROGRESS_INDICATOR_STYLE.PBAR);
                	
                	//We hide the refresh icon and change the text to loading :)
                	refreshZoneIcon.setVisibility(View.GONE);
                	refreshZoneText.setText(R.string.url_loading);
                }
            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
            	if(ApplicationBase.debugMode)
            		Log.d(Constants.TAG, "Processing web view shouldOverrideUrlLoading url click...");
                
            	if(url.equals("about:blank")){ //Do nothing
                	return false;
                }
            	
            	//If the URL is not from the web-app URL we launch the
                //URL in the default system browser.
            	if(!urlStartsWithHomeURL(url)){
                	Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                	startActivity(browserIntent);
                	return true;                	
                }else{
                	if(!(Boolean)ToolBox.prefs_readPreference(getApplicationContext(), Constants.PREF_NAME, Constants.PREF_KEY__NETWORK_STATUS, Boolean.class)){
                		//Avoid URL loading if there is no internet
                    	view.stopLoading();
                    	//Show Refresh zone
                    	showRefreshZone();
                    	showNoNetworkAlert();
                	}                	
                	return false;
                }
            }

            @Override
            public void onPageFinished(final WebView view, String url) {
                super.onPageFinished(view, url);
                if(ApplicationBase.debugMode)
                	Log.d(Constants.TAG, "Finished loading URL: " +url);
                
                if(url.equals(Constants.PROTRACTOR_URL)) {
                	view.stopLoading(); //Avoid this page
                	return;
                }
                
                if(url.equals("about:blank")){ //Do nothing
                	return;
                }
                
                /* We do not need this.
                 * if(!url.equalsIgnoreCase(Constants.PAGE_404ERROR)) {
                    currURL = url;
                }*/
                
                syncManager.sync();
                toggleProgressIndicator(false, PROGRESS_INDICATOR_STYLE.PBAR);
                
              	//TODO Find a oficial FIX. WebView does not call to:  
                //		- WebChromeClient onGeolocationPermissionsShowPrompt()
                //		- WebChromeClient onPermissionRequest()
                //
                //	   Because of this, a page that requires permissions for location
                //	   purposes does not get limited. To avoid this we call to a 
                //	   JavaScript function in the page to tell the address or remove
                //	   it.
                //	   	  updateLocation(address, lat, lng, country);
                //
                //	   This solution makes on Android 6+ the list of coupons to be loaded
                //	   twice, one with location (if location is enabled in the device) and 
                //	   the other when we set the location to null.
                //	   
                //	   We have to modify ColectivosVip to never get the location in case 
                //	   of an Android app and tell to the page after loaded the location
                //	   vía native location data.
                if(ToolBox.device_getAPILevel()>=23 &&   
                    !ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {
                	if(ApplicationBase.debugMode)
                		Log.d(Constants.TAG, "Android 6+ Detected. In this case, a web page geolocalization does not respond to WebView settings,"
                    		+ " it checks if the location is enabled in the system. Setting location to none manually.");
                    view.post(new Runnable() {
	                	public void run() {	                			
	                       	view.loadUrl("javascript:updateLocation(null,null,null,null)");
	                       }
	                	});                	
                }
                
                //Check network and load errors ------------------------------
            	if(ToolBox.net_isNetworkAvailable(getApplicationContext()) 
            			&& refreshZone.getVisibility()==View.VISIBLE 
                		&& !urlLoadError){
                	//We hide the refresh screen once page is loaded
            		refreshZone.setVisibility(View.GONE);              	
            	}else{
            		refreshZoneText.setText(R.string.app_error_loading);
                    refreshZoneIcon.setVisibility(View.VISIBLE);
            	}                            
                urlLoadError = false;
                //-------------------------------------------------------------
                
                if(lastUrl==null ||  
                	(lastUrl!=null && !lastUrl.equalsIgnoreCase(url))){
                	webHistory_addPage(url);
                    lookForLocationBahaviorInPage(view);
                }
                    
                lastUrl = url;
            }

            @Override
            public void onReceivedError(WebView view, int errorCode, String description,
                                        String failingUrl) {
            	
            	//We exclude this URL from showing a error box because is manually
            	//skipped every time.
            	if(failingUrl.contains("live.adyen.com") && failingUrl.endsWith("#")){
            		return;
            	}
            	
            	if(ApplicationBase.debugMode)
            		Toast.makeText(activity, getString(R.string.url_loading_error) +
            				description, Toast.LENGTH_SHORT).show();
                                
                //Show the refresh screen if load error.
                showRefreshZone();                
                showNoNetworkAlert();
                
                urlLoadError = true;
                
                //We do not need this.
                //myWebView.loadUrl(Constants.PAGE_404ERROR);
                
                //We clear the page so nothing is shown
                if (Build.VERSION.SDK_INT < 18) {
            	   myWebView.clearView();
            	} else {
            	   myWebView.loadUrl("about:blank");
            	}
            }
            
            @Override
            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error){
            	if(ApplicationBase.debugMode)
            		Log.e(Constants.TAG, "SSL Error [" + error.toString() + "]");
            	
            	if(!ApplicationBase.enableBypassSSLUrlFailures) {
	                handler.cancel();
	                
	                Toast.makeText(activity, getString(R.string.url_loading_error) +
	                        " SSL ERROR", Toast.LENGTH_SHORT).show();
	                                
	                //Show the refresh screen if load error.
	                showRefreshZone();                
	                showNoNetworkAlert();
	                
	                urlLoadError = true;
	                
	                //We clear the page so nothing is shown
	                if (Build.VERSION.SDK_INT < 18) {
	            	   myWebView.clearView();
	            	} else {
	            	   myWebView.loadUrl("about:blank");
	            	}
            	}else{      
            		if(ApplicationBase.debugMode)
            			Log.w(Constants.TAG, "SSL Error [" + error.toString() + "]. ATTENTION! Bypassing SSL restrictions.");
            		handler.proceed();
            	}
            }
        });
        
        /* 
         * For more advanced possibilities and processing like
         *  handle JavaScript dialogs, favicons, titles, progress
         *  and more.
         *  
         *  See http://developer.android.com/reference/android/webkit/WebView.html
         *  
         *  This class is called when something that might impact a browser UI happens, for 
    	 *  instance, progress updates and JavaScript alerts are sent here (see Debugging Tasks
    	 *  at http://developer.android.com/guide/developing/debug-tasks.html#DebuggingWebPages)
         */
        myWebView.setWebChromeClient(new WebChromeClient() {

        	@Override
        	public void onProgressChanged(WebView view, int progress) {
        		// Activities and WebViews measure progress with different scales.
        		// The progress meter will automatically disappear when we reach 100%
        		//activity.setProgress(progress * 1000);        		
        		
        		progressBar.setProgress(progress);
        		
        		if(progress==100){
        			finishedRendering = true;
        		}
        	}
        	
			@Override
			public void onReceivedTitle(WebView view, String title) {
				if(ApplicationBase.debugMode)
					Log.d(Constants.TAG, "Web title: " + title);
				super.onReceivedTitle(view, title);
			}

			@Override
			public void onReceivedIcon(WebView view, Bitmap icon) {
				super.onReceivedIcon(view, icon);
			}

			@Override
			public boolean onJsTimeout() {
				if(ApplicationBase.debugMode)
					Log.d(Constants.TAG, "JS Timeout");				
				return super.onJsTimeout();				
			}

			@Override
			public void onConsoleMessage(String message, int lineNumber,
					String sourceID) {
				super.onConsoleMessage(message, lineNumber, sourceID);
				
				//To catch JS errors and printing statements in logcat.
				Log.d(Constants.TAG, message + " -- From line " + lineNumber + " of " + sourceID);
			}
			
			@Override
			public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
				if(ApplicationBase.debugMode)
					Log.d(Constants.TAG, "JS ALert");
			    
			    // This shows the dialog box. Avoiding the JS default alert box.
			    AlertDialog.Builder alertBldr = new AlertDialog.Builder(activity);
			    alertBldr.setMessage(message);
			    alertBldr.setTitle(Constants.TAG);
			    alertBldr.show();
			    
			    result.confirm();
			    
			    return true;
			}

			@Override
			public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
				//NOTE: Only called for Android API Level < 23
				if(ApplicationBase.debugMode)
					Log.d(Constants.TAG, "JS GeoLocation permission Prompt");
				//This allows to use GeoLocation within the web.
				boolean allow = false;
				if(ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {
					allow = true;
				}
				//This way we disable at runtime the requests if permission
				//is not granted.
				myWebView.getSettings().setGeolocationEnabled(false);				
				callback.invoke(origin, allow, false);
		    }

			@Override
			public void onPermissionRequest(PermissionRequest request) {
				//Never called in Android 6+
				if(ToolBox.permission_areGranted(PrincipalActivity.this, ToolBox.PERMISSION_LOCATION.keySet())) {					
					request.grant(request.getResources());
					super.onPermissionRequest(request);
				}else{
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "JS GeoLocation permission denied.");
					request.deny();
				}				
		    }
        });        
    }
    
    /**
     * Looks for some code in the page to know if location behavior is
     * required or not.<br><br>
     * 
     * NOTE: To enable for all versions we should add a method in the 
     * page that tell to the page for the location instead using this.
     * 
     * @param view
     */
    //@TargetApi(Build.VERSION_CODES.KITKAT)
	@SuppressLint("NewApi")
	private void lookForLocationBahaviorInPage(WebView view) {
    	ApplicationBase.isPageWithLocationBehavior = false;
    	
    	if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
    		String js = "(function(c) { for (var a = document.getElementsByTagName(\"meta\"), b = 0;b < a.length;b++) { " + 
    	    		  "if (c == a[b].name || c == a[b].getAttribute(\"property\")) { return a[b].content; } } return false;" +
    	    		"})(\"" + ApplicationBase.LOCATION_ENABLED_META_TAG_NAME + "\");";
    		
    		//We look for something in the loaded page
	    	view.evaluateJavascript(js,
	        		new ValueCallback<String>() {				
						@Override
						public void onReceiveValue(String html) {
							Log.d("META TAG (" + ApplicationBase.LOCATION_ENABLED_META_TAG_NAME + ") get from Page: ", html);
							if(!html.equalsIgnoreCase("false")){
								for(String s:ApplicationBase.LOCATION_ENABLED_META_TAG_VALUES){
									if(html.contains(s)){
										ApplicationBase.isPageWithLocationBehavior = true;
										new Thread(new Runnable() {											
											@Override
											public void run() {
												checkServiceLocation();
											}
										}).start();
										break;
									}
								}
							}							
						}
					}
	        );
    	}else{
    		//TODO The best solution for this case should be to implement a 
    		//call in the web page to our native app to set the variable and 
    		//start the service.
    		//    	 
    		if(view.getUrl().endsWith("mobile/")){
    			ApplicationBase.isPageWithLocationBehavior = true;
    		}else{
	    		for(String s:ApplicationBase.LOCATION_ENABLED_PAGES){
	    			if(view.getUrl().contains(s)){
	        			ApplicationBase.isPageWithLocationBehavior = true;
	        			break;
	    			}
	    		}
    		}
    		checkServiceLocation();
    	}
    	
    }
    
	private void checkServiceLocation() {
		if(ApplicationBase.enableLocation && ApplicationBase.enableInitialLocation) {
        	if(ApplicationBase.isPageWithLocationBehavior){
        		prepareLocationModule();
        	}else{
        		((ApplicationBase)getApplication()).stopLocationService();
        	}
    	}else{
    		((ApplicationBase)getApplication()).stopLocationService();
    	}
	}
    
    // WebView HISTORY -----------------------------------------------------------------------------
    // (We do not use the webview's history because we show a html error page
    // when a network error happens).
    private void webHistory_addPage(String url){
        if(ApplicationBase.enableBackButtonHistory 
        		&& !url.equalsIgnoreCase(Constants.PAGE_404ERROR) && !previous.contains(url) 
        		&& !url.contains("live.adyen.com")
        		&& !url.contains("offer-order-payment.action")
        		){        	
            previous.add(url); //Add page to the history
        }
    }

    private void webHistory_goBack() {
    	if(!ApplicationBase.enableBackButtonHistory) {
    		ToolBox.backPressedAction(this, Constants.EXIT_BACK_PRESS_TIME_INTERVAL, getString(R.string.exit_confirmation), false, ToolBox.TOAST_TYPE.INFO);
    	}else{
	        //We want the previous one so we remove the current one
	        previous.remove(previous.size()-1); //Remove entry from history
	        if(previous.size()>0) {
	            //Go to the previous one.
	            myWebView.loadUrl(previous.get(previous.size() - 1));
	            previous.remove(previous.size() - 1); //Remove entry from history
	        }else{
	        	ToolBox.backPressedAction(this, Constants.EXIT_BACK_PRESS_TIME_INTERVAL, getString(R.string.exit_confirmation), false, ToolBox.TOAST_TYPE.INFO);        	
	        }	    
    	}
    }
    
    private void webHistory_show() {
        int i = 0;
        for(String s:previous){
        	Log.d(Constants.TAG + ": History: ", "Position: " + i + " URL: " + s);
            i++;
        }
    }
    
    // End WebView HISTORY. ------------------------------------------------------------------------

    /**
     * This initiates the ZXing code scanner.
     *
     * See:
     *  GitHub: https://github.com/zxing/zxing
     *  Docs:   http://zxing.github.io/zxing/project-info.html
     *  Usage: https://github.com/zxing/zxing/wiki/Scanning-Via-Intent
     *  Source: https://github.com/zxing/zxing/blob/master/android-integration/src/main/java/com/google/zxing/integration/android/IntentIntegrator.java
     *
     *  Other links:
     *      http://zomwi.blogspot.com.es/2012/09/zxing.html
     *      http://damianflannery.wordpress.com/2011/06/13/integrate-zxing-barcode-scanner-into-your-android-app-natively-using-eclipse/
     */
    public void initiateCodeScan () {
        IntentIntegrator integrator = new IntentIntegrator(PrincipalActivity.this);
        integrator.initiateScan();
    }

    /**
     * Returning a string implies to url encode
     * to avoid issues in the JS function when
     * using as function parameter.
     * 
     * @param data	data to url encode
     * @return  The url encoded result or ERROR string.
     */
    private String urlEncode(String data) {
    	String res = "ERROR";
		try {
			res = URLEncoder.encode(data, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			Log.e(Constants.TAG, "WebAppInterface. Error encoding to UTF-8 the result for the web [" + e.getMessage() + "]");
		}
		
		return res;
    }	
    
    /**
     * Tells if we are exactly at one of the declared
     * home pages. See {@link Constants#VV_URL}
     * 
     * @param url
     * @return
     */
    private boolean urlIsHomeURL(String url){
    	for(String h:Constants.VV_URL){
    		if(h.equals(url)){
    			return true;    			
    		}
    	}
    	
    	return false;
    }
    
    private boolean urlStartsWithHomeURL(String url){
    	for(String h:Constants.VV_URL){
    		if(url.startsWith(h)){
    			return true;    			
    		}
    	}
    	
    	return false;
    }
    
    //SAVE/LOAD IN/FROM CLOUD ---------------------------------------------------------------------
    
    private AppData appData = new AppData();
    
    int step = 0;
    
    private void testCloud() {
    	if(step==0){
        	step++;
        	appData.addData("Edad",Integer.valueOf(39));
        	savePrefsInCloud(appData, "appdata.txt");                    	                        
        }else if(step == 1) {
        	step++;
        	appData = null;
        	getPrefsFromCloud("appdata.txt");
        }else if(step == 2){
        	step++;
        	if(appData.getData("Edad")!=null){
        		int count = ((Double)appData.getData("Edad")).intValue();
        	}                    	
        }else{
        	step = 0;
        	if(ApplicationBase.enableGDrive) {
            	//((ApplicationBase)getApplication()).tbDrive.drive_disconnect();
            }
        }
    }
    
    Handler handlerCloud = new Handler(new Callback() {
		
		@Override
		public boolean handleMessage(Message msg) {
			final String content = (String)msg.obj;
			
			CloudOperationResult opResult = CloudOperationResult.getCloudOperationResult(msg.what);
			switch (opResult) {
				case OK_LOAD:
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "Content loaded: " + content);
					appData = GsonProcessor.getInstance().getGson().fromJson(content, AppData.class);
					break;
				case OK_SAVE:
					if(ApplicationBase.debugMode)
						Log.d(Constants.TAG, "Content saved.");
					handler.post(new Runnable() {						
						@Override
						public void run() {
							ToolBox.dialog_showToastAlert(thiz, "Data saved to the cloud.", false, false, ToolBox.TOAST_TYPE.INFO);
						}
					});					
					break;
				case LOAD_ERROR:
					handler.post(new Runnable() {						
						@Override
						public void run() {
							ToolBox.dialog_showToastAlert(thiz, "Error loading data from the cloud [" + content + "].", false, false, ToolBox.TOAST_TYPE.ERROR);
						}
					});
					break;
				case WRITE_ERROR:
					handler.post(new Runnable() {						
						@Override
						public void run() {
							ToolBox.dialog_showToastAlert(thiz, "Error saving data to the cloud [" + content + "].", false, false, ToolBox.TOAST_TYPE.ERROR);
						}
					});
					break;
				case NOT_EXISTS:
					handler.post(new Runnable() {						
						@Override
						public void run() {
							ToolBox.dialog_showToastAlert(thiz, "Error. Data file to load does not exist!", false, false, ToolBox.TOAST_TYPE.ERROR);
						}
					});
					break;
				default:
					break;
			}
						
			return false;
		}		
		
	});
    
    /**
     * Class to store any type of data.
     * 
     * This data can be saved in Google Drive cloud.
     * 
     */
    class AppData {
    	
    	private Map<String, Object> dataTokens;
    	
    	public AppData(){
    		dataTokens = Collections.synchronizedMap(new HashMap<String, Object>());
    	}

		    	
    	public void addData(String key, Object data) {
    		dataTokens.put(key, data);
    	}
    	
    	public Object getData(String key) {
    		if(dataTokens.containsKey(key)){
    			return dataTokens.get(key);
    		}else{
    			return null;
    		}
    	}
    	
    }
    
    private boolean savePrefsInCloud(AppData data, String fileName) {
    	boolean res = false;
    	
    	if(ApplicationBase.enableGDrive) {	        
			try {
				String jsonData = GsonProcessor.getInstance().getGson().toJson(data);
				((ApplicationBase)getApplication()).tbDrive.saveStringDataInCloud(jsonData, fileName, new TBDriveFileCreationListener(getApplicationContext()), handlerCloud, false);				
			} catch (Exception e) {
				Log.e(Constants.TAG, "Error saving preferences in the cloud [" + e.getMessage() + "]", e);
			}   
    	}
    	
    	return res;
    }
    
    private void getPrefsFromCloud(String fileName) {
    	if(ApplicationBase.enableGDrive) {    		
    		((ApplicationBase)getApplication()).tbDrive.getStringDataFromCloud(fileName, handlerCloud);
    	}    	
    }
    
}
