/*
 * Decompiled with CFR 0.152.
 */
package es.javocsoft.android.lib.toucan.client.thread;

import android.content.Context;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toucan.client.response.Response;
import es.javocsoft.android.lib.toucan.client.response.exception.ResponseParseException;
import es.javocsoft.android.lib.toucan.client.thread.ToucanWorker;
import es.javocsoft.android.lib.toucan.client.thread.callback.ResponseCallback;
import java.util.HashMap;

public class ToucanGetWorker
extends ToucanWorker {
    public ToucanGetWorker(Context context, String apiToken, String endpoint, String opName, ResponseCallback callback) {
        super(ToucanWorker.TOUCAN_WORKER_TYPE.GET, context, apiToken, endpoint, opName, callback);
    }

    public ToucanGetWorker(ToucanWorker tWorker) {
        super(ToucanWorker.TOUCAN_WORKER_TYPE.GET, tWorker.context, tWorker.apiToken, tWorker.data, tWorker.dataType, tWorker.endpoint, tWorker.opname, tWorker.callback);
    }

    @Override
    public void doWork() {
        try {
            HashMap<String, String> headersData = new HashMap<String, String>();
            headersData.put("Authorization", "ttmSecTKN " + this.apiToken);
            String finalUrl = this.endpoint;
            String jsonData = null;
            String jsonDataKey = null;
            String response = ToolBox.net_httpclient_doAction((ToolBox.HTTP_METHOD)ToolBox.HTTP_METHOD.GET, (String)finalUrl, jsonDataKey, jsonData, headersData);
            Log.i((String)"ToucanClient", (String)(this.opname.toUpperCase() + ". Sent to Toucan API. Call response '" + response + "'"));
            Response res = this.parseResponse(response);
            if (res.getCode() == 0) {
                Log.i((String)"ToucanClient", (String)"Operation done and response from server OK.");
            } else {
                Log.i((String)"ToucanClient", (String)("Operation done but response code not OK [Code: " + res.getCode() + "]->" + res.getMsg()));
            }
            this.operationDone(true, res);
        }
        catch (ResponseParseException e) {
            Log.e((String)"ToucanClient", (String)("Error parsing server response for operation '" + this.opname.toUpperCase() + "' request to Toucan API (" + e.getMessage() + ")"), (Throwable)e);
            this.operationDone(false, null);
        }
        catch (Exception e) {
            Log.e((String)"ToucanClient", (String)("Error in operation " + this.opname.toUpperCase() + " request to Toucan API (" + e.getMessage() + ")"), (Throwable)e);
            this.operationDone(false, null);
        }
    }
}

