/*
 * Decompiled with CFR 0.152.
 */
package es.javocsoft.android.lib.toucan.client;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Base64;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.crypto.SHA1Encoding;
import es.javocsoft.android.lib.toolbox.crypto.exception.SHA1EncodingException;
import es.javocsoft.android.lib.toolbox.json.GsonProcessor;
import es.javocsoft.android.lib.toucan.client.request.ACKRequest;
import es.javocsoft.android.lib.toucan.client.request.AppDevTagsOperationRequest;
import es.javocsoft.android.lib.toucan.client.request.DeviceRegistrationRequest;
import es.javocsoft.android.lib.toucan.client.request.bean.DeviceRegistrationBean;
import es.javocsoft.android.lib.toucan.client.service.PendingOperationsDeliveryService;
import es.javocsoft.android.lib.toucan.client.thread.ToucanGetWorker;
import es.javocsoft.android.lib.toucan.client.thread.ToucanPostWorker;
import es.javocsoft.android.lib.toucan.client.thread.ToucanWorker;
import es.javocsoft.android.lib.toucan.client.thread.callback.ResponseCallback;
import java.net.URLEncoder;
import java.util.List;

public class ToucanClient {
    private static ToucanClient toucanClient;
    private static final String API_ENDPOINT_BASE = "http://clientes.tatamia.com";
    private static final String OS_TAG = "Android";
    public static final String LOG_TAG = "ToucanClient";
    private Context context = null;
    private String appPublicKey = null;
    private String deviceUniqueId = null;
    private String deviceNotificationToken = null;
    private String apiToken = null;
    private String OSInfo = null;
    private String DEVInfo = null;
    private static final String PREF_NAME = "toucan_client_prefs";
    private static final String PREF_KEY_DEVICE_UNIQUEID = "toucan_client_key_devuniqueid";
    private static final String PREF_KEY_DEVICE_NOT_TOKEN = "toucan_client_key_devnottoken";
    public static final String CACHED_REQUEST_FILE_PREFIX = "toucan_client_pending_request_";
    public static final String NOTIFICATION_MESSAGE_TEXT = "message";
    public static final String NOTIFICATION_MESSAGE_REF = "nRef";
    public static final String NOTIFICATION_MESSAGE_ID = "nId";
    public static final String NOTIFICATION_MESSAGE_TS = "ts";
    private static final String API_ENDPOINT_REGISTRATION = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?dr";
    private static final String API_ENDPOINT_UNREGISTRATION = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?du";
    private static final String API_ENDPOINT_ENABLE_REGISTERED_DEVICE = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?de";
    private static final String API_ENDPOINT_ACK_RECEIVED = "http://clientes.tatamia.com/PushNOTApi/ackreport?op=2";
    private static final String API_ENDPOINT_ACK_READ = "http://clientes.tatamia.com/PushNOTApi/ackreport?op=1";
    private static final String API_ENDPOINT_ADD_TAGS = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?dta";
    private static final String API_ENDPOINT_REMOVE_TAGS = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?dtr";
    private static final String API_ENDPOINT_LIST_TAGS = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?dtl";
    private static final String API_ENDPOINT_RESET_TAGS = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?dtrs";
    private static final String API_OPERATION_DEVICE_REGISTRATION = "DeviceRegistration";
    private static final String API_OPERATION_DEVICE_UNREGISTRATION = "DeviceUnRegistration";
    private static final String API_OPERATION_DEVICE_ENABLE = "DeviceEnableRegistered";
    private static final String API_OPERATION_INFORM_REFERRAL = "InformReferral";
    private static final String API_OPERATION_ADD_TAGS = "AddTags";
    private static final String API_OPERATION_REMOVE_TAGS = "RemoveTags";
    private static final String API_OPERATION_LIST_TAGS = "ListTags";
    private static final String API_OPERATION_RESET_TAGS = "ResetTags";
    private static final String API_OPERATION_ACK_RECEIVED = "NotificationReceivedACK";
    private static final String API_OPERATION_ACK_READ = "NotificationReadACK";

    public static ToucanClient getInstance(Context context, String apiToken, String appPublicKey) {
        if (toucanClient == null) {
            toucanClient = new ToucanClient();
            ToucanClient.toucanClient.context = context;
            ToucanClient.toucanClient.appPublicKey = appPublicKey;
            ToucanClient.toucanClient.apiToken = apiToken;
            toucanClient.init();
        }
        return toucanClient;
    }

    private void init() {
        this.OSInfo = "Android " + ToolBox.device_getOSVersion() + " - " + "(API Level " + ToolBox.device_getAPILevel() + ")";
        this.DEVInfo = ToolBox.device_getExtraInfo();
        if (!ToolBox.prefs_existsPref((Context)this.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_UNIQUEID).booleanValue()) {
            String devUniqueId = ToolBox.device_getId((Context)this.context);
            ToolBox.prefs_savePreference((Context)this.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_UNIQUEID, String.class, (Object)devUniqueId);
            ToucanClient.toucanClient.deviceUniqueId = devUniqueId;
        } else {
            ToucanClient.toucanClient.deviceUniqueId = (String)ToolBox.prefs_readPreference((Context)this.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_UNIQUEID, String.class);
        }
    }

    private ToucanClient() {
    }

    public void deviceRegistration(String notificationToken, ResponseCallback callback) {
        ToucanClient.toucanClient.deviceNotificationToken = notificationToken;
        ToolBox.prefs_savePreference((Context)ToucanClient.toucanClient.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_NOT_TOKEN, String.class, (Object)notificationToken);
        if (callback != null) {
            callback.setCallbackOperation(4);
        }
        DeviceRegistrationRequest devRegRequest = this.generateDeviceRegistrationInfo(notificationToken);
        this.launchDeviceRegistrationRequest(devRegRequest, callback);
    }

    public void deviceRegistration(String notificationToken, int externalId, ResponseCallback callback) {
        ToucanClient.toucanClient.deviceNotificationToken = notificationToken;
        ToolBox.prefs_savePreference((Context)ToucanClient.toucanClient.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_NOT_TOKEN, String.class, (Object)notificationToken);
        DeviceRegistrationRequest devRegRequest = this.generateDeviceRegistrationInfo(notificationToken);
        if (externalId >= 1) {
            devRegRequest.getData().setExtId(externalId);
            String hashSignature = devRegRequest.getData().getSecurityHash(this.appPublicKey);
            devRegRequest.setHashSignature(hashSignature);
        }
        if (callback != null) {
            callback.setCallbackOperation(4);
        }
        this.launchDeviceRegistrationRequest(devRegRequest, callback);
    }

    public void deviceRegistration(String notificationToken, String installReferral, ResponseCallback callback) {
        ToucanClient.toucanClient.deviceNotificationToken = notificationToken;
        ToolBox.prefs_savePreference((Context)ToucanClient.toucanClient.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_NOT_TOKEN, String.class, (Object)notificationToken);
        DeviceRegistrationRequest devRegRequest = this.generateDeviceRegistrationInfo(notificationToken);
        if (installReferral != null && installReferral.length() > 0) {
            devRegRequest.getData().setInstallReferral(installReferral);
            String hashSignature = devRegRequest.getData().getSecurityHash(this.appPublicKey);
            devRegRequest.setHashSignature(hashSignature);
        }
        if (callback != null) {
            callback.setCallbackOperation(4);
        }
        this.launchDeviceRegistrationRequest(devRegRequest, callback);
    }

    public void deviceRegistration(String notificationToken, int externalId, String installReferral, ResponseCallback callback) {
        ToucanClient.toucanClient.deviceNotificationToken = notificationToken;
        ToolBox.prefs_savePreference((Context)ToucanClient.toucanClient.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_NOT_TOKEN, String.class, (Object)notificationToken);
        DeviceRegistrationRequest devRegRequest = this.generateDeviceRegistrationInfo(notificationToken);
        if (installReferral != null && installReferral.length() > 0) {
            devRegRequest.getData().setInstallReferral(installReferral);
        }
        if (externalId >= 1) {
            devRegRequest.getData().setExtId(externalId);
        }
        String hashSignature = devRegRequest.getData().getSecurityHash(this.appPublicKey);
        devRegRequest.setHashSignature(hashSignature);
        if (callback != null) {
            callback.setCallbackOperation(4);
        }
        this.launchDeviceRegistrationRequest(devRegRequest, callback);
    }

    public void informInstallReferral(String installReferral, ResponseCallback callback) {
        if (this.isNotificationTokenPresent()) {
            DeviceRegistrationRequest devRegRequest = this.generateDeviceRegistrationInfo(ToucanClient.toucanClient.deviceNotificationToken);
            if (installReferral != null && installReferral.length() > 0) {
                devRegRequest.getData().setInstallReferral(installReferral);
                String hashSignature = devRegRequest.getData().getSecurityHash(this.appPublicKey);
                devRegRequest.setHashSignature(hashSignature);
            }
            if (callback != null) {
                callback.setCallbackOperation(4);
            }
            this.launchInformReferralRequest(devRegRequest, callback);
        } else {
            Log.i((String)LOG_TAG, (String)(API_OPERATION_INFORM_REFERRAL.toUpperCase() + " Error. Notification token not stablished. Please, execute 'deviceRegistration()' first."));
        }
    }

    public void informExternalId(int externalId, ResponseCallback callback) {
        if (this.isNotificationTokenPresent()) {
            DeviceRegistrationRequest devRegRequest = this.generateDeviceRegistrationInfo(ToucanClient.toucanClient.deviceNotificationToken);
            if (externalId != 0) {
                devRegRequest.getData().setExtId(externalId);
                String hashSignature = devRegRequest.getData().getSecurityHash(this.appPublicKey);
                devRegRequest.setHashSignature(hashSignature);
            }
            if (callback != null) {
                callback.setCallbackOperation(4);
            }
            this.launchInformReferralRequest(devRegRequest, callback);
        } else {
            Log.i((String)LOG_TAG, (String)(API_OPERATION_INFORM_REFERRAL.toUpperCase() + " Error. Notification token not stablished. Please, execute 'deviceRegistration()' first."));
        }
    }

    public void doReceivedACK(Bundle notificationBundle, ResponseCallback callback) {
        if (this.isNotificationTokenPresent()) {
            ACKRequest ackRequest = this.generateACKnfo(notificationBundle);
            if (callback != null) {
                callback.setCallbackOperation(4);
            }
            if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
                new ToucanPostWorker(this.context, this.apiToken, ackRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.ACK, API_ENDPOINT_ACK_RECEIVED, API_OPERATION_ACK_RECEIVED, callback).start();
            } else {
                this.cacheOperationRequest(new ToucanPostWorker(this.context, this.apiToken, ackRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.ACK, API_ENDPOINT_ACK_RECEIVED, API_OPERATION_ACK_RECEIVED, callback), true);
            }
        } else {
            Log.i((String)LOG_TAG, (String)(API_OPERATION_ACK_RECEIVED.toUpperCase() + " Error. Notification token not stablished. Please, execute 'deviceRegistration()' first."));
        }
    }

    public void doReadACK(Bundle notificationBundle, ResponseCallback callback) {
        if (this.isNotificationTokenPresent()) {
            ACKRequest ackRequest = this.generateACKnfo(notificationBundle);
            if (callback != null) {
                callback.setCallbackOperation(4);
            }
            if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
                new ToucanPostWorker(this.context, this.apiToken, ackRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.ACK, API_ENDPOINT_ACK_READ, API_OPERATION_ACK_READ, callback).start();
            } else {
                this.cacheOperationRequest(new ToucanPostWorker(this.context, this.apiToken, ackRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.ACK, API_ENDPOINT_ACK_READ, API_OPERATION_ACK_READ, callback), true);
            }
        } else {
            Log.i((String)LOG_TAG, (String)(API_OPERATION_ACK_READ.toUpperCase() + " Error. Notification token not stablished. Please, execute 'deviceRegistration()' first."));
        }
    }

    public void doAddTags(List<String> tags, ResponseCallback callback) {
        AppDevTagsOperationRequest tagAddRequest = new AppDevTagsOperationRequest();
        tagAddRequest.setAppKey(ToucanClient.toucanClient.appPublicKey);
        tagAddRequest.setDevId(ToucanClient.toucanClient.deviceUniqueId);
        tagAddRequest.setTags(tags);
        String appHashSignature = ToucanClient.generateSHA1(this.appPublicKey + this.apiToken);
        tagAddRequest.setAppHashSignature(appHashSignature);
        String hashSignature = tagAddRequest.getSecurityHash(this.appPublicKey);
        tagAddRequest.setHashSignature(hashSignature);
        if (callback != null) {
            callback.setCallbackOperation(2);
        }
        if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
            new ToucanPostWorker(this.context, this.apiToken, tagAddRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.TAGS, API_ENDPOINT_ADD_TAGS, API_OPERATION_ADD_TAGS, callback).start();
        } else {
            this.cacheOperationRequest(new ToucanPostWorker(this.context, this.apiToken, tagAddRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.TAGS, API_ENDPOINT_ADD_TAGS, API_OPERATION_ADD_TAGS, callback), true);
        }
    }

    public void doResetTags(List<String> tags, ResponseCallback callback) {
        AppDevTagsOperationRequest tagAddRequest = new AppDevTagsOperationRequest();
        tagAddRequest.setAppKey(ToucanClient.toucanClient.appPublicKey);
        tagAddRequest.setDevId(ToucanClient.toucanClient.deviceUniqueId);
        tagAddRequest.setTags(tags);
        String appHashSignature = ToucanClient.generateSHA1(this.appPublicKey + this.apiToken);
        tagAddRequest.setAppHashSignature(appHashSignature);
        String hashSignature = tagAddRequest.getSecurityHash(this.appPublicKey);
        tagAddRequest.setHashSignature(hashSignature);
        if (callback != null) {
            callback.setCallbackOperation(4);
        }
        if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
            new ToucanPostWorker(this.context, this.apiToken, tagAddRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.TAGS, API_ENDPOINT_RESET_TAGS, API_OPERATION_RESET_TAGS, callback).start();
        } else {
            this.cacheOperationRequest(new ToucanPostWorker(this.context, this.apiToken, tagAddRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.TAGS, API_ENDPOINT_RESET_TAGS, API_OPERATION_RESET_TAGS, callback), true);
        }
    }

    public void doRemoveTags(List<String> tags, ResponseCallback callback) {
        AppDevTagsOperationRequest tagAddRequest = new AppDevTagsOperationRequest();
        tagAddRequest.setAppKey(ToucanClient.toucanClient.appPublicKey);
        tagAddRequest.setDevId(ToucanClient.toucanClient.deviceUniqueId);
        tagAddRequest.setTags(tags);
        String appHashSignature = ToucanClient.generateSHA1(this.appPublicKey + this.apiToken);
        tagAddRequest.setAppHashSignature(appHashSignature);
        String hashSignature = tagAddRequest.getSecurityHash(this.appPublicKey);
        tagAddRequest.setHashSignature(hashSignature);
        if (callback != null) {
            callback.setCallbackOperation(1);
        }
        if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
            new ToucanPostWorker(this.context, this.apiToken, tagAddRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.TAGS, API_ENDPOINT_REMOVE_TAGS, API_OPERATION_REMOVE_TAGS, callback).start();
        } else {
            this.cacheOperationRequest(new ToucanPostWorker(this.context, this.apiToken, tagAddRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.TAGS, API_ENDPOINT_REMOVE_TAGS, API_OPERATION_REMOVE_TAGS, callback), true);
        }
    }

    public void doListTags(ResponseCallback callback) {
        try {
            String appHashSignature = ToucanClient.generateSHA1(this.appPublicKey + this.apiToken);
            String urlParams = "dUId=" + ToucanClient.toucanClient.deviceUniqueId + "&appPubKey=" + this.appPublicKey + "&appHashSignature=" + appHashSignature;
            String encodedUrlParams = new String(Base64.encode((byte[])urlParams.getBytes(), (int)0), "UTF-8");
            String urlEncodedUrlParams = URLEncoder.encode(encodedUrlParams, "UTF-8");
            String finalUrl = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?dtl=" + urlEncodedUrlParams;
            if (callback != null) {
                callback.setCallbackOperation(1);
            }
            if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
                new ToucanGetWorker(this.context, this.apiToken, finalUrl, API_OPERATION_LIST_TAGS, callback).start();
            } else {
                this.cacheOperationRequest(new ToucanGetWorker(this.context, this.apiToken, finalUrl, API_OPERATION_LIST_TAGS, callback), true);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Error doing operation " + API_OPERATION_LIST_TAGS.toUpperCase() + " to Toucan API (" + e.getMessage() + ")"), (Throwable)e);
        }
    }

    public void doDeviceUnregister(ResponseCallback callback) {
        try {
            String appHashSignature = ToucanClient.generateSHA1(this.appPublicKey + this.apiToken);
            String urlParams = "dUId=" + ToucanClient.toucanClient.deviceUniqueId + "&appPubKey=" + this.appPublicKey + "&appHashSignature=" + appHashSignature;
            String encodedUrlParams = new String(Base64.encode((byte[])urlParams.getBytes(), (int)0), "UTF-8");
            String urlEncodedUrlParams = URLEncoder.encode(encodedUrlParams, "UTF-8");
            String finalUrl = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?du=" + urlEncodedUrlParams;
            if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
                new ToucanGetWorker(this.context, this.apiToken, finalUrl, API_OPERATION_DEVICE_UNREGISTRATION, callback).start();
            } else {
                this.cacheOperationRequest(new ToucanGetWorker(this.context, this.apiToken, finalUrl, API_OPERATION_DEVICE_UNREGISTRATION, callback), true);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Error doing operation " + API_OPERATION_DEVICE_UNREGISTRATION.toUpperCase() + " to Toucan API (" + e.getMessage() + ")"), (Throwable)e);
        }
    }

    public void doEnableRegisteredDevice(ResponseCallback callback) {
        try {
            String appHashSignature = ToucanClient.generateSHA1(this.appPublicKey + this.apiToken);
            String urlParams = "dUId=" + ToucanClient.toucanClient.deviceUniqueId + "&appPubKey=" + this.appPublicKey + "&appHashSignature=" + appHashSignature;
            String encodedUrlParams = new String(Base64.encode((byte[])urlParams.getBytes(), (int)0), "UTF-8");
            String urlEncodedUrlParams = URLEncoder.encode(encodedUrlParams, "UTF-8");
            String finalUrl = "http://clientes.tatamia.com/PushNOTApi/NOTPushApi?de=" + urlEncodedUrlParams;
            if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
                new ToucanGetWorker(this.context, this.apiToken, finalUrl, API_OPERATION_DEVICE_ENABLE, callback).start();
            } else {
                this.cacheOperationRequest(new ToucanGetWorker(this.context, this.apiToken, finalUrl, API_OPERATION_DEVICE_ENABLE, callback), true);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Error doing operation " + API_OPERATION_DEVICE_ENABLE.toUpperCase() + " to Toucan API (" + e.getMessage() + ")"), (Throwable)e);
        }
    }

    private boolean isNotificationTokenPresent() {
        if (ToolBox.prefs_existsPref((Context)ToucanClient.toucanClient.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_NOT_TOKEN).booleanValue()) {
            ToucanClient.toucanClient.deviceNotificationToken = (String)ToolBox.prefs_readPreference((Context)ToucanClient.toucanClient.context, (String)PREF_NAME, (String)PREF_KEY_DEVICE_NOT_TOKEN, String.class);
        }
        return ToucanClient.toucanClient.deviceNotificationToken != null && ToucanClient.toucanClient.deviceNotificationToken.length() > 0;
    }

    private ACKRequest generateACKnfo(Bundle notificationBundle) {
        ACKRequest ackRequest = new ACKRequest();
        ackRequest.setAppKey(ToucanClient.toucanClient.appPublicKey);
        ackRequest.setnId(notificationBundle.getString(NOTIFICATION_MESSAGE_ID));
        ackRequest.setnRef(notificationBundle.getString(NOTIFICATION_MESSAGE_REF));
        ackRequest.setToken(ToucanClient.toucanClient.deviceNotificationToken);
        String appHashSignature = ToucanClient.generateSHA1(this.appPublicKey + this.apiToken);
        ackRequest.setAppHashSignature(appHashSignature);
        return ackRequest;
    }

    private DeviceRegistrationRequest generateDeviceRegistrationInfo(String notificationToken) {
        DeviceRegistrationBean devRegBean = new DeviceRegistrationBean();
        devRegBean.setDevId(this.deviceUniqueId);
        devRegBean.setAppVersion(ToolBox.application_getVersionCode((Context)this.context));
        devRegBean.setDevResType(ToolBox.device_getResolutionType((Context)this.context).name());
        devRegBean.setDevLocale(ToolBox.device_getLanguage());
        devRegBean.setDevOs(this.OSInfo);
        devRegBean.setDevExtra(this.DEVInfo);
        devRegBean.setNotToken(notificationToken);
        DeviceRegistrationRequest devRegRequest = new DeviceRegistrationRequest();
        devRegRequest.setAppKey(this.appPublicKey);
        devRegRequest.setData(devRegBean);
        String appHashSignature = ToucanClient.generateSHA1(this.appPublicKey + this.apiToken);
        devRegRequest.setAppHashSignature(appHashSignature);
        String hashSignature = devRegBean.getSecurityHash(this.appPublicKey);
        devRegRequest.setHashSignature(hashSignature);
        return devRegRequest;
    }

    private void launchDeviceRegistrationRequest(DeviceRegistrationRequest devRegRequest, ResponseCallback callback) {
        if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
            new ToucanPostWorker(this.context, this.apiToken, devRegRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.REGISTRATION, API_ENDPOINT_REGISTRATION, API_OPERATION_DEVICE_REGISTRATION, callback).start();
        } else {
            this.cacheOperationRequest(new ToucanPostWorker(this.context, this.apiToken, devRegRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.REGISTRATION, API_ENDPOINT_REGISTRATION, API_OPERATION_DEVICE_REGISTRATION, callback), true);
        }
    }

    private void launchInformReferralRequest(DeviceRegistrationRequest devRegRequest, ResponseCallback callback) {
        if (ToolBox.net_isNetworkAvailable((Context)this.context)) {
            new ToucanPostWorker(this.context, this.apiToken, devRegRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.REGISTRATION, API_ENDPOINT_REGISTRATION, API_OPERATION_INFORM_REFERRAL, callback).start();
        } else {
            this.cacheOperationRequest(new ToucanPostWorker(this.context, this.apiToken, devRegRequest, ToucanWorker.TOUCAN_WORKER_POST_DATA_TYPE.REGISTRATION, API_ENDPOINT_REGISTRATION, API_OPERATION_INFORM_REFERRAL, callback), true);
        }
    }

    private static String generateSHA1(String data) {
        try {
            return SHA1Encoding.getSHA1((String)data);
        }
        catch (SHA1EncodingException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage());
            return null;
        }
    }

    private synchronized void cacheOperationRequest(ToucanWorker operation, boolean startPendingOperationsService) {
        try {
            String jsonData = GsonProcessor.getInstance().getGsonWithExposedFilter().toJson((Object)operation);
            String fileName = operation.getJobId();
            ToolBox.storage_storeDataInInternalStorage((Context)this.context, (String)fileName, (byte[])jsonData.getBytes());
            Log.i((String)LOG_TAG, (String)("Saved pending operation request to disk (" + operation.getOperationName() + "/" + operation.getJobId() + ")"));
            if (startPendingOperationsService) {
                Intent pendingOperationsServiceIntent = new Intent(this.context, PendingOperationsDeliveryService.class);
                this.context.startService(pendingOperationsServiceIntent);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Error cacheOperationRequest() - Operation request could not be cached [" + e.getMessage() + "]."), (Throwable)e);
        }
    }

    public static enum TOUCAN_WORKER_TYPE {
        GET,
        POST;

    }
}

