package com.colectivosvip.optimil.sqllite;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.db.DBSQLite;
import com.colectivosvip.optimil.ApplicationBase;
import com.colectivosvip.optimil.Constants;

/**
 * SQLite DB creation and update class.
 * 
 * @author JavocSoft, 2015
 * @version 1.0<br>
 * $Rev: 816 $<br>
 * $LastChangedDate: 2015-11-30 15:03:36 +0100 (lun, 30 nov 2015) $<br>
 * $LastChangedBy: admin $
 *
 */
public class DatabaseSQLite extends DBSQLite {

	public DatabaseSQLite(Context context, String dbName, int dbVersion) {
		super(context, dbName, dbVersion);	
	}

	
	@Override
	public void doOnCreate(SQLiteDatabase db) {
		//TABLES
	    db.execSQL("CREATE TABLE location (id INTEGER PRIMARY KEY, lat DOUBLE NOT NULL, lng DOUBLE NOT NULL, city VARCHAR(255), country VARCHAR(255), countryCode VARCHAR(255), postalCode VARCHAR(255), ts INTEGER NOT NULL, tsString VARCHAR(255) NOT NULL, notRemind INTEGER NOT NULL)");
	    
	    //INDEXES
	    db.execSQL("CREATE INDEX location_id_idx ON location (id)");		
	}


	@Override
	public void doOnUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		if(ApplicationBase.debugMode)
			Log.d(Constants.TAG, "Called SQLite DB onUpgrade. Current DB version: " + oldVersion + ", new version: " + newVersion);
		
		if(oldVersion < newVersion) {
			//Do changes
		}
	}
	

}
