package com.colectivosvip.optimil.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import es.javocsoft.android.lib.toolbox.ToolBox;
import com.colectivosvip.optimil.Constants;

/**
 * Detects when the GPS or Network location providers
 * status changes.
 * <br><br>
 * <b>Do not use this receiver</b>. Use {@link com.colectivosvip.optimil.receiver.LocationChangedReceiver}
 * with {@link es.javocsoft.android.lib.toolbox.location.service.LocationService} JavocSoft ToolBox
 * service (see the <a href="https://github.com/javocsoft/javocsoft-toolbox/wiki">Wiki</a>).
 * 
 * @author JavocSoft 2013
 * @version 2.0<br>
 * $Rev: 807 $<br>
 * $LastChangedDate: 2015-11-20 13:19:11 +0100 (vie, 20 nov 2015) $<br>
 * $LastChangedBy: admin $
 *
 */
@Deprecated
public class LocationProvidersStatusReceiver extends BroadcastReceiver {

	@Override
	public void onReceive(Context context, Intent intent) {

		final LocationManager manager = (LocationManager) context
				.getSystemService(Context.LOCATION_SERVICE);
		
		if(manager!=null) {
			//GPS STATUS		
			boolean isGPSProviderEnabled = manager.isProviderEnabled(LocationManager.GPS_PROVIDER);
			if(isGPSProviderEnabled!=(Boolean)ToolBox.prefs_readPreference(context, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_GPS_STATUS, Boolean.class)) {
				ToolBox.prefs_savePreference(context, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_GPS_STATUS, Boolean.class, isGPSProviderEnabled);			
			}		
			
			//NETWORK STATUS
			boolean isNetworkProviderEnabled = manager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
			if(isNetworkProviderEnabled!=(Boolean)ToolBox.prefs_readPreference(context, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_NETWORK_STATUS, Boolean.class)) {
				ToolBox.prefs_savePreference(context, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_NETWORK_STATUS, Boolean.class, isNetworkProviderEnabled);
			}
		} 
	}	
}
