package com.colectivosvip.optimil.prompt;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import com.colectivosvip.optimil.ApplicationBase;
import com.colectivosvip.optimil.Constants;
import com.colectivosvip.optimil.R;
import com.colectivosvip.optimil.receiver.LocationChangedReceiver;
import com.colectivosvip.optimil.sqllite.SQLite;
import com.colectivosvip.optimil.sqllite.tables.DBLocation;

/**
 * This activity is used to show the configuration prompt for the 
 * offers location alerts service.
 * <br><br>
 * Notes:<br>
 * No layout is used in the activity because we want a transparent 
 * background. Also we use the theme "Theme.AppCompat.Light.Dialog" 
 * in the Androidmanifest.xml file.
 * 
 * @author JavocSoft 2015
 * @version 1.0<br>
 * $Rev: 873 $<br>
 * $LastChangedDate: 2016-12-15 18:49:44 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
public class PromptLocattionAlertsConfigure extends FragmentActivity {

	private Tracker tracker;
	
	@Override
    protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		displayAlert(getIntent());
		
		if(ApplicationBase.enableAnalytics) {
        	//See: 	https://developers.google.com/analytics/devguides/collection/android/v4/
        	//		https://developer.android.com/reference/com/google/android/gms/analytics/GoogleAnalytics.html
        	//		https://developers.google.com/analytics/devguides/collection/android/v4/advanced
			tracker = ((ApplicationBase)getApplication()).getTracker(ApplicationBase.TrackerName.APP_TRACKER);			
        }
	}
	
	private void displayAlert(final Intent intent) {
		
		//We show a custom alert dialog with a custom layout
		ToolBox.dialog_showCustomLayoutActionsDialog(this, 
				getResources().getString(R.string.offers_location_configure_prompt_title), 
				R.layout.configure_proximity_alerts, 
				R.id.p_alerts_conf_button_1, new Runnable() {					
					@Override
					public void run() {
						//Open the smartcouponing section
						if(ApplicationBase.enableAnalytics) {
				        	tracker.send(new HitBuilders.EventBuilder()
					         					.setCategory("ProximityAlert")
					         					.setAction("OpenAppFromProximityAlert")					         					
					         					.build());
				        }
						
						Bundle extras = new Bundle();
						extras.putInt(Constants.ACTION_OPEN_SMARTCOUPONING, 1);
						Intent intent = ToolBox.intent_openApp(PromptLocattionAlertsConfigure.this.getApplicationContext(), 
								ToolBox.application_packageName(PromptLocattionAlertsConfigure.this), 
								extras);
						//intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
						//intent.addFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
						startActivity(intent);
						finish(); //In our case, the user pressed "Understood" button
					}
				}, 
				R.id.p_alerts_conf_button_2, new Runnable() {					
					@Override
					public void run() {
						if(ApplicationBase.debugMode)
							Log.d(Constants.TAG, "Do not remind selected");
						
						if(ApplicationBase.enableAnalytics) {
				        	tracker.send(new HitBuilders.EventBuilder()
					         					.setCategory("ProximityAlert")
					         					.setAction("NotRemindLocation")					         					
					         					.build());
				        }
						
						long userDBLocationId = intent.getLongExtra(LocationChangedReceiver.LOCATION_NOTIFICATION_KEY_LOCATIONID,0);
						DBLocation dbLocation = SQLite.getInstance(PromptLocattionAlertsConfigure.this).getDBHelper().getLocation(userDBLocationId);
						if(dbLocation!=null) {
							if(SQLite.getInstance(PromptLocattionAlertsConfigure.this).getDBHelper().updateLocationRemindOption(dbLocation, 1)){
								if(ApplicationBase.debugMode)
									Log.d(Constants.TAG, "DB Location remind Option Updated!");
							}
						}
						
						finish();
					}
				}, 
				R.id.p_alerts_conf_button_3, new Runnable() {					
					@Override
					public void run() {
						//User selected disable alert system
						
						if(ApplicationBase.enableAnalytics) {
				        	tracker.send(new HitBuilders.EventBuilder()
					         					.setCategory("ProximityAlert")
					         					.setAction("DisableService")					         					
					         					.build());
				        }
						
						doDisableLocationOfferAlerts();						
						finish();
					}
				}, 
				true);
		
		/*ToolBox.dialog_showCustomActionsDialog(this, 
				getResources().getString(R.string.offers_location_configure_prompt_title), 
				getResources().getString(R.string.offers_location_configure_prompt_text), 
				getResources().getString(R.string.offers_location_configure_prompt_cancel),
				new Runnable() {								
					@Override
					public void run() {									
						if(ApplicationBase.debugMode)
							Log.d(Constants.TAG, "Cancel");
						finish();
					}
				},
				getResources().getString(R.string.offers_location_configure_prompt_disable),
				new Runnable() {								
					@Override
					public void run() {
						if(ApplicationBase.debugMode)
							Log.d(Constants.TAG, "Disable");
						doDisableLocationOfferAlerts();						
						finish();
					}
				},	
				null, null);*/
    }

	private void doDisableLocationOfferAlerts() {
		((ApplicationBase)getApplication()).stopLocationService();
		//We save the selected option
		ToolBox.prefs_savePreference(this, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_ALERTS_DISABLED, Boolean.class, true);
	}
	
}
