package com.colectivosvip.optimil.external;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.net.HttpOperations;
import com.colectivosvip.optimil.ApplicationBase;
import com.colectivosvip.optimil.Constants;
import com.colectivosvip.optimil.R;
import com.colectivosvip.optimil.receiver.proximity.LocationProximityChangedReceiver;

/**
 * Class that holds operations related with an external remote service that 
 * we use when using proximity alerts.
 * 
 * @author JavocSoft 2016<br>
 * $Rev: 872 $<br>
 * $LastChangedDate: 2016-12-15 18:49:20 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
public class ProximityExternalApiTask {

	public static final String ACTION_OPEN_SMARTCOUPONING = "OPEN_SMARTCOUPONING";
	private static Boolean calling_API_proximityItemsCheck = false;
	private static Boolean calling_API_proximityAlertLog = false;
    private static final String PROXIMITY_API_JSON_RESPONSE_TOTAl_ITEMS_KEY = "\"results_current_count\":";
    
    public static final String PREF_FILE_NAME = "prefs_proximity_api";
    public static final String PREF_PARAM_API_TOKEN = "LOCATION_PROXIMITY_PARAM_API_TOKEN";
    public static final String PREF_PARAM_MIN_ITEMS = "LOCATION_PROXIMITY_PARAM_MIN_ITEMS";
    public static final String PREF_PARAM_RADIUS = "LOCATION_PROXIMITY_PARAM_RADIUS";
    
    
    private static Context appContext;
    
	
	private ProximityExternalApiTask() {}

	
	/**
	 * Request an external API to get proximity items.
	 * 
	 * @param context
	 * @param lat
	 * @param lng
	 */
	public static void queryForProximityOffers(Context context, double lat, double lng, Long dbLocationId, Bundle extras) {
		synchronized(calling_API_proximityItemsCheck) {
        	if(!calling_API_proximityItemsCheck) {
        		appContext = context;
        		launchGetProximityItems(appContext, lat, lng, dbLocationId, extras);        		
        	}
    	}
	}
	
	
	
	
	//AUXILIAR FUNCTIONS
	
	private static void launchGetProximityItems(Context context, double lat, double lng, Long dbLocationId, Bundle extras) {
		//If this TOKEN could change, we should get informed about it. For example, 
		//through a call within the loaded web to the method:
		//	Android.androidInformProximityAPIKey
		//
		//The code of this call is in:
		//
		//	com.colectivosvip.optimil.javascript.WebAppJSInterface#androidInformProximityAPIKey(apiKey)
		//We get the external API token if there is one saved.
    	if(ToolBox.prefs_existsPref(context, PREF_FILE_NAME, PREF_PARAM_API_TOKEN)) {
    		ApplicationBase.EXTERNAL_PROXIMITY_API_TOKEN = ((String)ToolBox.prefs_readPreference(context, PREF_FILE_NAME, PREF_PARAM_API_TOKEN, String.class));
		}
    	//We try to get the min offers and radius given in the configuration.
    	if(ToolBox.prefs_existsPref(context, PREF_FILE_NAME, PREF_PARAM_MIN_ITEMS)) {
    		ApplicationBase.API_PROXIMITY_MIN_ITEMS_TO_NOTIFY = ((Integer)ToolBox.prefs_readPreference(context, PREF_FILE_NAME, PREF_PARAM_MIN_ITEMS, Integer.class)).intValue();
		}
    	if(ToolBox.prefs_existsPref(context, PREF_FILE_NAME, PREF_PARAM_RADIUS)) {
    		ApplicationBase.API_PROXIMITY_RADIUS = ((Integer)ToolBox.prefs_readPreference(context, PREF_FILE_NAME, PREF_PARAM_RADIUS, Integer.class)).intValue();
		}
    	
    	if(ApplicationBase.EXTERNAL_PROXIMITY_API_TOKEN!=null && ApplicationBase.EXTERNAL_PROXIMITY_API_TOKEN.length()>0 &&
    	   ApplicationBase.API_PROXIMITY_MIN_ITEMS_TO_NOTIFY>0 &&
    	   ApplicationBase.API_PROXIMITY_RADIUS > Constants.PROXIMITY_MIN_RADIUS){
    		
    		String url = Constants.PROXIMITY_API_GET_LOCATION_ITEMS
        			.replaceAll("<api_token>", ApplicationBase.EXTERNAL_PROXIMITY_API_TOKEN)
        			.replaceAll("<location>", (lat+","+lng))
        			.replaceAll("<radius>", String.valueOf(ApplicationBase.API_PROXIMITY_RADIUS));
        	
        	new CheckLocationProximityOffersTask(url, ApplicationBase.API_PROXIMITY_MIN_ITEMS_TO_NOTIFY, context, dbLocationId, lat, lng, extras).execute();
    	}else{
    		if(ApplicationBase.debugMode)
	    		Log.d(Constants.TAG, "PROXIMITY_API_CHECK_ITEMS >>> Check not done because no API token or no valid radius or items.");
    	}
    }
		
	private static void notifyToServerLocAlert(Context context, int numOffers, double lat, double lng) {
		if(ApplicationBase.debugMode)
    		Log.i(Constants.TAG, "API_LOG_NOTIFIED_PROXIMITY_ALERT >>> Trying to log the proximity alert...");
		
		if(!calling_API_proximityAlertLog) {
			if(ApplicationBase.debugMode)
	    		Log.i(Constants.TAG, "API_LOG_NOTIFIED_PROXIMITY_ALERT >>> Logging the proximity alert...");
			
        	appContext = context;
        	launchLogInRemoteLocAlert(context, numOffers, lat, lng);
        }else{
        	if(ApplicationBase.debugMode)
	    		Log.i(Constants.TAG, "API_LOG_NOTIFIED_PROXIMITY_ALERT >>> Not logging the proximity alert.");
        }
	}
	
	private static void launchLogInRemoteLocAlert(Context context, int numOffers, double lat, double lng) {
		//http://mgapi.ttma.tv/v1/app/<app_name>/<app_platform>/log/<u_token>/loc_alert/<a_time>/proximity/c3df27b42f84086c38b9ec8d8948c5a8e11edac4";
		if(ApplicationBase.getUserToken(context)!=null && ApplicationBase.getUserToken(context).length()>0) {
			
			String url = Constants.MGAPI_LOG_URL
	    			.replaceAll("<n_offers>", (""+ numOffers))
	    			.replaceAll("<app_name>", ApplicationBase.getApplicationName(context))
	    			.replaceAll("<app_platform>", ApplicationBase.getApplicationPlatform())
	    			.replaceAll("<u_token>", URLEncoder.encode(ApplicationBase.getUserToken(context)))
	    			.replaceAll("<a_time>", String.valueOf(new Date().getTime()))
	    			.replaceAll("<app_version>", String.valueOf(ToolBox.application_getVersionCode(context)))
	    			.replaceAll("<a_lat>", URLEncoder.encode(String.valueOf(lat)))
	    			.replaceAll("<a_lng>", URLEncoder.encode(String.valueOf(lng)));
	    	
	    	new LogInRemoteLocAlertTask(url, context).execute();
		}else{
			if(ApplicationBase.debugMode)
	    		Log.w(Constants.TAG, "API_LOG_NOTIFIED_PROXIMITY_ALERT >>> Could not log the proximity alert. No userToken.");
		}
    }
	
		
	
	
	//AUXILIAR CLASSES
	
	
	/**
	 * Checks if we have items near to our position.
	 */
	static class CheckLocationProximityOffersTask extends AsyncTask<Void, Void, Boolean> {
	    private String url;
	    private int minItems;
	    private Context context;
	    private double lat;
	    private double lng;
	    Long dbLocationId;
	    Bundle extras;
	    
	    private int results_total_count = 0;
	    
	    public CheckLocationProximityOffersTask(String url, int minItems, Context context, Long dbLocationId, double lat, double lng, Bundle extras) {
	        this.url = url;
	        this.minItems = minItems;
	        this.context = context;
	        this.dbLocationId = dbLocationId;
	        this.lat = lat;
	        this.lng = lng;
	        this.extras = extras;
	    }

	    protected void onPreExecute() {
	    	if(ApplicationBase.debugMode)
	    		Log.i(Constants.TAG, "PROXIMITY_API_ITEMS_CHECK >>> Looking for proximity items...");
	    	calling_API_proximityItemsCheck = true;
    	} 
	    
	    protected Boolean doInBackground(Void... params) {
	    	if(ToolBox.net_isNetworkAvailable(context)){
	    		return doWork();
	    	}else{
	    		return false;
	    	}
	    }

	    protected void onPostExecute(Boolean result) {
	    	if(result){	    
	    		
	    		if(ApplicationBase.debugMode) {
	    			//ApplicationBase.appIsForeground = false; //Just for testing
	    			Log.d(Constants.TAG, "PROXIMITY_API_CHECK_ITEMS >>> Debug Mode: Enabled manually the proximity notifications when app is in foreground!.");
	    		}
	    		
	    		//Min number of offers and app is not in foreground
	    		if(results_total_count >= minItems && !ApplicationBase.appIsForeground){
	    			//Show notification
	    			if(ApplicationBase.debugMode)
	    				Log.i(Constants.TAG, "PROXIMITY_API_CHECK_ITEMS >>> There are a lot of offers. Create proximity notification!");
	    			
	    			final Integer notificationId;
	        		final List<android.support.v4.app.NotificationCompat.Action> actions;
	        		//Prepare actions of the notification
	    		    notificationId = 88; //We always use the same so last one is updated.
	    		    actions = prepareNotificationActions(context, notificationId, dbLocationId);
	        		//When having this we will open the app and go to SmartCouponing section
	    		    extras.putInt(ACTION_OPEN_SMARTCOUPONING, 1);
	    		    
	    	    	//Create the notification
	    		    Thread t = new Thread(new Runnable() {
						
						@Override
						public void run() {
							Log.d(Constants.TAG, "LocationChangeWakefulService: Creating notification!");
							
							ApplicationBase.generateSystemNotification(context, 
			    	    			ToolBox.NOTIFICATION_STYLE.NORMAL_STYLE, ToolBox.NOTIFICATION_PRIORITY.DEFAULT,
			    	    			true, null,
			    	    			null,
			    	    			ToolBox.application_nameInfo(appContext, appContext.getPackageName()), 
			    	    			context.getResources().getString(R.string.offers_location_alert),
			    	    			null,
			    	    			null, 
			    	    			null, 
			    	    			null, null,
			    	    			null, 
			    	    			null, null,
			    	    			String.valueOf(R.drawable.ic_icon_proximity_color), null, true, extras, notificationId, actions);
						}
					});
	    		    t.start();
	    		    
	    	    	//Notify to server the location alert
	    	    	notifyToServerLocAlert(context, results_total_count, lat, lng);
	    		} 		
	    	}
	    	
	    	calling_API_proximityItemsCheck = false;
	    }
	    
	    
		//AUXILIAR
	    
	    /**
	     * Prepare the notification actions.
	     * 
	     * @param context
	     * @param notificationId
	     * @return
	     */
	    private List<android.support.v4.app.NotificationCompat.Action> prepareNotificationActions (
	    		final Context context,
	    		Integer notificationId,
	    		Long dbLocationId) {
	    	
	    	//
	    	//Actions:
	    	//
	    	//Do not remind				
			/*Bundle extras = new Bundle();
			extras.putInt(LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_ACTION, LocationProximityChangedReceiver.LOCATION_NOTIFICATION_ACTION_NOT_REMIND);
			if(dbLocationId!=null)
				extras.putLong(LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_LOCATIONID, dbLocationId);
			android.support.v4.app.NotificationCompat.Action actionDoNotRemind = 
				ToolBox.notification_createActionButton(context, 
						ToolBox.NOTIFICATION_ACTION_TARGET_TYPE.RECEIVER,
						LocationProximityChangedReceiver.ACTION_LOCATION_NOTIFICATION, 
						LocationProximityChangedReceiver.class, 
						LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_NOTID, notificationId, 
						android.R.drawable.ic_lock_silent_mode, context.getResources().getString(R.string.offers_location_alert_not_remind_more), extras);
			*/		
	    	//Configure		
			extras = new Bundle();
			extras.putInt(LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_ACTION, LocationProximityChangedReceiver.LOCATION_NOTIFICATION_ACTION_CONFIGURE);
			if(dbLocationId!=null)
				extras.putLong(LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_LOCATIONID, dbLocationId);
			android.support.v4.app.NotificationCompat.Action actionConfigurar = 
				ToolBox.notification_createActionButton(context,
						ToolBox.NOTIFICATION_ACTION_TARGET_TYPE.RECEIVER,
						LocationProximityChangedReceiver.ACTION_LOCATION_NOTIFICATION, 
						LocationProximityChangedReceiver.class, 
						LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_NOTID, notificationId, 
						android.R.drawable.ic_menu_preferences, context.getResources().getString(R.string.offers_location_alert_configure), extras);
			
			//Close
			/*extras = new Bundle();
			extras.putInt(LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_ACTION, LocationProximityChangedReceiver.LOCATION_NOTIFICATION_ACTION_CLOSE);
			if(dbLocationId!=null)
				extras.putLong(LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_LOCATIONID, dbLocationId);
			android.support.v4.app.NotificationCompat.Action actionClose = 
				ToolBox.notification_createActionButton(context,
						ToolBox.NOTIFICATION_ACTION_TARGET_TYPE.RECEIVER,
						LocationProximityChangedReceiver.ACTION_LOCATION_NOTIFICATION, 
						LocationProximityChangedReceiver.class, 
						LocationProximityChangedReceiver.LOCATION_NOTIFICATION_KEY_NOTID, notificationId, 
						android.R.drawable.ic_notification_clear_all, "Close", extras);
			*/
			//
			//Add the actions to a list that is passed to the notification
	    	List<android.support.v4.app.NotificationCompat.Action> actions = 
	    			new ArrayList<android.support.v4.app.NotificationCompat.Action>();
	    	//actions.add(actionDoNotRemind);
	    	//actions.add(actionClose);
	    	actions.add(actionConfigurar);    	
	    	
	    	return actions;
	    }
	    
		    
		private boolean doWork(){
		   	boolean res = false;
		   		
		   	try {
		   		//Validate JSON: http://jsonlint.com/
				String resJson = HttpOperations.doGet(url, null, true);
				if(resJson!=null && resJson.length()>0){
					//Look in the JSOn for the string "results_total_count" and extract its value.
					int totalOffersPos = resJson.indexOf(PROXIMITY_API_JSON_RESPONSE_TOTAl_ITEMS_KEY); 
					if(totalOffersPos!=-1){
						int totalOffersPosEnd = resJson.indexOf(",", totalOffersPos);
						String totalOffers = resJson.substring(
								(totalOffersPos+PROXIMITY_API_JSON_RESPONSE_TOTAl_ITEMS_KEY.length()), totalOffersPosEnd).trim() ;
						if(totalOffers!=null && totalOffers.length()>0){
							results_total_count = Integer.parseInt(totalOffers);
							if(ApplicationBase.debugMode)
								Log.i(Constants.TAG, "PROXIMITY_API_CHECK_ITEMS >>> Total items: " + results_total_count);
							
							res = true;
						}
					}else{
						Log.w(Constants.TAG, "PROXIMITY_API_CHECK_ITEMS >>> There is no property \"" + PROXIMITY_API_JSON_RESPONSE_TOTAl_ITEMS_KEY + "\" in the received JSON from proximity API with token: " + ApplicationBase.EXTERNAL_PROXIMITY_API_TOKEN  + ".");
					}
				}else{
					Log.w(Constants.TAG, "PROXIMITY_API_CHECK_ITEMS >>> No JSON received from proximity API with token: " + ApplicationBase.EXTERNAL_PROXIMITY_API_TOKEN  + ".");
				}									
			} catch (Exception e) {
				Log.e(Constants.TAG, "PROXIMITY_API_CHECK_ITEMS >>> Error doing call to Proximity API [" + e.getMessage() + "]", e);
			}
		    return res;
		}
	}
	
	
	/**
	 * Logs the alert in the Mobile Application general API.
	 */
	static class LogInRemoteLocAlertTask extends AsyncTask<Void, Void, Boolean> {
	    private String url;
	    private Context context;
	    
	    public LogInRemoteLocAlertTask(String url, Context context) {
	        this.url = url;
	        this.context = context;	        
	    }

	    protected void onPreExecute() {
	    	if(ApplicationBase.debugMode)
	    		Log.i(Constants.TAG, "API_LOG_NOTIFIED_PROXIMITY_ALERT >>> starting to log...");
	    	calling_API_proximityAlertLog = true;
    	} 
	    
	    protected Boolean doInBackground(Void... params) {
	    	if(ToolBox.net_isNetworkAvailable(context)){
	    		return doWork();
	    	}else{
	    		return false;
	    	}
	    }

	    protected void onPostExecute(Boolean result) {	    	
	    	if(result){
	    	 		
	    	}
	    	calling_API_proximityAlertLog = false;
	    }
	    
	    
		//AUXILIAR
	        
		private boolean doWork(){
		   	boolean res = false;
		   		
		   	try {
		   		//Validate JSON: http://jsonlint.com/
				String resJson = HttpOperations.doGet(url, null, true);
				if(ApplicationBase.debugMode)
					Log.d(Constants.TAG, "API_LOG_NOTIFIED_PROXIMITY_ALERT >>> Logged. Received JSON: [" + resJson + "]");
				
				if(resJson!=null && resJson.length()>0 && resJson.contains("\"errorCode\":200")){
					res = true;
				}else{
					Log.w(Constants.TAG, "API_LOG_NOTIFIED_PROXIMITY_ALERT >>> Could not complete the operation (log alert).");
				}									
			} catch (Exception e) {
				Log.e(Constants.TAG, "API_LOG_NOTIFIED_PROXIMITY_ALERT >>> Error doing call to MAPGGAPI [" + e.getMessage() + "]", e);
			}
		    return res;
		}
	}
	
}
