package com.colectivosvip.optimil.barcodescan;

import java.io.IOException;
import java.util.List;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.hardware.Camera;
import android.hardware.Camera.AutoFocusCallback;
import android.hardware.Camera.PreviewCallback;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import es.javocsoft.android.lib.toolbox.ToolBox;
import com.colectivosvip.optimil.Constants;

/**
 * A Camera preview class.
 * 
 * @author JavocSoft 2016<br>
 *         $Rev: 871 $<br>
 *         $LastChangedDate: 2016-12-15 18:49:05 +0100 (jue, 15 dic 2016) $<br>
 *         $LastChangedBy: jgonzalez $
 */
@SuppressWarnings("deprecation")
public class CameraPreview extends SurfaceView implements
		SurfaceHolder.Callback {

	private AutoFocusCallback autoFocusCallback;
	private Camera mCamera;
	private SurfaceHolder mHolder;
	private PreviewCallback previewCallback;

	@SuppressLint("InlinedApi")
	public CameraPreview(Context context, Camera camera,
			PreviewCallback previewCb, AutoFocusCallback autoFocusCb) {
		super(context);
		mCamera = camera;
		previewCallback = previewCb;
		autoFocusCallback = autoFocusCb;

		/*
		 * Set camera to continuous focus if supported, otherwise use software
		 * auto-focus.
		 */
		Camera.Parameters parameters = camera.getParameters();
		List<String> supportedFocusModes = parameters.getSupportedFocusModes();
        if (ToolBox.device_hasAPILevel(ToolBox.ApiLevel.LEVEL_14) &&
            supportedFocusModes.contains(Camera.Parameters.FOCUS_MODE_CONTINUOUS_PICTURE)) {
            parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_CONTINUOUS_PICTURE);
        }
        else if (supportedFocusModes.contains(Camera.Parameters.FOCUS_MODE_CONTINUOUS_VIDEO)) {
            parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_CONTINUOUS_VIDEO);
        }
        else if (supportedFocusModes.contains(Camera.Parameters.FOCUS_MODE_AUTO)) {
            // auto focus on request only
            parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_AUTO);
        }

        //Properly rotate the preview to match the device orientation
        ToolBox.device_cameraAlignRotationWithDeviceOrientation(context, camera);
        
        /** We set the proper orientation given the device orientation */
		if (this.getResources().getConfiguration().orientation != Configuration.ORIENTATION_LANDSCAPE) {
			parameters.set("orientation", "portrait");
			//parameters.setRotation(90);
		} else {
			// This is an undocumented although widely known feature
			parameters.set("orientation", "landscape");
			// For Android 2.2 and above
			//mCamera.setDisplayOrientation(0);
			// Uncomment for Android 2.0 and above
			//parameters.setRotation(0);
		}

		// Install a SurfaceHolder.Callback so we get notified when the
		// underlying surface is created and destroyed.
		mHolder = getHolder();
		mHolder.addCallback(this);
		// deprecated setting, but required on Android versions prior to 3.0
		mHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
	}

	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int width,
			int height) {
		/*
		 * If your preview can change or rotate, take care of those events here.
		 * Make sure to stop the preview before resizing or reformatting it.
		 */
		if (mHolder.getSurface() == null) {
			// preview surface does not exist
			return;
		}

		// stop preview before making changes
		try {
			mCamera.stopPreview();
		} catch (Exception e) {
			// ignore: tried to stop a non-existent preview
		}

		try {
			// Hard code camera surface rotation 90 degs to match Activity view
			// in portrait
			// mCamera.setDisplayOrientation(90);
			mCamera.setPreviewDisplay(mHolder);
			mCamera.setPreviewCallback(previewCallback);
			mCamera.startPreview();
			mCamera.autoFocus(autoFocusCallback);
		} catch (Exception e) {
			Log.d(Constants.TAG, "Error starting camera preview: " + e.getMessage());
		}
	}

	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		// The Surface has been created, now tell the camera where to draw the
		// preview.
		try {
			mCamera.setPreviewDisplay(holder);
		} catch (IOException e) {
			Log.d(Constants.TAG, "Error setting camera preview: " + e.getMessage());
		}
	}

	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
		// Camera preview released in activity.
	}

}