package com.colectivosvip.optimil;

/**
 * 
 * @author JavocSoft, 2014
 * @version 1.0<br>
 * $Rev: 871 $<br>
 * $LastChangedDate: 2016-12-15 18:49:05 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 */
public interface Constants {

    public static final String TAG = "ClubOptimil";

    //When using Toucan server, set these to the correct values.
    public static final String TOUCAN_APP_PUB_KEY = "toucan_app_pub_key";
    public static final String TOUCAN_API_TOKEN = "toucan_srv_api_token";
    
    //Preferences related
    public final String PREF_NAME = "app_prefs_general";
    public final String PREF_KEY__INSTALLREFERRER = "pref_key__installreferrer";
    public final String PREF_KEY__LOGGED = "pref_key__logged";
    public final String PREF_KEY__LOCATION_GPS_STATUS = "pref_key__location_gps_status";
    public final String PREF_KEY__LOCATION_NETWORK_STATUS = "pref_key__location_network_status";
    public final String PREF_KEY__LOCATION_GPS_TRY = "pref_key__location_gps_acquire_tried";
    public final String PREF_KEY__LOCATION_NETWORK_TRY = "pref_key__location_network_acquire_tried";    
    public final String PREF_KEY__LOCATION_ALERTS_DISABLED = "pref_key__location_alerts_location_disabled";
    public final String PREF_KEY__LOCATION_ENABLE_ASK_DIALOG = "pref_key__showAskLocationEnable";
    public final String PREF_KEY__SHOWSCANTIP = "pref_key__showScanTip";
    public final String PREF_KEY__CURRVERSION = "pref_key__currentVersion";
    public final String PREF_KEY__NETWORK_STATUS = "pref_key__network_status";
    public final String PREF_KEY__EXIT_NORMALLY = "pref_key__exited_normally";
    public final String PREF_KEY__PERMISSIONS_DENIED_NOT_ASK = "pref_key__permissions_denied_not_ask_again";
    public final String PREF_KEY__PERMISSIONS_CAMERA_DENIED_NOT_ASK = "pref_key__permissions_camera_denied_not_ask_again";
    public final String PREF_KEY__DISCOUNT_MAP_ACCESSED = "pref_key__discount_map_accessed";
    public final String PREF_KEY__CV_USERID = "pref_key__cv_userid";

    //public final static int ENABLE_GPS_REQUEST = 0x69;  // The GPS enable request code
    public final int MAX_LOCATION_ACQUIRE_WAIT_TIME = 15;
    public final long TIME_BETWEEN_REQUEST = 2000;
    public final int DISTANCE_BETWEEN_REQUEST = 5;
    
    //A TAG to recognize the app by the USER-AGENT.
  	//(this is added to the end of the current user-agent)
    public static final String APP_USER_AGENT_ANDROIDAPP_SUFFIX = "(AndroidApp)";
  	public static final String APP_USER_AGENT_SUFFIX = "ClubOptimilAndroidApp";
    
    public static final long EXIT_BACK_PRESS_TIME_INTERVAL = 2000;
    
    /** Any intent action for AppBroadcastReceiver must start using this prefix. */
    public static final String APP_RECEIVER_ACTION_PREFIX = "com.colectivosvip.optimil.";
    
    public static final String APP_BOOT_SOUND = "boot.mp3";
    
    /** The application declared pages that can be the home page. */
    public final String VV_URL[] = {"https://www.colectivosvip.com/optimil/"};
    public static final String VV_URL_TRACKING = "t_source=androidapp";
    
    /** The page that loads when application starts. */
    public final String VV_URL_HOME = VV_URL[0] + (VV_URL[0].indexOf("?")!=-1?"&":"?") + VV_URL_TRACKING; // Home page
    
    public final String PAGE_404ERROR = "file:///android_asset/404-error.html";

    public final String LOCATION_IS_LAST_KNOWN_KEY = "location_is_last_known";
    
    public final String VV_JS_GPUSHID_INFORM_METHOD = "informDeviceGPushId";
    public final String VV_JS_USERLOCATION_INFORM_METHOD = "informUserLocation";
    public final String VV_JS_USERLOCATION_NOJSON_INFORM_METHOD = "setAndroidAppLocation";
    public final String VV_JS_USERLOCATION_LAST_KNOWN_NOJSON_INFORM_METHOD = "setAndroidAppLastKnownLocation";
    public final String VV_JS_USERLOCATION_CLEARLOCATION_METHOD = "clearLocation";
    public final String VV_JS_USERLOCATION_ENABLED_STATUS_METHOD = "informGPSStatus";
    public final String VV_JS_SHOWMENU_METHOD = "showWebMenu";
    public final String VV_JS_SCANCODERESULT_METHOD = "informScannedCode";
    public final String VV_JS_WEB_GO_BACK_METHOD = "headerBack.goBack";
    public final String VV_JS_WEB_INFORM_VERSION = "setVersion";
    
    /** JavocSoft Mobile General API Endpoint */
    public final String MGAPI_CHECKAPP_URL = "http://mappgapi.javocsoft.es/v1/app/<app_name>/<app_platform>/version/check/c3df27b42f84086c38b9ec8d8948c5a8e11edac4";
    public final String MGAPI_LOG_URL =      "http://mappgapi.javocsoft.es/v1/app/log/<app_name>/<app_platform>/<u_token>/vapp/<app_version>/lat/<a_lat>/lng/<a_lng>/loc_alert/<a_time>/proximity/<n_offers>/c3df27b42f84086c38b9ec8d8948c5a8e11edac4";
    
    /** The service where we look for proximity offers. */
    public static final String PROXIMITY_API_ENDPOINT = "<proximity_api_domain>";
    public static final String PROXIMITY_API_GET_LOCATION_ITEMS = PROXIMITY_API_ENDPOINT + "items/v0/<api_token>?include_tags=false&include_stores=false&page_size=0&location=<location>&radius=<radius>";
    public static final int PROXIMITY_MIN_RADIUS = 100;
    
    /** When a load error happens, Chrome loads the default url for a new session opened by protractor. See http://www.protractortest.org */
    public final static String PROTRACTOR_URL = "data:text/html,chromewebdata";
    
    public static final String ACTION_OPEN_SMARTCOUPONING = "OPEN_SMARTCOUPONING";
    public static final String SMARTCOUPONING_OPEN_URL = null;
    public static final int SMARTCOUPONING_MIN_OFFERS_TO_NOTIFY = 3;
    
    /** Since Android 5.0+ notification icons must follow a design guidelines 
     * 	to be showed correctly and allows to set the background color for the 
     *  icon. The specified color must be in <b>hexadecimal<b> */
    public static final String NOTIFICATION_BG_COLOR = "#000000";
}
