package com.colectivosvip.optimil.sqllite;

import android.content.Context;
import android.util.Log;
import com.colectivosvip.optimil.ApplicationBase;
import com.colectivosvip.optimil.Constants;

/**
 * SQLite DB initialization singleton.
 * 
 * @author JavocSoft, 2015
 * @version 1.0<br>
 * $Rev: 816 $<br>
 * $LastChangedDate: 2015-11-30 15:03:36 +0100 (lun, 30 nov 2015) $<br>
 * $LastChangedBy: admin $
 *
 */
public class SQLite {

	private static final String DB_NAME = "ClubOptimil";
	/**
	 * When DB changes increment this number and do changes in the
	 * DB in {@link DatabaseSQLite#doOnUpgrade} method.
	 */
	private static final int DB_VERSION = 1;
	
	private static SQLite mySQLite = null;
	
	private static DatabaseSQLite myDB = null;
	private static DatabaseHelper mDatabaseHelper = null;
	
	
	
	
	private SQLite() {}
	
	public synchronized static SQLite getInstance(Context context) {
		if(mySQLite==null) {
			mySQLite = new SQLite();
			initialize(context);
			if(ApplicationBase.debugMode)
				Log.d(Constants.TAG, "Application SQLite DB initialized.");
		}
		
		return mySQLite;
	}

	
	/**
	 * Initializes the DB creating the operations helper.
	 * 
	 * @param context
	 */
	private static void initialize(Context context) {
		//Initialize your Database
		myDB = new DatabaseSQLite(context.getApplicationContext(), DB_NAME, DB_VERSION);
		//Create/upgrade the database
		mDatabaseHelper = new DatabaseHelper(myDB);		
	}
	
	/**
	 * Returns the DB operations helper.
	 * 
	 * @return
	 */
	public DatabaseHelper getDBHelper() {
		return mDatabaseHelper;
	}
	
}
