package com.colectivosvip.optimil;

import java.util.Timer;
import java.util.TimerTask;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.Window;

import com.google.gson.Gson;

import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.crypto.PRNGFixes;
import es.javocsoft.android.lib.toolbox.net.HttpOperations;
import com.colectivosvip.optimil.external.ProximityExternalApiTask;
import com.colectivosvip.optimil.updates.ApplicationInfo;
import com.colectivosvip.optimil.updates.Response;

/**
 * 
 * @author JavocSoft, 2014
 * @version 1.0<br>
 * $Rev: 871 $<br>
 * $LastChangedDate: 2016-12-15 18:49:05 +0100 (jue, 15 dic 2016) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
public class SplashActivity extends FragmentActivity {

    private int splashDelay = 3000;

    private TimerTask task = null;
    
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
    	super.onCreate(savedInstanceState);

    	//Remove title bar (here because we are using ActionBarActivity)
        requestWindowFeature(Window.FEATURE_NO_TITLE);
    	
        setContentView(R.layout.activity_splash);
        
        ApplicationBase.getApplicationVersionString(getApplicationContext());
        ApplicationBase.getUserToken(getApplicationContext());
        ApplicationBase.getApplicationName(getApplicationContext());
        ApplicationBase.getApplicationPlatform();
        
        //Make boot sound starts
        if(ApplicationBase.enableBootSound)
        	ToolBox.media_soundPlayFromAssetFolder(getApplicationContext(), Constants.APP_BOOT_SOUND);
        
        //Wait n seconds and launches the main activity.
        task = new TimerTask() {
            @Override
            public void run() {
            	
            	final Intent mainIntent = new Intent().setClass(SplashActivity.this, PrincipalActivity.class);
                //We pass all the extras to do not loss them in case there are some 
                //manually added ones.
                if(getIntent().getExtras()!=null){
                	if(mainIntent.getExtras()==null){
                		mainIntent.putExtras(getIntent().getExtras());
                	}else{
                		mainIntent.getExtras().putAll(getIntent().getExtras());
                	}
                }      
                
                /*
                startActivity(mainIntent);
	            finish();*/
                
                //We apply an animation :)
                //ToolBox.animation_applyAnimationToActivityLoad(SplashActivity.this, mainIntent, R.anim.right_in, R.anim.left_out);                
                //ToolBox.animation_applyAnimationToActivityLoad(SplashActivity.this, mainIntent, R.anim.slide_down, R.anim.left_out);
                //ToolBox.animation_applyAnimationToActivityLoad(SplashActivity.this, mainIntent, R.anim.curtain_down, R.anim.fadeout);
                //ToolBox.animation_applyAnimationToActivityLoad(SplashActivity.this, mainIntent, R.anim.right_in, R.anim.right_out);
                //ToolBox.animation_applyAnimationToActivityLoad(SplashActivity.this, mainIntent, R.anim.left_in, R.anim.left_out);
                //ToolBox.animation_applyAnimationToActivityLoad(SplashActivity.this, mainIntent, R.anim.curtain_down_and_bounce, R.anim.fadeout);
                ToolBox.animation_applyAnimationToActivityLoad(SplashActivity.this, mainIntent, R.anim.fadein, R.anim.fadeout);
            }
        };
        
        //Official Patch for JCA cryptography security issues.
        PRNGFixes.apply();
        
        //Test the internal messenger
        //ApplicationBase.messengerInner = new Mezzenger("Inner", getApplicationContext());
        //ApplicationBase.messengerInner.connect("com.colectivosvip.optimil.messenger.ACTION_BIND");
        
        launchAppversionCheck();
                
        /*String appLaunchAction = "com.colectivosvip.vvodafoneapp.ACTION_SP_GUI_LAUNCH";
        String appPackage = "com.colectivosvip.vvodafoneapp";
        if(ToolBox.intent_checkForAppLauncherAction(this, appLaunchAction, appPackage)){
        	Intent i = new Intent();
            i.setAction(appLaunchAction);
            startActivity(i);
        }else{
        	Log.e("TEST", "ERROR - No launcher for action: " + appLaunchAction);
        }*/
    }

    
    
    //APPLICATION VERSION CHECK
    
    private void launchAppversionCheck() {
    	//Check for available updates
    	if(ApplicationBase.enableAutoUpdate) {
	    	String url = Constants.MGAPI_CHECKAPP_URL.replaceAll("<app_name>", ToolBox.application_packageName(SplashActivity.this));
	    	url = url.replaceAll("<app_platform>", "android");        	    
	    	new CheckForLastVersionOperationTask(url, ToolBox.application_getVersionCode(SplashActivity.this)).execute();
    	}else{
    		continueLaunching();
    	}
    }
    
    private void continueLaunching() {
    	//Once done the update check we continue opening the app.    	    	
		Timer timer = new Timer();
        timer.schedule(task, splashDelay);
	}
    
    
    /**
	 * Checks for updates of the application.
	 * 
	 */
	class CheckForLastVersionOperationTask extends AsyncTask<Void, Void, Boolean> {
	    private String url;
	    private int currentVersionCode;
	    private int lastVersionCode;
	    private int forceUpdate = 0;
	    
	    public CheckForLastVersionOperationTask(String url, int currentVersionCode) {
	        this.url = url;
	        this.currentVersionCode = currentVersionCode;	        
	    }

	    protected void onPreExecute() {
	    	setProgressBarIndeterminateVisibility(true);
	    	ToolBox.dialog_showToastAlert(SplashActivity.this, getResources().getText(R.string.update_process_looking).toString(), false, false, ToolBox.TOAST_TYPE.INFO);
    	} 
	    
	    protected Boolean doInBackground(Void... params) {
	    	if(ToolBox.net_isNetworkAvailable(SplashActivity.this)){
	    		return doWork();
	    	}else{
	    		return false;
	    	}
	    }

	    protected void onPostExecute(Boolean result) {
	    	setProgressBarIndeterminateVisibility(false);
	    	
	    	if(result){
	    		if(currentVersionCode<lastVersionCode){
	    			AlertDialog.Builder builder = new AlertDialog.Builder(SplashActivity.this);
	    			
	    			if(forceUpdate==1){
	    				builder.setMessage(R.string.update_dialog_forced);
	    			}else{
	    				builder.setMessage(R.string.update_dialog);
	    			}
	    			
	    			builder.setCancelable(false)
	    			       .setPositiveButton(R.string.update_process_update_yes, new DialogInterface.OnClickListener() {
	    			           public void onClick(DialogInterface dialog, int id) {
	    			               Intent i = ToolBox.market_getMarketAppIntent(getApplication().getPackageName());
	    			               startActivity(i);
	    			        	   finish();
	    			           }
	    			       })
	    			       .setNegativeButton(R.string.update_process_update_no, new DialogInterface.OnClickListener() {
	    			           public void onClick(DialogInterface dialog, int id) {
	    			        	   if(forceUpdate==1){
	    			        		   finish();
	    			        	   }else{
	    			        		   dialog.dismiss();	    			        		   
	    			        		   continueLaunching();
	    			        	   }
	    			           }
	    			       });
	    					
	    			AlertDialog alert = builder.create();
	    			alert.show();
	    		}else{
	    			ToolBox.dialog_showToastAlert(SplashActivity.this, getResources().getText(R.string.update_process_not_found).toString(), false, false, ToolBox.TOAST_TYPE.INFO);
	    			continueLaunching();
	    		}
	    	}else{
	    		//Check could not be done correctly
	    		if(!ToolBox.net_isNetworkAvailable(SplashActivity.this)){
    				ToolBox.dialog_showToastAlert(SplashActivity.this, getResources().getText(R.string.update_process_error_no_network).toString(), false, false, ToolBox.TOAST_TYPE.ERROR);
    			}else{
    				ToolBox.dialog_showToastAlert(SplashActivity.this, getResources().getText(R.string.update_process_error).toString(), false, false, ToolBox.TOAST_TYPE.ERROR);
    			}	    			
    			continueLaunching();
	    	}
	    }
	    
	    
		//AUXILIAR		
		    
		private boolean doWork(){
		   	boolean res = false;
		    	
		   	try {
		   		//Validate JSON: http://jsonlint.com/
				String resJson = HttpOperations.doGet(url, null, true);
				Gson gson = new Gson();
				try{
					Response response = gson.fromJson(resJson, Response.class);
					if(response.getErrorCode()==200){
						ApplicationInfo appInfo = new ApplicationInfo(resJson);
						lastVersionCode = appInfo.version;
						forceUpdate = appInfo.force;
						
						if(appInfo.isConfigAvailable) {
							ApplicationBase.LOCATION_UPDATE_MIN_TIME = appInfo.configLocMinTime; //1000 for debugging
							ApplicationBase.LOCATION_UPDATE_MIN_DISTANCE = appInfo.configLocMinDistance; //10 for debugging
							ApplicationBase.LOCATION_UPDATE_ACCURACY_THRESHOLD = appInfo.configLocAccuracyThreshold;
							ApplicationBase.LOCATION_ALERT_TIME_THRESHOLD = appInfo.configLocTimeBetweenNotifications; //120000 for debugging
							ApplicationBase.API_PROXIMITY_RADIUS = appInfo.configLocProximityRadius;
							ApplicationBase.API_PROXIMITY_MIN_ITEMS_TO_NOTIFY = appInfo.configLocProximityMinOffersToNotify;
							
							//Save preferences for later usage in case application gets killed
							ToolBox.prefs_savePreference(getBaseContext(), ProximityExternalApiTask.PREF_FILE_NAME, ProximityExternalApiTask.PREF_PARAM_MIN_ITEMS, Integer.class, ApplicationBase.API_PROXIMITY_MIN_ITEMS_TO_NOTIFY);
						    ToolBox.prefs_savePreference(getBaseContext(), ProximityExternalApiTask.PREF_FILE_NAME, ProximityExternalApiTask.PREF_PARAM_RADIUS, Integer.class, ApplicationBase.API_PROXIMITY_RADIUS);
							
							if(ApplicationBase.debugMode)
								Log.d(Constants.TAG, "Custom configuration applied");
						}
						
						res = true;
					}
				}catch(Exception e){
					Log.e(Constants.TAG, "ERROR: " + e.getMessage(), e);
				}					
			} catch (Exception e) {
				Log.e(Constants.TAG, "ERROR doing call to check for an update [" + e.getMessage() + "]", e);
			}
		    return res;
		}
	}
    
}
