package com.colectivosvip.optimil;

import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.util.Linkify;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.ImageButton;
import android.widget.TextView;
import es.javocsoft.android.lib.toolbox.ToolBox;

/**
 * 
 * @author JavocSoft, 2014
 * @version 1.0<br>
 * $Rev: 645 $<br>
 * $LastChangedDate: 2015-03-07 13:55:38 +0100 (sáb, 07 mar 2015) $<br>
 * $LastChangedBy: jgonzalez $
 *
 */
public class AboutActivity extends FragmentActivity {
	

	@Override
	protected void onCreate(Bundle savedInstanceState) {		
		//Remove title bar (here because we are using ActionBarActivity)
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        
		super.onCreate(savedInstanceState);
		
		setContentView(R.layout.activity_about);
		
		String appVersion = ToolBox.application_getVersion(this);
		String aboutInfo = getResources().getText(R.string.about_text).toString();
		aboutInfo = aboutInfo.replace("__VERSION__", appVersion);
		
		final TextView aboutText = (TextView) findViewById(R.id.about_text);
		aboutText.setText(aboutInfo);
		
		Linkify.addLinks(aboutText, Linkify.ALL);
		
		ImageButton dialogButton = (ImageButton) findViewById(R.id.dialogButtonOK);
		dialogButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {				
				finish();
			}
		});
	
	}
	
}
