/*
 * Decompiled with CFR 0.152.
 */
package es.javocsoft.android.lib.toucan.client.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toucan.client.thread.ToucanGetWorker;
import es.javocsoft.android.lib.toucan.client.thread.ToucanPostWorker;
import es.javocsoft.android.lib.toucan.client.thread.ToucanWorker;
import java.io.File;
import java.io.FilenameFilter;

public class PendingOperationsDeliveryService
extends IntentService {
    private static final String SERVICE_NAME = "PendingOperationsDeliveryService";

    public PendingOperationsDeliveryService() {
        super(SERVICE_NAME);
    }

    public PendingOperationsDeliveryService(String name) {
        super(name);
    }

    protected void onHandleIntent(Intent intent) {
        String[] pendingOperations = PendingOperationsDeliveryService.listCachedOperations(this.getApplicationContext());
        if (pendingOperations != null && pendingOperations.length > 0) {
            if (ToolBox.net_isNetworkAvailable((Context)this.getApplicationContext())) {
                Log.i((String)"ToucanClient", (String)("Total pending operations: " + pendingOperations.length));
                PendingOperationsDeliveryService.sendCachedOperations(pendingOperations, this.getApplicationContext());
            } else {
                Log.i((String)"ToucanClient", (String)"PendingOperationsDeliveryService: no network connection, skipping pending operations.");
            }
        }
        this.stopSelf();
    }

    private static synchronized String[] listCachedOperations(Context context) {
        String filePath = context.getFilesDir().getAbsolutePath();
        File appInternalDir = new File(filePath);
        String[] pendingRequests = appInternalDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String name) {
                return name.startsWith("toucan_client_pending_request_");
            }
        });
        return pendingRequests;
    }

    private static synchronized void sendCachedOperations(String[] pendingRequestOp, Context context) {
        Log.i((String)"ToucanClient", (String)("PendingOperationsDeliveryService: Pending operation requests to send: " + pendingRequestOp.length));
        for (String requestOpFile : pendingRequestOp) {
            try {
                byte[] pendingRequestBytes = ToolBox.storage_readDataFromInternalStorage((Context)context, (String)requestOpFile);
                if (pendingRequestBytes == null || pendingRequestBytes.length <= 0) continue;
                PendingOperationsDeliveryService.startOperation(pendingRequestBytes, context);
            }
            catch (Exception e) {
                Log.e((String)"ToucanClient", (String)("PendingOperationsDeliveryService: Error sending pending operation request (" + e.getMessage() + ")"), (Throwable)e);
            }
        }
    }

    private static synchronized void startOperation(byte[] pendingRequestData, Context context) {
        String jsonData = new String(pendingRequestData);
        if (jsonData != null && jsonData.length() > 0) {
            new DeliverPendingRequest(jsonData, context).start();
        } else {
            Log.e((String)"ToucanClient", (String)"No JSON data to send cached operation!!.");
        }
    }

    static class DeliverPendingRequest
    extends Thread
    implements Runnable {
        private String jsonData;
        private Context context;

        public DeliverPendingRequest(String jsonData, Context context) {
            this.jsonData = jsonData;
            this.context = context;
        }

        @Override
        public void run() {
            if (this.jsonData.indexOf("\"type\":\"POST\"") != -1) {
                ToucanPostWorker temp = ToucanWorker.initializePOSTFromJSON(this.jsonData);
                temp.initData();
                temp.setContext(this.context);
                temp.start();
            } else {
                ToucanGetWorker temp = ToucanWorker.initializeGETFromJSON(this.jsonData);
                temp.initData();
                temp.setContext(this.context);
                temp.start();
            }
        }
    }
}

