/*
 * Decompiled with CFR 0.152.
 */
package es.javocsoft.android.lib.toucan.client.request.bean;

import android.util.Log;
import com.google.gson.annotations.Expose;
import es.javocsoft.android.lib.toolbox.crypto.SHA1Encoding;
import es.javocsoft.android.lib.toolbox.crypto.exception.SHA1EncodingException;
import java.util.Date;

public class DeviceRegistrationBean {
    @Expose
    private int id;
    @Expose
    private int appVersion;
    @Expose
    private int extId;
    @Expose
    private String notToken;
    @Expose
    private String devId;
    @Expose
    private String devOs;
    @Expose
    private String devExtra;
    @Expose
    private String devLocale;
    @Expose
    private String devResType;
    @Expose
    private String installReferral;
    @Expose
    private Date tsCreation;
    @Expose
    private Date tsUpdate;

    public DeviceRegistrationBean(int id, int appVersion, int extId, String notToken, String devId, String devOs, String devExtra, String devLocale, String devResType, String installReferral, Date tsCreation, Date tsUpdate) {
        this.id = id;
        this.appVersion = appVersion;
        this.extId = extId;
        this.notToken = notToken;
        this.devId = devId;
        this.devOs = devOs;
        this.devExtra = devExtra;
        this.devLocale = devLocale;
        this.devResType = devResType;
        this.installReferral = installReferral;
        this.tsCreation = tsCreation;
        this.tsUpdate = tsUpdate;
    }

    public DeviceRegistrationBean() {
    }

    public String getSecurityHash(String key) {
        return this.createSHA1Hash(key + "/" + this.getDataAsString());
    }

    public String getDataAsString() {
        return this.appVersion + ";#;" + this.extId + ";#;" + (this.devId == null ? "NONE" : this.devId) + ";#;" + (this.devLocale == null ? "NONE" : this.devLocale) + ";#;" + (this.devOs == null ? "NONE" : this.devOs) + ";#;" + (this.devExtra == null ? "NONE" : this.devExtra) + ";#;" + (this.devResType == null ? "NONE" : this.devResType) + ";#;" + (this.installReferral == null ? "NONE" : this.installReferral) + ";#;" + (this.notToken == null ? "NONE" : this.notToken);
    }

    private String createSHA1Hash(String data) {
        try {
            return SHA1Encoding.getSHA1((String)data);
        }
        catch (SHA1EncodingException e) {
            Log.e((String)"ToucanClient", (String)e.getMessage());
            return null;
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(int appVersion) {
        this.appVersion = appVersion;
    }

    public int getExtId() {
        return this.extId;
    }

    public void setExtId(int extId) {
        this.extId = extId;
    }

    public String getNotToken() {
        return this.notToken;
    }

    public void setNotToken(String notToken) {
        this.notToken = notToken;
    }

    public String getDevId() {
        return this.devId;
    }

    public void setDevId(String devId) {
        this.devId = devId;
    }

    public String getDevOs() {
        return this.devOs;
    }

    public void setDevOs(String devOs) {
        this.devOs = devOs;
    }

    public String getDevExtra() {
        return this.devExtra;
    }

    public void setDevExtra(String devExtra) {
        this.devExtra = devExtra;
    }

    public String getDevLocale() {
        return this.devLocale;
    }

    public void setDevLocale(String devLocale) {
        this.devLocale = devLocale;
    }

    public String getDevResType() {
        return this.devResType;
    }

    public void setDevResType(String devResType) {
        this.devResType = devResType;
    }

    public String getInstallReferral() {
        return this.installReferral;
    }

    public void setInstallReferral(String installReferral) {
        this.installReferral = installReferral;
    }

    public Date getTsCreation() {
        return this.tsCreation;
    }

    public void setTsCreation(Date tsCreation) {
        this.tsCreation = tsCreation;
    }

    public Date getTsUpdate() {
        return this.tsUpdate;
    }

    public void setTsUpdate(Date tsUpdate) {
        this.tsUpdate = tsUpdate;
    }
}

