package com.colectivosvip.clubempleadosineco.javascript;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import android.content.Context;
import android.util.Log;
import android.webkit.JavascriptInterface;
import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.gcm.NotificationModule;
import es.javocsoft.android.lib.toucan.client.ToucanClient;
import com.colectivosvip.clubempleadosineco.ApplicationBase;
import com.colectivosvip.clubempleadosineco.Constants;
import com.colectivosvip.clubempleadosineco.PrincipalActivity;
import com.colectivosvip.clubempleadosineco.R;


/**
 * This class is an Interface to be able to launch Android native
 * methods from web through JS. The channel is bidirectional and
 * allows to call web JS methods within Android application.<br><br>
 *
 * To enable it in the WebView:<br><br>
 * 
 * //This enables the JS in the webviews's content.<br>
 * myWebView.getSettings().setJavaScriptEnabled(true);<br>
 * //This enables to expose to webviews's web some native android app methods.<br>
 * myWebView.addJavascriptInterface(new WebAppJSInterface(this), "Android");<br><br>
 * 
 * Once enabled, in web side there should be a JS object called "Android".<br><br>
 * 
 * We can use it to check if we are running the web inside Android native app
 * by using this JS code:<br>
 * <code>
 * 	if("Android" in window){....} 
 * </code>
 *
 * <br><br>
 * See <a href="http://developer.android.com/guide/webapps/webview.html">WebView</a>.
 *
 * @author JavocSoft, 2014
 * @version 1.0<br>
 * $Rev: 830 $<br>
 * $LastChangedDate: 2016-03-03 13:31:18 +0100 (jue, 03 mar 2016) $<br>
 * $LastChangedBy: admin $
 *
 */    
public class WebAppJSInterface {
    
	private Context mContext;
    private PrincipalActivity pActivity;
    

    /** Instantiate the interface and set the context */
    public WebAppJSInterface(PrincipalActivity pActivity) {
        this.mContext = pActivity.getApplicationContext();
        this.pActivity = pActivity;
    }

    
    //PUBLIC JS methods available in a web running
    //inside a WebView.
    
    @JavascriptInterface
    public void androidAppScanCode() {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG + "::WebJSInterface", "Scan code command send from web.");
    	
    	if(!ApplicationBase.enableQR) {
    		if(ApplicationBase.debugMode)
    			Log.d(Constants.TAG, "Scan code module not enabled.");
    		final String jsonResult = urlEncode("{\"resultCode\":\"module_not_enabled\",\"codeType\":\"none\"}");
    		
    		//We have to load in the webview thread
    		pActivity.getWebView().post(new Runnable() {
                public void run() {
                	pActivity.getWebView().loadUrl("javascript:" + Constants.VV_JS_SCANCODERESULT_METHOD + "('" + jsonResult + "')");
                }
            });
    	}else{
    		if(!(Boolean)ToolBox.prefs_readPreference(mContext, Constants.PREF_NAME, Constants.PREF_KEY__SHOWSCANTIP, Boolean.class)){
        		pActivity.createScanCodeTipDialog();
        	}else{
        		//ZXing Barcode Scanner
        		pActivity.initiateCodeScan();
        	}        		
    	}
    }

    @JavascriptInterface
    public void androidAppRecoverUserGPushId() {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG + "::WebJSInterface", "Get GCM Registration-ID command send from web.");
    	
        //Get Google Push Service device Id.
        // https://developer.android.com/google/gcm/index.html
        String gPushId = "none";
        String result = null;
        if(!ApplicationBase.enablePush) {
        	if(ApplicationBase.debugMode)
        		Log.d(Constants.TAG, "GCM module not enabled.");
        	gPushId = "none";
        	result = "{\"resultCode\":\"module_not_enabled\",\"gPushId\":\"" + gPushId + "\"}";            	
        	
        }else{
        	gPushId = NotificationModule.getRegistrationId(NotificationModule.APPLICATION_CONTEXT);
        	if(gPushId!=null && gPushId.length()==0) {
        		gPushId = "none";            		
        	}
        	result = "{\"resultCode\":\"module_enabled\",\"gPushId\":\"" + gPushId + "\"}";
        }
        
        final String jsonResult = urlEncode(result);
        //We have to load in the webview thread
        pActivity.getWebView().post(new Runnable() {
            public void run() {
            	pActivity.getWebView().loadUrl("javascript:" + Constants.VV_JS_GPUSHID_INFORM_METHOD + "('" + jsonResult + "')");
            }
        });
        
        //Send the GCM registration id to the web.
        //(Make the JS call asynchronously)
        //See:
        //	https://developer.android.com/reference/android/webkit/WebView.html#evaluateJavascript(java.lang.String, android.webkit.ValueCallback<java.lang.String>)
        /*pActivity.getWebView().evaluateJavascript("javascript:" + Constants.VV_JS_GPUSHID_INFORM_METHOD + "('" + jsonResult + "')", new ValueCallback<String>() {
			
			@Override
			public void onReceiveValue(String value) {
				//Do something with the result if there is one.
			}
		});*/
    }

    @JavascriptInterface
    public void androidAppInformLocationToWeb(boolean setToNone) {
    	if(ApplicationBase.appIsDestroyed)
    		return;
    	
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG + "::WebJSInterface", "Sending current location to the web.");
    	
    	//setAndroidAppLocation(address, lat, lng, country)
    	String result = "null,null,null,null";
    	if(ApplicationBase.enableLocation 
    			&& ApplicationBase.locationServiceEnabled && ApplicationBase.location != null
    			&& !setToNone) {
    		
    		String address = ApplicationBase.location.getAddress();
    		if(ApplicationBase.location.getAddress()==null || 
    			(ApplicationBase.location.getAddress()!=null && ApplicationBase.location.getAddress().length()==0)){
    			//In case Android could not determine the address, we return an string.
    			address = mContext.getResources().getString(R.string.location_address_not_available);
    		}
    		
    		result = "'" + address + "'," 
    				+ ApplicationBase.location.getLocation().getLatitude() + "," 
    				+ ApplicationBase.location.getLocation().getLongitude()  + "," 
    				+ "'" + ApplicationBase.location.getCountryCode() + "'";
    	}
    	
    	//final String jsonResult = urlEncode(result);
    	final String jsonResult = result;
    	//We have to load in the webview thread
    	pActivity.getWebView().post(new Runnable() {
            public void run() {
            	pActivity.getWebView().loadUrl("javascript:" + Constants.VV_JS_USERLOCATION_NOJSON_INFORM_METHOD + "(" + jsonResult + ")");
            	if(ApplicationBase.debugMode)
            		Log.d(Constants.TAG + "::WebJSInterface", "Sending current location [" + jsonResult + "]to the web, done.");
            }
        });
    }	
    
    @JavascriptInterface
    public void androidIsLocationEnabled() {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG + "::WebJSInterface", "Sending current location to the web.");
    	
    	pActivity.getWebView().post(new Runnable() {
            public void run() {
            	if(!ToolBox.isLocationEnabled(mContext) || 
            			!ApplicationBase.permissionsLocationGranted ||
            			!ApplicationBase.enableLocation || 
                    	!ApplicationBase.enableInitialLocation){
            		pActivity.getWebView().loadUrl("javascript:" + Constants.VV_JS_USERLOCATION_CLEARLOCATION_METHOD + "()");            		
            	}
            }
        });
    }
    
    @JavascriptInterface
    public void androidAppGetUserLocation() {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG + "::WebJSInterface", "Current location command send from web.");
    	
    	String result = null;
        if(!ApplicationBase.enableLocation) {
        	if(ApplicationBase.debugMode)
        		Log.d(Constants.TAG, "Location module not enabled.");
        	//Latitude and longitude goes between -90 and 90.
        	result = "{\"resultCode\":\"module_not_enabled\",\"lat\":" + 100 + ",\"lng\":" + 100 + "}";            	
        }else{
        	if(ApplicationBase.locationServiceEnabled && ApplicationBase.location != null) {
        		result = "{\"resultCode\":\"module_enabled\",\"lat\":" + 
        					ApplicationBase.location.getLocation().getLatitude() + ",\"lng\":" 
        					+ ApplicationBase.location.getLocation().getLongitude() + "}";
        	}else{
        		//Latitude and longitude goes between -90 and 90.
                result = "{\"resultCode\":\"module_enabled\",\"lat\":" + 100 + ",\"lng\":" + 100 + "}";                
        	}
            
        	final String jsonResult = urlEncode(result);
        	//We have to load in the webview thread
        	pActivity.getWebView().post(new Runnable() {
                public void run() {
                	pActivity.getWebView().loadUrl("javascript:" + Constants.VV_JS_USERLOCATION_INFORM_METHOD + "('" + jsonResult + "')");
                }
            });            
        }
    }
    
    @JavascriptInterface
    public void androidAppRequestGPSLocation() {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG + "::WebJSInterface", "Request GPS location command send from web.");
    	
    	if(!ApplicationBase.enableLocation) {
    		if(ApplicationBase.debugMode)
    			Log.d(Constants.TAG, "Location module not enabled.");
        	final String jsonResult = urlEncode("{\"resultCode\":\"module_not_enabled\",\"gpsEnabled\":false}");
        	//We have to load in the webview thread
        	pActivity.getWebView().post(new Runnable() {
                public void run() {
                	pActivity.getWebView().loadUrl("javascript:" + Constants.VV_JS_USERLOCATION_ENABLED_STATUS_METHOD + "('" + jsonResult + "')");
                }
            });
        	
    	}else{
    		if(!ApplicationBase.locationServiceEnabled) {
    			if(ApplicationBase.debugMode)
    				Log.d(Constants.TAG, "Location module enabled but service not running.");
            	final String jsonResult = urlEncode("{\"resultCode\":\"service_not_running\",\"gpsEnabled\":false}");
            	//We have to load in the webview thread
            	pActivity.getWebView().post(new Runnable() {
                    public void run() {
                    	pActivity.getWebView().loadUrl("javascript:" + Constants.VV_JS_USERLOCATION_ENABLED_STATUS_METHOD + "('" + jsonResult + "')");
                    }
                });
    		}else{
    			//Checks if the GPS is enabled, if not, it shows the 
            	//popup to enable it in the system settings.
            	if (!ApplicationBase.isGPSProviderEnabled) {
            		ToolBox.dialog_showGPSDisabledAlert(pActivity, 
            				"El GPS esta deshabilitado. Se necesita dicha función. ¿Desea hacerlo?", 
            				"Activar GPS", "Cancelar");        		
            	}else{
            		final String jsonResult = urlEncode("{\"resultCode\":\"module_enabled\",\"gpsEnabled\":true}");
            		//We have to load in the webview thread
            		pActivity.getWebView().post(new Runnable() {
                        public void run() {
                        	pActivity.getWebView().loadUrl("javascript:" + Constants.VV_JS_USERLOCATION_ENABLED_STATUS_METHOD + "('" + jsonResult + "')");
                        }
                    });
            	}
    		}
        }
    } 
    
    @JavascriptInterface
    public void androidLocationAcquired() {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG, "Location successfully acquired from web.");
    	
    	pActivity.getWebView().post(new Runnable() {
            public void run() {
            	if(!ApplicationBase.appIsDestroyed)
            		//We stop the location service for now.
            		((ApplicationBase)pActivity.getApplication()).stopLocationService();
            }
        });
    }
    
    @JavascriptInterface
    public void androidRefresh() {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG, "Refresh command send from web.");
    	
    	pActivity.getWebView().post(new Runnable() {
            public void run() {
            	pActivity.getWebView().reload();
            }
        });
    }
    
    @JavascriptInterface
    public void androidAppExit() {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG, "Exit command send from web. Finishing app.");
    	
    	pActivity.finish();
    }                
    
    @JavascriptInterface
    public void androidInformExternalId(Integer externalId) {
    	if(ApplicationBase.debugMode)
    		Log.d(Constants.TAG + "::WebJSInterface", "ExternalId received: " + externalId);
    	
    	ToucanClient.getInstance(mContext,
    			Constants.TOUCAN_API_TOKEN, 
    			Constants.TOUCAN_APP_PUB_KEY)
    			.informExternalId(externalId, null);
    }
    
    
    //AUXILIAR
    
    /**
     * Returning a string implies to url encode
     * to avoid issues in the JS function when
     * using as function parameter.
     * 
     * @param data	data to url encode
     * @return  The url encoded result or ERROR string.
     */
    private String urlEncode(String data) {
    	String res = "ERROR";
		try {
			res = URLEncoder.encode(data, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			Log.e(Constants.TAG, "WebAppInterface. Error encoding to UTF-8 the result for the web [" + e.getMessage() + "]");
		}
		
		return res;
    }
}
