package com.colectivosvip.clubempleadosineco;

import java.util.HashMap;
import java.util.List;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Bundle;
import android.util.Log;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.Tracker;

import es.javocsoft.android.lib.toolbox.ToolBox;
import es.javocsoft.android.lib.toolbox.ToolBox.NOTIFICATION_PRIORITY;
import es.javocsoft.android.lib.toolbox.ToolBox.NOTIFICATION_STYLE;
import es.javocsoft.android.lib.toolbox.drive.TBDrive;
import es.javocsoft.android.lib.toolbox.location.service.LocationService;
import es.javocsoft.android.lib.toolbox.messenger.Mezzenger;
import es.javocsoft.android.lib.toolbox.net.image.ImageDownloader;
import com.colectivosvip.clubempleadosineco.javascript.WebAppJSInterface;
import com.colectivosvip.clubempleadosineco.net.ImageUtils;

/**
 * This class is a place to hold application data that can be get by receivers
 * and services safety.
 * <br><br>
 * See:
 * <ul>
 * <li><a href="http://www.intridea.com/blog/2011/5/24/how-to-use-application-object-of-
 * android">Application object HowTo</a></li> 
 * <li><a href="http://developer.android.com/guide/topics/manifest/application-element.html">
 * Application object element</a></li>
 * <li><a href="http://www.devahead.com/blog/2011/06/extending-the-android-application-class-and
 * -dealing-with-singleton/">Application class. Singleton pattern.</a></li>
 * </ul>
 * 
 * @author JavocSoft 2013
 * @version 2.0<br>
 *          $Rev: 833 $<br>
 *          $LastChangedDate: 2016-03-15 21:59:18 +0100 (mar, 15 mar 2016) $<br>
 *          $LastChangedBy: jgonzalez $
 *
 */
public class ApplicationBase extends Application {
	
	//Properties for non activity components.
	public static boolean debugMode = true;
	
	//MODULE SETTINGS
	public static boolean enableAds = false;
	public static boolean enablePush = false;
	public static boolean enableWebMenu = false;
	public static boolean enableQR = false;
	public static boolean enableAnalytics = false;
	public static boolean enableLocation = true;
	public static boolean enableInitialLocation = true;
	public static boolean enableLocationWebResetOnGPSDisabled = false;
	public static boolean enableExitConfirmation = true;
	public static boolean enableGDrive = false;
	public static boolean enableAutoUpdate = true;
	public static boolean enableSQLite = false;
	public static ToolBox.EXIT_CONFIRMATION_STYLE exitStyle = ToolBox.EXIT_CONFIRMATION_STYLE.BACK_PRESS;
	
	
	//OTHER APPLICATION SETTINGS
	public static boolean enableNativeMenu = false;
	public static boolean lockInPortrait = false;
	public static boolean enableWhatIsNewDialog = false;
	public static boolean enableBootSound = false;
	
	//ADS MODULE SETTINGS
	public static String module_ads_banner_id = "ca-app-pub-3940256099942544/6300978111";
	public static String module_ads_interstitial_id = "ca-app-pub-3940256099942544/6300978111";

    //GCM MODULE SETTINGS
	public static String module_gcm_server_id = "749614828866";
	public static String module_gcm_groupNotificationsKey = "ClubEmpleadosIneco";
	
	public TBDrive tbDrive = null;
	
	//A messenger
	public static Mezzenger messengerInner = null;
	
	//Location related
	public static int LOCATION_UPDATE_MIN_DISTANCE = 50; //Meters
    public static long LOCATION_UPDATE_MIN_TIME = 60000l;  //Milliseconds
    public static int LOCATION_UPDATE_ACCURACY_THRESHOLD = 25; //In meters
    /** To avoid being notified constantly and just in case, we can use this value
     * to set a minimum time between location alerts. */
    public static int LOCATION_ALERT_TIME_THRESHOLD = 1; //Minutes
	public static boolean permissionsLocationGranted = false;
	public static boolean locationServiceEnabled = false;
	//When application goes to background stop the location service
	public static boolean locationStopOnPause = true;
	public static LocationInfo location = null;
	public static boolean isGPSProviderEnabled = false;
	
	//WebView JS Interface
	public static WebAppJSInterface appWebJSInterface = null;
	
	//Has the value of TRUE when application is destroyed
	public static boolean appIsDestroyed = false;
	
	//Image load related
	private static ImageDownloader mImageDownloader = null;
	/** The selected lazy-load image downloader. */ 
    public static ImageUtils.URL_IMAGE_DOWNLOADER_LIB URL_IMAGE_DOWNLOADER = ImageUtils.URL_IMAGE_DOWNLOADER_LIB.PICASSO;
	
    @Override
    public void onCreate() {
        super.onCreate();
        
        //Initializes default image downloader
      	if(mImageDownloader == null)
      		mImageDownloader = ImageDownloader.getInstance(getBaseContext());        
    }

    
    public ApplicationBase() {
		super();
	}
    
    
    //Static general usage methods
    
    /**
     * Generates a notification in the notification bar.
     * 
     * @param context							The context of the notification.
     * @param notStyle							Select the notification style. See {@link NOTIFICATION_STYLE}
     * @param notPriority						Optional. Select the desired notification priority. 
     * 											See {@link NOTIFICATION_PRIORITY}
     * @param notSound							Set to TRUE to enable sound in the notification.
     * @param notSoundRawId						Optional. Set one to use this sound instead the default one.
     * @param notAction							Optional. Action for this notification.
     * @param notTitle							The title of the notification.
     * @param notMessage						The message of the notification.
     * @param notTicker							Optional. Text that appears for only a few seconds when notification 
     * 											raises. (text which is sent to accessibility services). 
     * @param notContentInfo					Optional. A small piece of additional information pertaining 
     * 											to this notification. The platform template will draw this on 
     * 											the last line of the notification, at the far right (to the 
     * 											right of a smallIcon if it has been placed there).
     * @param lockScreenPrivacy					Optional. Default is PRIVATE.	
     * @param notBigStyleTitle					Optional. Android 4.1+. Overrides ContentTitle in the big form 
     * 											of the template
     * @param notBigStyleContent				Optional. Android 4.1+. Overrides ContentMessage in the big form 
     * 											of the template
     * @param notBigStyleImage					Optional. In BigPicture Expandable notification type. Android 4.1+.
     * 											It is the image to show. Can be a drawable resourceId, an assets 
     * 											resource file name or an URL to an image.
     * @param notBigStyleInboxContent			Optional. In InboxStyle Expandable notification type. It is the
     * 											content of the notification for the expandable.
     * @param notBigStyleInboxLineSeparator		Optional. In InboxStyle Expandable notification type. It is the 
     * 											separator of each line in the received message (notMessage)
     * @param notBigStyleLargeIcon				Optional. Set one to use a larger icon for the notification. Can be a 
     * 											drawable resourceId, an assets/raw resource file name or an URL to an image.
     * @param notBigStyleSummary				Optional. Android 4.1+. Adds a line at the bottom of the notification.
     * @param wakeUp							Set to TRUE to wake-up the device when notification is received.
     * @param extras							Extra information to attach to the notification to be available
	 * 											in the application or the destination intent class (notClazz).
     * 
     */
    public static void generateSystemNotification(Context context, 
    		NOTIFICATION_STYLE notStyle,
    		NOTIFICATION_PRIORITY notPriority,
    		boolean notSound, Integer notSoundRawId,
    		String notAction,
    		String notTitle, String notMessage, 
    		String notTicker, String notContentInfo,
    		ToolBox.NOTIFICATION_LOCK_SCREEN_PRIVACY lockScreenPrivacy,
    		String notBigStyleTitle, String notBigStyleContent,
    		String notBigStyleImage, 
    		String notBigStyleInboxContent, String notBigStyleInboxLineSeparator,
    		String notBigStyleLargeIcon,
    		String notBigStyleSummary,
    		boolean wakeUp, Bundle extras, 
    		Integer notificationId,
    		List<android.support.v4.app.NotificationCompat.Action> actions) {
    	
    	try{
    		
    		//Class to open when notification is pressed
    		Class<?> actToCall = PrincipalActivity.class;
    		
    		if(notStyle==null)
    			notStyle = NOTIFICATION_STYLE.NORMAL_STYLE;
    		
    		if(notAction == null)
    			notAction = "INTERNAL_NOTIFICATION";
    		
    		if(lockScreenPrivacy==null)
    			lockScreenPrivacy = ToolBox.NOTIFICATION_LOCK_SCREEN_PRIVACY.PRIVATE;
    		
    		if(notificationId==null) {
    			if(actions!=null) {
	    			actions.clear();
	    			actions = null;
    			}
    		}
    		
	        ToolBox.notification_create(context, 
	        		notSound, notSoundRawId, false,
	    			false, "AppInternalNotification", 
	    			notAction, 
	    			notTitle, notMessage, 
	    			notTicker, notContentInfo, 
	    			notBigStyleTitle, notBigStyleContent,
	    			notBigStyleSummary, notBigStyleImage, 
	    			notBigStyleInboxContent, notBigStyleInboxLineSeparator, 
	    			actToCall, 
	    			extras, wakeUp, 
	    			notPriority, 
	    			notStyle, 
	    			lockScreenPrivacy, 
	    			(notBigStyleLargeIcon!=null?notBigStyleLargeIcon:null),
	    			null, 
	    			notificationId,
	    			ToolBox.NOTIFICATION_PROGRESSBAR_STYLE.NONE, 
	    			null, null,
					actions);
			
		}catch(Exception e) {
			Log.e(Constants.TAG,"Notification could not be created [" + e.getMessage() + "].", e);			
		}
    }
	
    /**
     * Returns default manual implementation of a lazy-load image
     * downloader.
     * <br><br>
     * Notes:<br>
     * If using external storage, the permission called is required
     * "android.permission.WRITE_EXTERNAL_STORAGE". You can use in the
	 * permission android:maxSdkVersion="18" to make only requested in 
	 * Android version minor to 18.
     * 
     * @return	ImageDownloader object.
     */
    public static ImageDownloader getImageDownloader() {
    	return mImageDownloader;
    }
    
    
    //Methods and properties for activity components
    
    //Location related
    
	/**
	 * Starts the geo-localization service.
	 */
	public void startLocationService() {
		//We only start the service if the user did not disable it.
		if(!(Boolean)ToolBox.prefs_readPreference(this, Constants.PREF_NAME, Constants.PREF_KEY__LOCATION_ALERTS_DISABLED, Boolean.class)){
			Intent mLocServiceIntent = new Intent(getBaseContext(), LocationService.class);
	    	Bundle extras = new Bundle();
	    	extras.putInt(LocationService.LOCATION_SERVICE_PARAM_MIN_DISTANCE, LOCATION_UPDATE_MIN_DISTANCE);
	    	extras.putLong(LocationService.LOCATION_SERVICE_PARAM_MIN_TIME, LOCATION_UPDATE_MIN_TIME);
	    	extras.putInt(LocationService.LOCATION_SERVICE_PARAM_ACCURACY_THRESHOLD, LOCATION_UPDATE_ACCURACY_THRESHOLD);
	    	mLocServiceIntent.putExtras(extras);
	    	//mServiceIntent.setData(Uri.parse(dataUrl));
	    	startService(mLocServiceIntent);
		}
    }
	
	/**
	 * Stops the geo-localization service.
	 */
	public void stopLocationService() {
    	Intent mLocServiceIntent = new Intent(getBaseContext(), LocationService.class);
        stopService(mLocServiceIntent);    	
    }
	
	//End location related
	
	
	/**
	 * Enum used to identify the tracker that needs to be used for tracking.
	 *
	 * A single tracker is usually enough for most purposes. In case you do need
	 * multiple trackers, storing them all in Application object helps ensure
	 * that they are created only once per application instance.
	 */
	public enum TrackerName {
		APP_TRACKER,	// Tracker used only in this application.
		GLOBAL_TRACKER	// Tracker for all applications
	}

	HashMap<TrackerName, Tracker> mTrackers = new HashMap<TrackerName, Tracker>();

	synchronized Tracker getTracker(TrackerName trackerId) {
		if (!mTrackers.containsKey(trackerId)) {
			GoogleAnalytics analytics = GoogleAnalytics.getInstance(this);
			Tracker t = null;
			
			switch (trackerId) {
			case APP_TRACKER:
				t = analytics.newTracker(R.xml.app_tracker);
				break;				
			default:
				t = analytics.newTracker(R.xml.global_tracker);
				break;
			}
								
			mTrackers.put(trackerId, t);
		}
		
		return mTrackers.get(trackerId);
	}

	/**
	 * This class contains location information.
	 * 
	 */
	public static class LocationInfo {
		
		private Location location;
		private String country;
		private String countryCode;
		private String city;
		private String address;
		private String postalCode;
		
		/**
		 * Creates a location information object with the given data
		 * in the Bundle. It uses the {@link LocationService} location 
		 * parameters where location information is stored when a new
		 * location change is detected.
		 * 
		 * @param location
		 * @param extras
		 */
		public LocationInfo(Bundle extras) {
			this.location = extras.getParcelable(LocationService.LOCATION_KEY);
			//Extra information of the location
			this.country = extras.getString(LocationService.LOCATION_COUNTRY_KEY);
			this.countryCode = extras.getString(LocationService.LOCATION_COUNTRY_CODE_KEY);
			this.city = extras.getString(LocationService.LOCATION_CITY_KEY);
			this.address = extras.getString(LocationService.LOCATION_ADDRESS_KEY);
			this.postalCode = extras.getString(LocationService.LOCATION_POSTAL_CODE_KEY);
		}
		
		/**
		 * Creates a location information given the {@link Location}.
		 * 
		 * @param context
		 * @param location
		 */
		public LocationInfo(Context context, Location location) {
			this.location = location;
			this.country = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.COUNTRY, location.getLatitude(), location.getLongitude());
			this.countryCode = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.COUNTRY_CODE, location.getLatitude(), location.getLongitude());
			this.city = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.CITY, location.getLatitude(), location.getLongitude());
			this.address = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.ADDRESS, location.getLatitude(), location.getLongitude());
			this.postalCode = ToolBox.location_addressInfo(context, ToolBox.LOCATION_INFO_TYPE.POSTAL_CODE, location.getLatitude(), location.getLongitude());
		}

		public Location getLocation() {
			return location;
		}

		public String getCountry() {
			return country;
		}

		public String getCountryCode() {
			return countryCode;
		}

		public String getCity() {
			return city;
		}

		public String getAddress() {
			return address;
		}

		public String getPostalCode() {
			return postalCode;
		}		
	}
	
}
